/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.init.ApplySettingsException;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

class SpeedWindow
extends SetupWindow {
    ButtonGroup _speedGroup;
    JRadioButton _modem;
    JRadioButton _cable;
    JRadioButton _t1;
    JRadioButton _t3;

    SpeedWindow(SetupManager manager) {
        super(manager, "Connection Speed", "Please choose the speed of your Internet connection.  Setting this speed correctly is important for optimum network performance.  If you are not sure what type of Internet connection you have, or if your connection type is not listed, simply select whichever one seems the most appropriate.");
        BoxPanel mainPanel = new BoxPanel(0);
        BoxPanel buttonPanel = new BoxPanel(1);
        this._speedGroup = new ButtonGroup();
        this._modem = new JRadioButton("Modem");
        this._cable = new JRadioButton("Cable/DSL");
        this._t1 = new JRadioButton("T1");
        this._t3 = new JRadioButton("T3 or Higher");
        this._modem.setSelected(true);
        this._speedGroup.add(this._modem);
        this._speedGroup.add(this._cable);
        this._speedGroup.add(this._t1);
        this._speedGroup.add(this._t3);
        buttonPanel.add(this._modem);
        buttonPanel.add(this._cable);
        buttonPanel.add(this._t1);
        buttonPanel.add(this._t3);
        mainPanel.add(buttonPanel);
        mainPanel.add(Box.createHorizontalGlue());
        this.addSetupComponent(mainPanel);
    }

    public void applySettings() throws ApplySettingsException {
        int speed = this.getSpeed();
        this.setUploadsAndDownloads(speed);
        SettingsManager.instance().setConnectionSpeed(speed);
    }

    private int getSpeed() {
        if (this._cable.isSelected()) {
            return 350;
        }
        if (this._t1.isSelected()) {
            return 1000;
        }
        if (this._t3.isSelected()) {
            return 3000;
        }
        return 56;
    }

    private void setUploadsAndDownloads(int speed) {
        SettingsManager settings = SettingsManager.instance();
        if (speed == 56) {
            settings.setMaxSimDownload(3);
            settings.setMaxUploads(2);
        } else if (speed == 350) {
            settings.setMaxSimDownload(8);
            settings.setMaxUploads(6);
        } else if (speed == 1000) {
            settings.setMaxSimDownload(12);
            settings.setMaxUploads(8);
        } else if (speed == 3000) {
            settings.setMaxSimDownload(14);
            settings.setMaxUploads(10);
        } else {
            settings.setMaxSimDownload(3);
            settings.setMaxUploads(2);
        }
    }
}

