/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.gui.library.LibraryView;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

public class DragSourceListener
implements MouseInputListener {
    private LibraryView _libraryView;
    private int _lowerRow;
    private int _upperRow;
    private boolean _potentialDrop;
    private boolean _dragging;
    private boolean _outsideSelection;
    private ListSelectionModel _selectionModel;

    DragSourceListener(LibraryView library) {
        this._libraryView = library;
        this._selectionModel = this._libraryView.getTableSelectionModel();
        this._outsideSelection = false;
    }

    public void mousePressed(MouseEvent e) {
        this._outsideSelection = this._selectionModel.getMinSelectionIndex() < this._lowerRow || this._selectionModel.getMaxSelectionIndex() > this._upperRow;
        this._lowerRow = this._selectionModel.getMinSelectionIndex();
        this._upperRow = this._selectionModel.getMaxSelectionIndex();
        if (this._lowerRow != this._upperRow) {
            this._libraryView.setMultiSelection(true);
        } else {
            this._libraryView.setMultiSelection(false);
        }
    }

    public void mouseReleased(MouseEvent e) {
        int ic;
        if (this._libraryView.getTableMultiSelection() && !this._dragging && !this._outsideSelection && !SwingUtilities.isRightMouseButton(e) && (ic = this._libraryView.getTableIndexCandidate()) != -1) {
            this._libraryView.setMultiSelection(false);
            this._selectionModel.setSelectionInterval(ic, ic);
        }
        if (this._dragging) {
            this._dragging = false;
            this._libraryView.setCursors(Cursor.getPredefinedCursor(0));
            if (this._potentialDrop) {
                Point tableLocation = this._libraryView.getTableLocation();
                Point treeLocation = this._libraryView.getTreeLocation();
                Dimension tableDim = this._libraryView.getTableSize();
                Dimension treeDim = this._libraryView.getTreeSize();
                Point mousePoint = e.getPoint();
                Point screenMousePoint = new Point(tableLocation.x + mousePoint.x, tableLocation.y + mousePoint.y);
                int treeMaxX = treeLocation.x + treeDim.width;
                int treeMaxY = treeLocation.y + treeDim.height;
                if (screenMousePoint.x > treeLocation.x && screenMousePoint.x < treeMaxX && screenMousePoint.y > treeLocation.y && screenMousePoint.y < treeMaxY) {
                    Point mouseTreePoint = new Point(screenMousePoint.x - treeLocation.x, screenMousePoint.y - treeLocation.y);
                    this._libraryView.handleDropToTreePoint(mouseTreePoint);
                }
            }
        }
        this._potentialDrop = false;
    }

    public void mouseClicked(MouseEvent e) {
        if (SwingUtilities.isRightMouseButton(e)) {
            this._libraryView.showTablePopupMenu(e);
        } else if (e.getClickCount() == 2) {
            this._libraryView.launch();
        }
    }

    public void mouseEntered(MouseEvent e) {
        this._potentialDrop = false;
    }

    public void mouseExited(MouseEvent e) {
        this._potentialDrop = true;
    }

    public void mouseDragged(MouseEvent e) {
        if (this._libraryView.canDragAndDrop()) {
            this._libraryView.setCursors(Cursor.getPredefinedCursor(13));
            this._dragging = true;
        }
    }

    public void mouseMoved(MouseEvent e) {
    }
}

