/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.gui.GUIUtils;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.List;
import java.io.File;
import java.io.IOException;

class LibraryList
implements Comparator {
    private final int NAME_COL = 0;
    private final int SIZE_COL = 1;
    private final int TYPE_COL = 2;
    private final int PATH_COL = 3;
    private final int FILE_COL = 4;
    private ArrayList _arrayList;
    private boolean _ascending = true;
    private boolean _listOrderToggled = false;
    private int _sortColumn = 0;
    private Class _sortColumnClass = class$java$lang$String == null ? (class$java$lang$String = LibraryList.class$("java.lang.String")) : class$java$lang$String;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$library$LibraryList$SizeHolder;

    LibraryList() {
        this._arrayList = new ArrayList();
    }

    public int compare(Object a, Object b) {
        Object[] obj1 = (Object[])a;
        Object[] obj2 = (Object[])b;
        if (this._sortColumnClass == (class$java$lang$String == null ? (class$java$lang$String = LibraryList.class$("java.lang.String")) : class$java$lang$String)) {
            String value1 = ((String)obj1[this._sortColumn]).toLowerCase();
            String value2 = ((String)obj2[this._sortColumn]).toLowerCase();
            if (this._ascending) {
                return value1.compareTo(value2);
            }
            return value2.compareTo(value1);
        }
        if (this._sortColumnClass == (class$com$limegroup$gnutella$gui$library$LibraryList$SizeHolder == null ? (class$com$limegroup$gnutella$gui$library$LibraryList$SizeHolder = LibraryList.class$("com.limegroup.gnutella.gui.library.LibraryList$SizeHolder")) : class$com$limegroup$gnutella$gui$library$LibraryList$SizeHolder)) {
            int inta = ((SizeHolder)obj1[this._sortColumn]).getSize();
            int intb = ((SizeHolder)obj2[this._sortColumn]).getSize();
            if (this._ascending) {
                return -(inta - intb);
            }
            return inta - intb;
        }
        return -1;
    }

    void add(File file) {
        try {
            String fullPath = file.getCanonicalPath();
            String name = file.getName();
            String type = "";
            int index = name.lastIndexOf(".");
            int index2 = fullPath.lastIndexOf(File.separator);
            String path = fullPath.substring(0, index2);
            if (index != -1 && index != 0) {
                type = name.substring(index + 1);
                name = name.substring(0, index);
            }
            Long l = new Long(file.length());
            SizeHolder size = new SizeHolder(l.intValue());
            Object[] objs = new Object[]{name, size, type, path, file};
            this._arrayList.add((Object)objs);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void handleFileChangeInternal(int row, File file) {
        this.setValueAt(file, row, 4);
    }

    void remove(int row) {
        this._arrayList.remove(row);
    }

    int size() {
        return this._arrayList.size();
    }

    Object getValueAt(int row, int col) {
        Object[] objs = (Object[])this._arrayList.get(row);
        return objs[col];
    }

    void setValueAt(Object value, int row, int col) {
        Object[] objs = (Object[])this._arrayList.get(row);
        objs[col] = value;
    }

    String getType(int row) {
        Object[] objs = (Object[])this._arrayList.get(row);
        return (String)objs[2];
    }

    File getFile(int row) {
        Object[] objs = (Object[])this._arrayList.get(row);
        return (File)objs[4];
    }

    String getName(int row) {
        Object[] objs = (Object[])this._arrayList.get(row);
        return (String)objs[0];
    }

    void sort(int col, Class currentClass) {
        this._sortColumn = col;
        this._sortColumnClass = currentClass;
        Collections.sort((List)this._arrayList, (Comparator)this);
        this._listOrderToggled = true;
        this._ascending = !this._ascending;
    }

    void clear() {
        this._arrayList.clear();
    }

    void handleRefresh() {
        if (this._listOrderToggled) {
            this._ascending = !this._ascending;
        }
        this._listOrderToggled = false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SizeHolder {
        String _string;
        int _size;

        private SizeHolder(int size) {
            this._string = GUIUtils.toKilobytes(size);
            this._size = size;
        }

        public String toString() {
            return this._string;
        }

        private int getSize() {
            return this._size;
        }
    }
}

