/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.library.DragSourceListener;
import com.limegroup.gnutella.gui.library.LibraryList;
import com.limegroup.gnutella.gui.library.LibraryTableCellEditor;
import com.limegroup.gnutella.gui.library.LibraryTableModel;
import com.limegroup.gnutella.gui.library.LibraryView;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;

public class LibraryTable {
    private LibraryView _libraryView;
    private JTable _table;
    private LibraryList _list;
    private AbstractTableModel _tableModel;
    private String _currentDirectory;
    private boolean _shiftPressed;
    private boolean _multiSelection;
    private int _indexCandidate;
    private FileManager _fileManager;
    private final JPopupMenu _popupMenu = new JPopupMenu();
    static /* synthetic */ Class class$java$lang$String;

    LibraryTable(LibraryView libraryView) {
        this._libraryView = libraryView;
        this._table = new JTable();
        this._list = new LibraryList();
        this._tableModel = new LibraryTableModel(this._table, this._list);
        this._table.setModel(this._tableModel);
        this._table.getTableHeader().addMouseListener(new ColumnSorter());
        this._table.getColumnModel().getColumn(0).setPreferredWidth(150);
        this._table.getColumnModel().getColumn(1).setPreferredWidth(40);
        this._table.getColumnModel().getColumn(2).setPreferredWidth(30);
        this._table.getColumnModel().getColumn(3).setPreferredWidth(120);
        this._table.setColumnSelectionAllowed(false);
        this._table.setShowGrid(false);
        this._table.addKeyListener(new LibraryKeyListener());
        LibraryListSelectionModel selectionModel = new LibraryListSelectionModel();
        selectionModel.setSelectionMode(1);
        this._table.setSelectionModel(selectionModel);
        this._table.setDefaultEditor(class$java$lang$String == null ? (class$java$lang$String = LibraryTable.class$("java.lang.String")) : class$java$lang$String, new LibraryTableCellEditor(this));
    }

    void addMouseListeners(DragSourceListener listener) {
        this._table.addMouseListener(listener);
        this._table.addMouseMotionListener(listener);
    }

    void addSharedFile(File file) {
        if (this._table.isEditing()) {
            TableCellEditor editor = this._table.getCellEditor();
            editor.cancelCellEditing();
        }
        this._list.add(file);
        int size = this._list.size() - 1;
        this._tableModel.fireTableRowsInserted(size, size);
    }

    void makePopupMenu(ActionListener[] listeners) {
        JMenuItem launchItem = new JMenuItem("Launch");
        JMenuItem deleteItem = new JMenuItem("Delete");
        JMenuItem refreshItem = new JMenuItem("Refresh");
        launchItem.addActionListener(listeners[0]);
        deleteItem.addActionListener(listeners[1]);
        refreshItem.addActionListener(listeners[2]);
        this._popupMenu.add(launchItem);
        this._popupMenu.add(deleteItem);
        this._popupMenu.add(refreshItem);
    }

    void showPopup(MouseEvent e) {
        this._popupMenu.show(this._table, e.getX(), e.getY());
    }

    File getFile(int row) {
        return this._list.getFile(row);
    }

    void setMultiSelection(boolean multiSelection) {
        this._multiSelection = multiSelection;
    }

    boolean getMultiSelection() {
        return this._multiSelection;
    }

    int getIndexCandidate() {
        return this._indexCandidate;
    }

    JTable getTable() {
        return this._table;
    }

    ListSelectionModel getSelectionModel() {
        return this._table.getSelectionModel();
    }

    void clear() {
        this._table.getSelectionModel().clearSelection();
        this._list.clear();
        this._tableModel.fireTableRowsDeleted(0, this._list.size());
    }

    void handleRefresh() {
        this._list.handleRefresh();
        this.clear();
    }

    void deleteRows() {
        int[] rows = this._table.getSelectedRows();
        if (rows.length > 0) {
            String msgKey = "MESSAGE_CONFIRM_FILE_DELETE";
            int response = GUIMediator.instance().showYesNoMessage(msgKey);
            GUIMediator.instance();
            if (response != 101) {
                return;
            }
            if (this._table.isEditing()) {
                TableCellEditor editor = this._table.getCellEditor();
                editor.cancelCellEditing();
            }
            int i = rows.length;
            --i;
            while (i >= 0) {
                File file = this._list.getFile(rows[i]);
                if (file.delete()) {
                    this._list.remove(rows[i]);
                    this._tableModel.fireTableRowsDeleted(rows[i], rows[i]);
                    FileManager.instance().removeFileIfShared(file);
                } else {
                    String key1 = "MESSAGE_UNABLE_TO_DELETE_FILE_START";
                    String key2 = "MESSAGE_UNABLE_TO_DELETE_FILE_END";
                    String msg = "'" + file.getName() + "'.";
                    GUIMediator.instance().showError("MESSAGE_UNABLE_TO_DELETE_FILE_START", msg, "MESSAGE_UNABLE_TO_DELETE_FILE_END");
                }
                --i;
            }
            this._table.getSelectionModel().clearSelection();
        }
    }

    void launch() {
        int[] rows = this._table.getSelectedRows();
        int i = 0;
        int l = rows.length;
        while (i < l) {
            try {
                GUIMediator.instance().launchFile(this._list.getFile(rows[i]));
            }
            catch (IOException ioe) {
                // empty catch block
            }
            ++i;
        }
    }

    String handleNameChange(String newName) {
        int row = this._table.getEditingRow();
        File oldFile = this._list.getFile(row);
        String parent = oldFile.getParent();
        String nameToReturn = newName;
        newName = newName + "." + this._list.getType(row);
        File newFile = new File(parent, newName);
        if (!this._list.getName(row).equals(newName)) {
            boolean b = oldFile.renameTo(newFile);
            if (b) {
                FileManager.instance().renameFileIfShared(oldFile, newFile);
                this._list.handleFileChangeInternal(row, newFile);
                return nameToReturn;
            }
            String key1 = "MESSAGE_UNABLE_TO_RENAME_FILE_START";
            String key2 = "MESSAGE_UNABLE_TO_RENAME_FILE_END";
            String msg = "'" + this._list.getName(row) + "'.";
            GUIMediator.instance().showError("MESSAGE_UNABLE_TO_RENAME_FILE_START", msg, "MESSAGE_UNABLE_TO_RENAME_FILE_END");
            return this._list.getName(row);
        }
        return nameToReturn;
    }

    boolean canDragAndDrop() {
        int[] rows = this._table.getSelectedRows();
        return rows.length > 0 && !this._table.isEditing();
    }

    void setCursor(Cursor cursor) {
        this._table.setCursor(cursor);
    }

    Point getTableLocation() {
        return this._table.getLocationOnScreen();
    }

    Dimension getTableSize() {
        return this._table.getSize();
    }

    int[] getSelectedRows() {
        return this._table.getSelectedRows();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class LibraryListSelectionModel
    extends DefaultListSelectionModel {
        private LibraryListSelectionModel() {
        }

        public void setSelectionInterval(int index0, int index1) {
            LibraryTable.this._indexCandidate = -1;
            if (LibraryTable.this._multiSelection) {
                LibraryTable.this._indexCandidate = index0;
            }
            if (!LibraryTable.this._multiSelection) {
                super.setSelectionInterval(index0, index1);
            } else if (this.getMinSelectionIndex() > index0 || this.getMaxSelectionIndex() < index1) {
                super.setSelectionInterval(index0, index1);
            } else {
                LibraryTable.this._indexCandidate = index0;
            }
        }

        public void setLeadSelectionIndex(int index) {
            if (LibraryTable.this._shiftPressed) {
                super.setLeadSelectionIndex(index);
            }
        }
    }

    private class LibraryKeyListener
    implements KeyListener {
        private LibraryKeyListener() {
        }

        public void keyTyped(KeyEvent e) {
            if (e.getKeyChar() != '\b') {
                return;
            }
            LibraryTable.this.deleteRows();
        }

        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 16) {
                LibraryTable.this._shiftPressed = true;
            }
        }

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 16) {
                LibraryTable.this._shiftPressed = false;
            }
        }
    }

    private class ColumnSorter
    extends MouseAdapter {
        private ColumnSorter() {
        }

        public void mouseClicked(MouseEvent e) {
            TableColumnModel columnModel = LibraryTable.this._table.getColumnModel();
            int col = columnModel.getColumnIndexAtX(e.getX());
            int c = LibraryTable.this._table.convertColumnIndexToModel(col);
            if (e.getClickCount() == 1 && c != -1) {
                Class<?> currentClass = LibraryTable.this._tableModel.getColumnClass(c);
                LibraryTable.this._list.sort(c, currentClass);
                LibraryTable.this._tableModel.fireTableDataChanged();
            }
        }
    }
}

