/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.gui.library.LibraryTable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

class LibraryTableCellEditor
implements TableCellEditor {
    private final JTextField _textField = new JTextField();
    private final TextFieldListener _textFieldListener = new TextFieldListener();
    private LibraryTable _libraryTable;
    private CellEditorListener _cellEditorListener;

    LibraryTableCellEditor(LibraryTable libraryTable) {
        this._libraryTable = libraryTable;
        this._cellEditorListener = null;
        this._textField.addActionListener(this._textFieldListener);
    }

    public Object getCellEditorValue() {
        String newName = this._textField.getText();
        return this._libraryTable.handleNameChange(newName);
    }

    public boolean isCellEditable(EventObject event) {
        if (event instanceof MouseEvent) {
            boolean b;
            boolean bl = b = ((MouseEvent)event).getClickCount() == 1;
            if (b) {
                this._textField.selectAll();
                return true;
            }
            return false;
        }
        return false;
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public void addCellEditorListener(CellEditorListener listener) {
        this._cellEditorListener = listener;
    }

    public void removeCellEditorListener(CellEditorListener listener) {
        this._cellEditorListener = null;
    }

    void fireEditingStopped() {
        if (this._cellEditorListener != null) {
            this._cellEditorListener.editingStopped(new ChangeEvent(this));
        }
    }

    void fireEditingCanceled() {
        if (this._cellEditorListener != null) {
            this._cellEditorListener.editingCanceled(new ChangeEvent(this));
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this._textField.setText(value != null ? value.toString() : "");
        this._textField.selectAll();
        return this._textField;
    }

    private class TextFieldListener
    implements ActionListener {
        private TextFieldListener() {
        }

        public void actionPerformed(ActionEvent e) {
            LibraryTableCellEditor.this.fireEditingStopped();
        }
    }
}

