/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.library.LibraryTreeCellEditor;
import com.limegroup.gnutella.gui.library.LibraryView;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class LibraryTree {
    private final String INCOMPLETE_FILE_NAME = "Incomplete";
    private LibraryView _libraryView;
    private JTree _tree;
    private DefaultTreeModel _treeModel;
    private LibraryTreeNode _rootNode;
    private AbstractFileHolder _currentTreeFileHolder;
    private LibraryTreeNode _currentTreeNode;
    private int _currentTreeRow;
    private SettingsManager _settings;
    private final JPopupMenu _directoryPopup = new JPopupMenu();
    private boolean _isFirstDirectoryAdded = true;

    LibraryTree(LibraryView libraryView) {
        this._libraryView = libraryView;
        this._tree = new JTree();
        this._rootNode = new LibraryTreeNode();
        this._treeModel = new DefaultTreeModel(this._rootNode);
        this._tree.setModel(this._treeModel);
        this._settings = SettingsManager.instance();
        this._tree.setRootVisible(false);
        this._tree.getSelectionModel().setSelectionMode(1);
        this._tree.setEditable(true);
        this._tree.setInvokesStopCellEditing(true);
        this._tree.setShowsRootHandles(true);
        this._tree.putClientProperty("JTree.lineStyle", "None");
        this.makePopupMenu();
        this._tree.addTreeSelectionListener(new LibraryTreeSelectionListener());
        this._tree.setCellEditor(new DefaultTreeCellEditor(this._tree, (DefaultTreeCellRenderer)this._tree.getCellRenderer(), new LibraryTreeCellEditor(this)));
        this.addIncompleteDirectory();
    }

    void addSharedDirectory(File dir, File parent) {
        LibraryTreeNode curNode = null;
        LibraryTreeNode nodeToLoad = null;
        InternalNodeFileHolder holder = null;
        if (parent == null) {
            if (!this._rootNode.isChild(dir)) {
                holder = new InternalNodeFileHolder(dir);
                curNode = new LibraryTreeNode(holder);
                this._treeModel.insertNodeInto(curNode, this._rootNode, this._rootNode.getChildCount() - 1);
                nodeToLoad = this._rootNode;
            }
        } else {
            AbstractFileHolder curHolder = null;
            Enumeration<TreeNode> enumeration = this._rootNode.breadthFirstEnumeration();
            if (enumeration.hasMoreElements()) {
                while (enumeration.hasMoreElements()) {
                    curNode = (LibraryTreeNode)enumeration.nextElement();
                    curHolder = curNode.getFileHolder();
                    if (!curHolder.matchesFile(parent)) continue;
                    if (!curNode.isChild(dir)) {
                        holder = new InternalNodeFileHolder(dir);
                        LibraryTreeNode newNode = new LibraryTreeNode(holder);
                        this._treeModel.insertNodeInto(newNode, curNode, curNode.getChildCount());
                        nodeToLoad = curNode;
                    }
                    break;
                }
            } else {
                InternalNodeFileHolder newHolder = new InternalNodeFileHolder(dir);
                curNode = new LibraryTreeNode(newHolder);
                this._treeModel.insertNodeInto(curNode, this._rootNode, this._rootNode.getChildCount() - 1);
                nodeToLoad = this._rootNode;
            }
        }
        if (this._isFirstDirectoryAdded) {
            this._isFirstDirectoryAdded = false;
            this._currentTreeFileHolder = holder;
        }
        this._treeModel.reload(nodeToLoad);
    }

    void addNewLibraryFolder() {
        if (this._currentTreeFileHolder != null) {
            if (!this.incompleteDirectoryIsSelected()) {
                File curFile = this._currentTreeFileHolder.getFile();
                File file = new File(curFile, "New Folder");
                int number = 2;
                boolean dirMade = false;
                while (!dirMade) {
                    dirMade = file.mkdir();
                    if (dirMade) {
                        LibraryTreeNode node = new LibraryTreeNode(new InternalNodeFileHolder(file));
                        this._treeModel.insertNodeInto(node, this._currentTreeNode, this._currentTreeNode.getChildCount());
                        this._tree.expandRow(this._currentTreeRow);
                        this._tree.setSelectionRow(this._currentTreeRow + this._currentTreeNode.getChildCount());
                        this._libraryView.refresh();
                    } else {
                        file = new File(curFile, "New Folder (" + String.valueOf(number) + ")");
                    }
                    ++number;
                }
            } else {
                this.showIncompleteFolderMessage("add a new folder to");
            }
        }
    }

    void renameLibraryFolder() {
        if (this._currentTreeFileHolder != null) {
            if (!this.incompleteDirectoryIsSelected()) {
                this._tree.startEditingAtPath(this._tree.getPathForRow(this._currentTreeRow));
            } else {
                this.showIncompleteFolderMessage("rename");
            }
        }
    }

    File getFileForPoint(Point mousePoint) {
        TreePath path = this._tree.getPathForLocation(mousePoint.x, mousePoint.y);
        if (path != null) {
            LibraryTreeNode node = (LibraryTreeNode)path.getLastPathComponent();
            AbstractFileHolder fh = node.getFileHolder();
            File file = fh.getFile();
            if (file.isDirectory()) {
                return file;
            }
            return null;
        }
        return null;
    }

    boolean droppingToIncompleteFolder(Point mousePoint) {
        TreePath path = this._tree.getPathForLocation(mousePoint.x, mousePoint.y);
        if (path == null) {
            return false;
        }
        LibraryTreeNode node = (LibraryTreeNode)path.getLastPathComponent();
        AbstractFileHolder fh = node.getFileHolder();
        return this.isIncompleteDirectory(fh);
    }

    File getSelectedDirectory() {
        return this._currentTreeFileHolder.getFile();
    }

    String getSharedDirectories() {
        StringBuffer sb = new StringBuffer();
        String name = "";
        int i = 0;
        int length = this._rootNode.getChildCount();
        while (i < length) {
            LibraryTreeNode curNode = (LibraryTreeNode)this._rootNode.getChildAt(i);
            AbstractFileHolder fh = curNode.getFileHolder();
            if (!this.isIncompleteDirectory(fh)) {
                File f = fh.getFile();
                String newDir = "";
                if (f.isDirectory()) {
                    try {
                        newDir = f.getCanonicalPath();
                        sb.append(newDir);
                        sb.append(';');
                    }
                    catch (IOException ioe) {
                        break;
                    }
                }
            }
            ++i;
        }
        return sb.toString();
    }

    void setSelectionRow(int row) {
        this._tree.setSelectionRow(row);
    }

    boolean parentIsSelected(File parent) {
        if (this._currentTreeFileHolder != null) {
            return this._currentTreeFileHolder.matchesFile(parent);
        }
        return false;
    }

    void clear() {
        this._rootNode.removeAllChildren();
        this._isFirstDirectoryAdded = true;
        this._currentTreeFileHolder = null;
        this._currentTreeNode = null;
        this._currentTreeRow = -1;
        this.addIncompleteDirectory();
    }

    Object handleNameChange(String newName) {
        File newFile;
        boolean b;
        File f;
        String parent;
        if (this._currentTreeFileHolder != null && !newName.equals(this._currentTreeFileHolder.toString()) && (parent = (f = this._currentTreeFileHolder.getFile()).getParent()) != null && (b = f.renameTo(newFile = new File(parent, newName)))) {
            InternalNodeFileHolder fh = new InternalNodeFileHolder(newFile);
            this._currentTreeNode.setUserObject(fh);
            this._currentTreeFileHolder = fh;
            this._treeModel.nodeChanged(this._currentTreeNode);
            if (!this._currentTreeNode.isLeaf()) {
                this._currentTreeNode.removeAllChildren();
            }
            this.handleDirectoryChange(this._currentTreeNode);
        }
        return this._currentTreeFileHolder;
    }

    void deleteLibraryFolder() {
        if (this._currentTreeFileHolder != null) {
            if (!this.incompleteDirectoryIsSelected()) {
                String msgKey = "MESSAGE_CONFIRM_DIRECTORY_DELETE";
                int response = GUIMediator.instance().showYesNoMessage(msgKey);
                GUIMediator.instance();
                if (response != 101) {
                    return;
                }
                if (this._currentTreeNode != null) {
                    this.deleteLibraryFolderInternal(this._currentTreeNode);
                }
            } else {
                this.showIncompleteFolderMessage("delete");
            }
        }
    }

    boolean incompleteDirectoryIsSelected() {
        if (this._currentTreeFileHolder != null) {
            return this.isIncompleteDirectory(this._currentTreeFileHolder);
        }
        return false;
    }

    void setCursor(Cursor cursor) {
        this._tree.setCursor(cursor);
    }

    Point getTreeLocation() {
        return this._tree.getLocationOnScreen();
    }

    Dimension getTreeSize() {
        return this._tree.getSize();
    }

    JTree getTree() {
        return this._tree;
    }

    private boolean isIncompleteDirectory(AbstractFileHolder holder) {
        return holder.toString().equals("Incomplete");
    }

    private void addIncompleteDirectory() {
        try {
            File incFile = this._settings.getIncompleteDirectory();
            InternalNodeFileHolder fh = new InternalNodeFileHolder(incFile);
            LibraryTreeNode node = new LibraryTreeNode(fh);
            this._treeModel.insertNodeInto(node, this._rootNode, 0);
            this._treeModel.reload(this._rootNode);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void showIncompleteFolderMessage(String action) {
        String key1 = "MESSAGE_INCOMPLETE_DIRECTORY_START";
        String key2 = "MESSAGE_INCOMPLETE_DIRECTORY_END";
        GUIMediator.instance().showError(key1 + action + key2);
    }

    private void deleteLibraryFolderInternal(final LibraryTreeNode node) {
        Thread deleteFolderThread = new Thread(){

            public void run() {
                AbstractFileHolder lf = node.getFileHolder();
                File file = lf.getFile();
                if (file.isDirectory() && LibraryTree.this.deleteFolderRecursively(node)) {
                    LibraryTree.this._currentTreeFileHolder = null;
                    LibraryTree.this._currentTreeNode = null;
                    LibraryTree.this._currentTreeRow = -1;
                }
            }
        };
        deleteFolderThread.setDaemon(true);
        deleteFolderThread.start();
    }

    private boolean deleteFolderRecursively(final LibraryTreeNode node) {
        int folderIndex = node.getChildCount();
        --folderIndex;
        while (folderIndex >= 0) {
            LibraryTreeNode curNode = (LibraryTreeNode)node.getChildAt(folderIndex);
            if (!this.deleteFolderRecursively(curNode)) {
                return false;
            }
            --folderIndex;
        }
        AbstractFileHolder fh = node.getFileHolder();
        File dirFile = fh.getFile();
        String fullPath = "";
        String dirPath = "";
        try {
            dirPath = dirFile.getCanonicalPath();
        }
        catch (IOException ioe) {
            this.showFolderDeletionError(dirFile.toString());
            return false;
        }
        String[] fileNames = dirFile.list();
        if (fileNames != null) {
            int fileIndex = fileNames.length;
            --fileIndex;
            while (fileIndex >= 0) {
                File curFile = new File(dirPath, fileNames[fileIndex]);
                if (!curFile.delete()) {
                    this.showFileDeletionError(curFile.toString());
                    return false;
                }
                FileManager.instance().removeFileIfShared(curFile);
                --fileIndex;
            }
        }
        if (!dirFile.delete()) {
            this.showFolderDeletionError(dirFile.toString());
            return false;
        }
        this.handleDirectoryChange(node);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LibraryTree.this._treeModel.removeNodeFromParent(node);
            }
        });
        return true;
    }

    private void showFileDeletionError(String fileName) {
        String key1 = "MESSAGE_UNABLE_TO_DELETE_FILE_START";
        String key2 = "MESSAGE_UNABLE_TO_DELETE_FILE_END";
        String msg = "'" + fileName + "'.";
        GUIMediator.instance().showError("MESSAGE_UNABLE_TO_DELETE_FILE_START", msg, "MESSAGE_UNABLE_TO_DELETE_FILE_END");
    }

    private void showFolderDeletionError(String folderName) {
        String key1 = "MESSAGE_UNABLE_TO_DELETE_DIRECTORY_START";
        String key2 = "MESSAGE_UNABLE_TO_DELETE_DIRECTORY_END";
        String msg = "'" + folderName + "'.";
        GUIMediator.instance().showError("MESSAGE_UNABLE_TO_DELETE_DIRECTORY_START", msg, "MESSAGE_UNABLE_TO_DELETE_DIRECTORY_END");
    }

    private void handleDirectoryChange(LibraryTreeNode node) {
        if (node.getLibraryTreeNodeParent().isRoot()) {
            this._libraryView.handleRootSharedDirectoryChange();
        } else {
            this._libraryView.refresh();
        }
    }

    private void makePopupMenu() {
        JMenuItem newItem = new JMenuItem("New Folder");
        JMenuItem deleteItem = new JMenuItem("Delete");
        JMenuItem renameItem = new JMenuItem("Rename");
        newItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LibraryTree.this.addNewLibraryFolder();
            }
        });
        deleteItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LibraryTree.this.deleteLibraryFolder();
            }
        });
        renameItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LibraryTree.this.renameLibraryFolder();
            }
        });
        this._directoryPopup.add(newItem);
        this._directoryPopup.add(deleteItem);
        this._directoryPopup.add(renameItem);
        MouseAdapter ml = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int row = LibraryTree.this._tree.getRowForLocation(e.getX(), e.getY());
                if (row != -1) {
                    LibraryTree.this._tree.setSelectionRow(row);
                    if (SwingUtilities.isRightMouseButton(e) && !LibraryTree.this.incompleteDirectoryIsSelected()) {
                        LibraryTree.this._directoryPopup.show(LibraryTree.this._tree, e.getX(), e.getY());
                    }
                }
            }
        };
        this._tree.addMouseListener(ml);
    }

    private class RootNodeFileHolder
    extends AbstractFileHolder {
        private RootNodeFileHolder() {
        }

        protected File getFile() {
            return null;
        }

        protected boolean matchesFile(File file) {
            return false;
        }

        protected boolean matchesPath(File file) {
            return false;
        }

        public String toString() {
            return "";
        }
    }

    private class InternalNodeFileHolder
    extends AbstractFileHolder {
        private File _file;
        private String _name;
        private String _path;

        protected InternalNodeFileHolder(File file) {
            try {
                this._file = file;
                this._path = file.getCanonicalPath();
                this._name = file.getName();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        protected File getFile() {
            return this._file;
        }

        protected boolean matchesFile(File file) {
            return this._file.equals(file);
        }

        protected boolean matchesPath(File file) {
            String path = "";
            try {
                path = file.getCanonicalPath();
                if (path.equals(this._path)) {
                    return true;
                }
            }
            catch (IOException ioe) {
                return false;
            }
            return false;
        }

        public String toString() {
            return this._name;
        }
    }

    private abstract class AbstractFileHolder {
        private AbstractFileHolder() {
        }

        protected abstract File getFile();

        protected abstract boolean matchesFile(File var1);

        protected abstract boolean matchesPath(File var1);

        public abstract String toString();
    }

    private class LibraryTreeNode
    extends DefaultMutableTreeNode {
        private AbstractFileHolder _holder;

        private LibraryTreeNode() {
            this._holder = new RootNodeFileHolder();
        }

        private LibraryTreeNode(AbstractFileHolder holder) {
            super(holder);
            this._holder = holder;
        }

        private AbstractFileHolder getFileHolder() {
            return this._holder;
        }

        private boolean isChild(File file) {
            int i = 0;
            int count = this.getChildCount();
            while (i < count) {
                LibraryTreeNode curNode = (LibraryTreeNode)this.getChildAt(i);
                AbstractFileHolder fh = curNode.getFileHolder();
                if (fh.matchesPath(file)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private void setUserObject(AbstractFileHolder holder) {
            super.setUserObject(holder);
            this._holder = holder;
        }

        private LibraryTreeNode getLibraryTreeNodeParent() {
            return (LibraryTreeNode)super.getParent();
        }
    }

    private class LibraryTreeSelectionListener
    implements TreeSelectionListener {
        private LibraryTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent e) {
            LibraryTreeNode node = (LibraryTreeNode)LibraryTree.this._tree.getLastSelectedPathComponent();
            if (node != null) {
                LibraryTree.this._currentTreeFileHolder = node.getFileHolder();
                LibraryTree.this._currentTreeNode = node;
                LibraryTree.this._currentTreeRow = LibraryTree.this._tree.getLeadSelectionRow();
                if (!LibraryTree.this.incompleteDirectoryIsSelected()) {
                    LibraryTree.this._libraryView.updateTableFiles(LibraryTree.this._currentTreeFileHolder.getFile());
                } else {
                    LibraryTree.this._libraryView.showIncompleteFiles();
                }
            }
        }
    }
}

