/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.gui.library.LibraryTree;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreeCellEditor;

class LibraryTreeCellEditor
implements TreeCellEditor {
    private final JTextField _textField = new JTextField();
    private final TextFieldListener _textFieldListener = new TextFieldListener();
    private LibraryTree _libraryTree;
    private CellEditorListener _cellEditorListener;

    LibraryTreeCellEditor(LibraryTree libraryTree) {
        this._libraryTree = libraryTree;
        this._cellEditorListener = null;
        this._textField.addActionListener(this._textFieldListener);
    }

    public Object getCellEditorValue() {
        String newName = this._textField.getText();
        return this._libraryTree.handleNameChange(newName);
    }

    public boolean isCellEditable(EventObject event) {
        if (event instanceof MouseEvent) {
            boolean isEditable;
            boolean bl = isEditable = ((MouseEvent)event).getClickCount() == 1;
            return isEditable && !this._libraryTree.incompleteDirectoryIsSelected();
        }
        return true;
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public void addCellEditorListener(CellEditorListener listener) {
        this._cellEditorListener = listener;
    }

    public void removeCellEditorListener(CellEditorListener listener) {
        this._cellEditorListener = null;
    }

    void fireEditingStopped() {
        if (this._cellEditorListener != null) {
            this._cellEditorListener.editingStopped(new ChangeEvent(this));
        }
    }

    void fireEditingCanceled() {
        if (this._cellEditorListener != null) {
            this._cellEditorListener.editingCanceled(new ChangeEvent(this));
        }
    }

    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row) {
        this._textField.setText(value != null ? value.toString() : "");
        return this._textField;
    }

    private class TextFieldListener
    implements ActionListener {
        private TextFieldListener() {
        }

        public void actionPerformed(ActionEvent e) {
            LibraryTreeCellEditor.this.fireEditingStopped();
        }
    }
}

