/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.library.DragSourceListener;
import com.limegroup.gnutella.gui.library.LibraryTable;
import com.limegroup.gnutella.gui.library.LibraryTree;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListSelectionModel;

public class LibraryView
extends PaddedPanel {
    private final SettingsManager _settings = SettingsManager.instance();
    private DragSourceListener _mouseListener;
    private LibraryTree _libraryTree;
    private LibraryTable _libraryTable;
    private JFileChooser _fileChooser;
    private final FileManager _fileManager = FileManager.instance();
    private final GUIMediator _mediator = GUIMediator.instance();

    public LibraryView() {
        this._fileChooser = new JFileChooser();
        this._fileChooser.setFileSelectionMode(1);
        this._fileChooser.setDialogTitle("Select Directory");
        this._libraryTable = new LibraryTable(this);
        this._libraryTree = new LibraryTree(this);
        this._mouseListener = new DragSourceListener(this);
        this._libraryTable.addMouseListeners(this._mouseListener);
        JPanel tablePane = new JPanel();
        JScrollPane tableScrollPane = new JScrollPane(this._libraryTable.getTable());
        JScrollPane treeScrollPane = new JScrollPane(this._libraryTree.getTree());
        tablePane.setBackground(Color.white);
        tableScrollPane.getViewport().setBackground(Color.white);
        treeScrollPane.getViewport().setBackground(Color.white);
        tablePane.setLayout(new BoxLayout(tablePane, 1));
        tablePane.add(tableScrollPane);
        Box splitBox = new Box(0);
        JSplitPane splitPane = new JSplitPane(1, treeScrollPane, tablePane);
        splitPane.setDividerLocation(150);
        splitPane.setOneTouchExpandable(true);
        splitBox.add(splitPane);
        this.add(splitBox);
        String[] buttonLabelKeys = new String[]{"LIBRARY_LAUNCH_BUTTON_LABEL", "LIBRARY_DELETE_BUTTON_LABEL", "LIBRARY_REFRESH_BUTTON_LABEL"};
        String[] toolTipKeys = new String[]{"LIBRARY_LAUNCH_BUTTON_TIP", "LIBRARY_DELETE_BUTTON_TIP", "LIBRARY_REFRESH_BUTTON_TIP"};
        ActionListener[] listeners = new ActionListener[]{new LaunchListener(), new DeleteListener(), new RefreshListener()};
        this._libraryTable.makePopupMenu(listeners);
        this.add(Box.createVerticalStrut(6));
        ButtonRow buttons = new ButtonRow(buttonLabelKeys, toolTipKeys, listeners, 0, 14);
        BoxPanel buttonPanel = new BoxPanel(0);
        JLabel linkLabel = new JLabel();
        FontMetrics fm = ((Component)linkLabel).getFontMetrics(linkLabel.getFont());
        int width = fm.stringWidth("123456789/123");
        Dimension dim = new Dimension(width, fm.getHeight());
        String link = "<html><a href=\"nothing important here\">Burn CD...</a></html>";
        linkLabel.setText(link);
        String url = "http://www.limewire.com/ads/burn/pc.htm";
        if (CommonUtils.isMacClassic() || CommonUtils.isMacOSX()) {
            url = "http://www.limewire.com/ads/burn/mac.htm";
        }
        final String finalURL = url;
        linkLabel.setPreferredSize(dim);
        linkLabel.setMaximumSize(dim);
        MouseAdapter linkLabelListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                try {
                    LibraryView.this._mediator.openURL(finalURL);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        };
        linkLabel.addMouseListener(linkLabelListener);
        buttonPanel.add(buttons);
        buttonPanel.add(linkLabel);
        buttonPanel.add(Box.createRigidArea(new Dimension(6, 0)));
        this.add(buttonPanel);
    }

    public void launch() {
        this._libraryTable.launch();
    }

    public void deleteLibraryFile() {
        this._libraryTable.deleteRows();
    }

    public void clearLibrary() {
        this._libraryTree.clear();
        this._libraryTable.clear();
    }

    public void refresh() {
        this._libraryTable.handleRefresh();
        if (this._libraryTree.incompleteDirectoryIsSelected()) {
            this.showIncompleteFiles();
        } else {
            this._fileManager.loadSettings(false);
        }
    }

    public void addSharedLibraryFolder() {
        String s = "Select";
        int i = this._fileChooser.showDialog(this, s);
        if (i == 0) {
            File dir = this._fileChooser.getSelectedFile();
            try {
                this._settings.addDirectory(dir);
                this._fileManager.loadSettings(false);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }

    public void handleRootSharedDirectoryChange() {
        String sharedDirectories = this._libraryTree.getSharedDirectories();
        this._settings.setDirectories(sharedDirectories);
        this._fileManager.loadSettings(true);
    }

    public void addSharedDirectory(File dir, File parent) {
        this._libraryTree.addSharedDirectory(dir, parent);
    }

    public void addSharedFile(File file, File parent) {
        if (this._libraryTree.parentIsSelected(parent)) {
            this._libraryTable.addSharedFile(file);
        }
    }

    public void addNewLibraryFolder() {
        this._libraryTree.addNewLibraryFolder();
    }

    public void deleteLibraryFolder() {
        this._libraryTree.deleteLibraryFolder();
    }

    public void renameLibraryFolder() {
        this._libraryTree.renameLibraryFolder();
    }

    void updateTableFiles(File selectedDir) {
        File[] files = GUIMediator.instance().getRouter().getSharedFiles(selectedDir);
        if (files != null) {
            this._libraryTable.clear();
            int i = 0;
            while (i < files.length) {
                this._libraryTable.addSharedFile(files[i]);
                ++i;
            }
        } else {
            this._libraryTable.clear();
        }
    }

    void showIncompleteFiles() {
        this._libraryTable.clear();
        File incFile = null;
        try {
            incFile = this._settings.getIncompleteDirectory();
        }
        catch (FileNotFoundException fnfe) {
            return;
        }
        String[] fileNames = incFile.list();
        if (fileNames != null) {
            int i = 0;
            while (i < fileNames.length) {
                File curFile;
                if (!fileNames[i].equals("downloads.dat") && (curFile = new File(incFile, fileNames[i])).isFile()) {
                    this._libraryTable.addSharedFile(curFile);
                }
                ++i;
            }
        }
    }

    boolean canDragAndDrop() {
        return this._libraryTable.canDragAndDrop();
    }

    void setMultiSelection(boolean multiSelection) {
        this._libraryTable.setMultiSelection(multiSelection);
    }

    boolean getTableMultiSelection() {
        return this._libraryTable.getMultiSelection();
    }

    void handleDropToTreePoint(Point mousePoint) {
        File file = this._libraryTree.getFileForPoint(mousePoint);
        boolean droppingToIncomplete = this._libraryTree.droppingToIncompleteFolder(mousePoint);
        boolean draggingFromIncomplete = this._libraryTree.incompleteDirectoryIsSelected();
        if (file != null) {
            String newFilePath = "";
            try {
                newFilePath = file.getCanonicalPath();
            }
            catch (IOException ioe) {
                return;
            }
            int[] rows = this._libraryTable.getSelectedRows();
            int length = rows.length;
            --length;
            while (length >= 0) {
                File newFile;
                File oldFile = this._libraryTable.getFile(rows[length]);
                boolean renamed = oldFile.renameTo(newFile = new File(newFilePath, oldFile.getName()));
                if (renamed) {
                    if (droppingToIncomplete) {
                        this.handleDropToIncomplete(oldFile);
                    } else if (draggingFromIncomplete) {
                        this.handleDragFromIncomplete(newFile);
                    } else {
                        this.handleStandardDragAndDrop(oldFile, newFile);
                    }
                }
                --length;
            }
        }
    }

    void setCursors(Cursor cursor) {
        this._libraryTree.setCursor(cursor);
        this._libraryTable.setCursor(cursor);
    }

    Point getTableLocation() {
        return this._libraryTable.getTableLocation();
    }

    Point getTreeLocation() {
        return this._libraryTree.getTreeLocation();
    }

    Dimension getTableSize() {
        return this._libraryTable.getTableSize();
    }

    Dimension getTreeSize() {
        return this._libraryTree.getTreeSize();
    }

    void showTablePopupMenu(MouseEvent e) {
        this._libraryTable.showPopup(e);
    }

    int getTableIndexCandidate() {
        return this._libraryTable.getIndexCandidate();
    }

    ListSelectionModel getTableSelectionModel() {
        return this._libraryTable.getSelectionModel();
    }

    private void handleDropToIncomplete(File draggedFile) {
        this._fileManager.removeFileIfShared(draggedFile);
        this.updateTableFiles(this._libraryTree.getSelectedDirectory());
    }

    private void handleDragFromIncomplete(File draggedFile) {
        this._fileManager.addFileIfShared(draggedFile);
        this.showIncompleteFiles();
    }

    private void handleStandardDragAndDrop(File oldFile, File newFile) {
        this._fileManager.renameFileIfShared(oldFile, newFile);
        this.updateTableFiles(this._libraryTree.getSelectedDirectory());
    }

    private class RefreshListener
    implements ActionListener {
        private RefreshListener() {
        }

        public void actionPerformed(ActionEvent e) {
            LibraryView.this.refresh();
        }
    }

    private class DeleteListener
    implements ActionListener {
        private DeleteListener() {
        }

        public void actionPerformed(ActionEvent e) {
            LibraryView.this._libraryTable.deleteRows();
        }
    }

    private class LaunchListener
    implements ActionListener {
        private LaunchListener() {
        }

        public void actionPerformed(ActionEvent e) {
            LibraryView.this._libraryTable.launch();
        }
    }
}

