/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.options.OptionsButtonPanel;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.options.OptionsPane;
import com.limegroup.gnutella.gui.options.OptionsPaneImpl;
import com.limegroup.gnutella.gui.options.OptionsPaneManager;
import com.limegroup.gnutella.gui.options.OptionsTreeManager;
import com.limegroup.gnutella.gui.options.panes.AutoClearDownloadsPaneItem;
import com.limegroup.gnutella.gui.options.panes.AutoClearUploadsPaneItem;
import com.limegroup.gnutella.gui.options.panes.ChatActivePaneItem;
import com.limegroup.gnutella.gui.options.panes.ConnectionPreferencingPaneItem;
import com.limegroup.gnutella.gui.options.panes.ExtensionsPaneItem;
import com.limegroup.gnutella.gui.options.panes.ForceIPPaneItem;
import com.limegroup.gnutella.gui.options.panes.IgnoreMessagesPaneItem;
import com.limegroup.gnutella.gui.options.panes.IgnoreResultTypesPaneItem;
import com.limegroup.gnutella.gui.options.panes.IgnoreResultsPaneItem;
import com.limegroup.gnutella.gui.options.panes.MaximumDownloadsPaneItem;
import com.limegroup.gnutella.gui.options.panes.MaximumSearchesPaneItem;
import com.limegroup.gnutella.gui.options.panes.MaximumUploadsPaneItem;
import com.limegroup.gnutella.gui.options.panes.PortPaneItem;
import com.limegroup.gnutella.gui.options.panes.SaveDirPaneItem;
import com.limegroup.gnutella.gui.options.panes.SearchQualityPaneItem;
import com.limegroup.gnutella.gui.options.panes.SearchSpeedPaneItem;
import com.limegroup.gnutella.gui.options.panes.SharedDirPaneItem;
import com.limegroup.gnutella.gui.options.panes.SpeedPaneItem;
import com.limegroup.gnutella.gui.options.panes.UploadBandwidthPaneItem;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Component;
import java.io.File;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JSplitPane;

public final class OptionsConstructor {
    private JDialog _dialog;
    private final OptionsMediator MEDIATOR = OptionsMediator.instance();
    public final JFileChooser DIRECTORY_CHOOSER = new JFileChooser();
    private final int OPTIONS_WIDTH = 600;
    private final int OPTIONS_HEIGHT = 420;
    private OptionsTreeManager _treeManager;
    private OptionsPaneManager _paneManager;

    public OptionsConstructor(OptionsTreeManager treeManager, OptionsPaneManager paneManager) {
        this._treeManager = treeManager;
        this._paneManager = paneManager;
        String title = this.MEDIATOR.getString("OPTIONS_TITLE");
        this._dialog = new JDialog(GUIMediator.instance().getMainFrame(), title, true);
        if (CommonUtils.isWindows() || CommonUtils.isMacClassic() || CommonUtils.isMacOSX()) {
            this._dialog.setResizable(false);
        }
        ((Component)this._dialog).setSize(600, 420);
        PaddedPanel mainPanel = new PaddedPanel();
        Box splitBox = new Box(0);
        Component treeComponent = this._treeManager.getComponent();
        Component paneComponent = this._paneManager.getComponent();
        JSplitPane splitPane = new JSplitPane(1, treeComponent, paneComponent);
        splitPane.setDividerLocation(140);
        splitPane.setOneTouchExpandable(true);
        splitBox.add(treeComponent);
        splitBox.add(paneComponent);
        mainPanel.add(splitBox);
        mainPanel.add(Box.createVerticalStrut(17));
        mainPanel.add(new OptionsButtonPanel().getComponent());
        this._dialog.getContentPane().add(mainPanel);
        this.DIRECTORY_CHOOSER.setFileSelectionMode(1);
        String fcTitle = this.MEDIATOR.getString("FILE_CHOOSER_DIRECTORY_TITLE");
        this.DIRECTORY_CHOOSER.setDialogTitle(fcTitle);
        String SHARED_KEY = "OPTIONS_SHARED_MAIN_TITLE";
        String SAVE_KEY = "OPTIONS_SAVE_MAIN_TITLE";
        String SEARCH_KEY = "OPTIONS_SEARCH_MAIN_TITLE";
        String SEARCH_SPEED_KEY = "OPTIONS_SEARCH_SPEED_MAIN_TITLE";
        String SEARCH_QUALITY_KEY = "OPTIONS_SEARCH_QUALITY_MAIN_TITLE";
        String SEARCH_LIMIT_KEY = "OPTIONS_SEARCH_LIMIT_MAIN_TITLE";
        String DOWNLOAD_KEY = "OPTIONS_DOWNLOAD_MAIN_TITLE";
        String UPLOAD_KEY = "OPTIONS_UPLOAD_MAIN_TITLE";
        String ADVANCED_KEY = "OPTIONS_ADVANCED_MAIN_TITLE";
        String FILTERS_KEY = "OPTIONS_FILTERS_MAIN_TITLE";
        String FIREWALL_KEY = "OPTIONS_FIREWALL_MAIN_TITLE";
        String PREFERENCING_KEY = "OPTIONS_PREFERENCING_MAIN_TITLE";
        String PRIVATE_NET_KEY = "OPTIONS_PRIVATE_NET_MAIN_TITLE";
        String TTL_KEY = "OPTIONS_TTL_MAIN_TITLE";
        String PORT_KEY = "OPTIONS_PORT_MAIN_TITLE";
        String SPEED_KEY = "OPTIONS_SPEED_MAIN_TITLE";
        String CHAT_KEY = "OPTIONS_CHAT_MAIN_TITLE";
        String RESULTS_KEY = "OPTIONS_RESULTS_MAIN_TITLE";
        String MESSAGES_KEY = "OPTIONS_MESSAGES_MAIN_TITLE";
        OptionsPaneImpl savingPane = new OptionsPaneImpl("OPTIONS_SAVE_MAIN_TITLE");
        OptionsPaneImpl sharingPane = new OptionsPaneImpl("OPTIONS_SHARED_MAIN_TITLE");
        OptionsPaneImpl searchSpeedPane = new OptionsPaneImpl("OPTIONS_SEARCH_SPEED_MAIN_TITLE");
        OptionsPaneImpl searchQualityPane = new OptionsPaneImpl("OPTIONS_SEARCH_QUALITY_MAIN_TITLE");
        OptionsPaneImpl searchLimitPane = new OptionsPaneImpl("OPTIONS_SEARCH_LIMIT_MAIN_TITLE");
        OptionsPaneImpl downloadPane = new OptionsPaneImpl("OPTIONS_DOWNLOAD_MAIN_TITLE");
        OptionsPaneImpl uploadPane = new OptionsPaneImpl("OPTIONS_UPLOAD_MAIN_TITLE");
        OptionsPaneImpl firewallPane = new OptionsPaneImpl("OPTIONS_FIREWALL_MAIN_TITLE");
        OptionsPaneImpl preferencingPane = new OptionsPaneImpl("OPTIONS_PREFERENCING_MAIN_TITLE");
        OptionsPaneImpl privateNetPane = new OptionsPaneImpl("OPTIONS_PRIVATE_NET_MAIN_TITLE");
        OptionsPaneImpl portPane = new OptionsPaneImpl("OPTIONS_PORT_MAIN_TITLE");
        OptionsPaneImpl speedPane = new OptionsPaneImpl("OPTIONS_SPEED_MAIN_TITLE");
        OptionsPaneImpl chatPane = new OptionsPaneImpl("OPTIONS_CHAT_MAIN_TITLE");
        OptionsPaneImpl filtersResultsPane = new OptionsPaneImpl("OPTIONS_RESULTS_MAIN_TITLE");
        OptionsPaneImpl filtersMessagesPane = new OptionsPaneImpl("OPTIONS_MESSAGES_MAIN_TITLE");
        String SAVE_DIR_ITEM_KEY = "SAVE_DIR";
        String SHARED_DIRS_ITEM_KEY = "SHARED_DIRS";
        String SHARED_EXTENSIONS_ITEM_KEY = "SHARED_EXTENSIONS";
        String SEARCH_MAX_ITEM_KEY = "SEARCH_MAX";
        String DOWNLOAD_MAX_ITEM_KEY = "DOWNLOAD_MAX";
        String DOWNLOAD_CLEAR_ITEM_KEY = "DOWNLOAD_CLEAR";
        String UPLOAD_MAX_ITEM_KEY = "UPLOAD_MAX";
        String UPLOAD_CLEAR_ITEM_KEY = "UPLOAD_CLEAR";
        String UPLOAD_BANDWIDTH_ITEM_KEY = "UPLOAD_BANDWIDTH";
        String FORCE_IP_ITEM_KEY = "FORCE_IP";
        String CONNECT_PREF_ITEM_KEY = "CONNECT_PREF";
        String TTL_ITEM_KEY = "TTL";
        String MAX_TTL_ITEM_KEY = "MAX_TTL";
        String PORT_ITEM_KEY = "PORT";
        String SPEED_ITEM_KEY = "SPEED";
        String CHAT_ACTIVE_ITEM_KEY = "CHAT_ACTIVE";
        String IGNORE_RESULTS_ITEM_KEY = "IGNORE_RESULTS";
        String IGNORE_RESULT_TYPES_ITEM_KEY = "IGNORE_RESULT_TYPES";
        String IGNORE_MESSAGES_ITEM_KEY = "IGNORE_MESSAGES";
        String SEARCH_QUALITY_ITEM_KEY = "SEARCH_QUALITY";
        String SEARCH_SPEED_ITEM_KEY = "SEARCH_SPEED";
        SaveDirPaneItem saveDirItem = new SaveDirPaneItem("SAVE_DIR");
        SharedDirPaneItem sharedDirsItem = new SharedDirPaneItem("SHARED_DIRS");
        ExtensionsPaneItem extensionsItem = new ExtensionsPaneItem("SHARED_EXTENSIONS");
        MaximumDownloadsPaneItem maxDownloadsItem = new MaximumDownloadsPaneItem("DOWNLOAD_MAX");
        AutoClearDownloadsPaneItem clearDownloadsItem = new AutoClearDownloadsPaneItem("DOWNLOAD_CLEAR");
        MaximumUploadsPaneItem maxUploadsItem = new MaximumUploadsPaneItem("UPLOAD_MAX");
        UploadBandwidthPaneItem uploadBandwidthItem = new UploadBandwidthPaneItem("UPLOAD_BANDWIDTH");
        AutoClearUploadsPaneItem clearUploadsItem = new AutoClearUploadsPaneItem("UPLOAD_CLEAR");
        ForceIPPaneItem forcedIPItem = new ForceIPPaneItem("FORCE_IP");
        ConnectionPreferencingPaneItem connectionPrefItem = new ConnectionPreferencingPaneItem("CONNECT_PREF");
        PortPaneItem portItem = new PortPaneItem("PORT");
        SpeedPaneItem speedItem = new SpeedPaneItem("SPEED");
        ChatActivePaneItem chatActiveItem = new ChatActivePaneItem("CHAT_ACTIVE");
        IgnoreResultsPaneItem ignoreResultsItem = new IgnoreResultsPaneItem("IGNORE_RESULTS");
        IgnoreResultTypesPaneItem ignoreResultTypesItem = new IgnoreResultTypesPaneItem("IGNORE_RESULT_TYPES");
        IgnoreMessagesPaneItem ignoreMessagesItem = new IgnoreMessagesPaneItem("IGNORE_MESSAGES");
        MaximumSearchesPaneItem maxSearchesItem = new MaximumSearchesPaneItem("SEARCH_MAX");
        SearchQualityPaneItem searchQualityPaneItem = new SearchQualityPaneItem("SEARCH_QUALITY");
        SearchSpeedPaneItem searchSpeedPaneItem = new SearchSpeedPaneItem("SEARCH_SPEED");
        savingPane.add(saveDirItem);
        sharingPane.add(sharedDirsItem);
        sharingPane.add(extensionsItem);
        downloadPane.add(maxDownloadsItem);
        downloadPane.add(clearDownloadsItem);
        uploadPane.add(maxUploadsItem);
        uploadPane.add(clearUploadsItem);
        uploadPane.add(uploadBandwidthItem);
        firewallPane.add(forcedIPItem);
        preferencingPane.add(connectionPrefItem);
        portPane.add(portItem);
        speedPane.add(speedItem);
        chatPane.add(chatActiveItem);
        filtersResultsPane.add(ignoreResultsItem);
        filtersResultsPane.add(ignoreResultTypesItem);
        filtersMessagesPane.add(ignoreMessagesItem);
        searchLimitPane.add(maxSearchesItem);
        searchQualityPane.add(searchQualityPaneItem);
        searchSpeedPane.add(searchSpeedPaneItem);
        this.addOption("OPTIONS_ROOT_NODE", savingPane);
        this.addOption("OPTIONS_ROOT_NODE", sharingPane);
        this.addOption("OPTIONS_ROOT_NODE", speedPane);
        this.addOption("OPTIONS_ROOT_NODE", downloadPane);
        this.addOption("OPTIONS_ROOT_NODE", uploadPane);
        this.addOption("OPTIONS_ROOT_NODE", chatPane);
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", "OPTIONS_SEARCH_MAIN_TITLE");
        this.addOption("OPTIONS_SEARCH_MAIN_TITLE", searchLimitPane);
        this.addOption("OPTIONS_SEARCH_MAIN_TITLE", searchQualityPane);
        this.addOption("OPTIONS_SEARCH_MAIN_TITLE", searchSpeedPane);
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", "OPTIONS_FILTERS_MAIN_TITLE");
        this.addOption("OPTIONS_FILTERS_MAIN_TITLE", filtersResultsPane);
        this.addOption("OPTIONS_FILTERS_MAIN_TITLE", filtersMessagesPane);
        this.addGroupTreeNode("OPTIONS_ROOT_NODE", "OPTIONS_ADVANCED_MAIN_TITLE");
        this.addOption("OPTIONS_ADVANCED_MAIN_TITLE", firewallPane);
        this.addOption("OPTIONS_ADVANCED_MAIN_TITLE", preferencingPane);
        this.addOption("OPTIONS_ADVANCED_MAIN_TITLE", portPane);
    }

    private final void addGroupTreeNode(String parentKey, String childKey) {
        this._treeManager.addNode(parentKey, childKey, this.MEDIATOR.getString(childKey));
    }

    private final void addOption(String parentKey, OptionsPane pane) {
        this._treeManager.addNode(parentKey, pane.getName(), this.MEDIATOR.getString(pane.getName()));
        this._paneManager.addPane(pane);
    }

    public final void setOptionsVisible(boolean visible) {
        if (visible) {
            this._dialog.setLocationRelativeTo(GUIMediator.instance().getMainFrame());
            this._dialog.show();
        } else {
            this._dialog.dispose();
        }
    }

    public int showDirectoryChooser() {
        String str = this.MEDIATOR.getString("FILE_CHOOSER_DIRECTORY_BUTTON_LABEL");
        return this.DIRECTORY_CHOOSER.showDialog(this._dialog, str);
    }

    public File getDirectoryChooserSelectedFile() {
        return this.DIRECTORY_CHOOSER.getSelectedFile();
    }
}

