/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.SizedWholeNumberField;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public final class ForceIPPaneItem
extends AbstractPaneItem {
    private final String CHECK_BOX_LABEL_KEY = "OPTIONS_FORCE_IP_CHECK_BOX_LABEL";
    private final String IP_LABEL_KEY = "OPTIONS_FORCE_IP_IP_LABEL";
    private final String PORT_LABEL_KEY = "OPTIONS_FORCE_IP_PORT_LABEL";
    private final JCheckBox CHECK_BOX = new JCheckBox();
    private final JTextField IP_FIELD = new SizedTextField(12, new Dimension(40, 20));
    private final WholeNumberField PORT_FIELD = new SizedWholeNumberField();
    private String _ip;
    private int _forcedPort;
    private boolean _forceLocalIP;

    public ForceIPPaneItem(String key) {
        super(key);
        this.CHECK_BOX.addItemListener(new LocalIPBoxListener());
        this.IP_FIELD.setMinimumSize(new Dimension(40, 20));
        LabeledComponent comp0 = new LabeledComponent("OPTIONS_FORCE_IP_CHECK_BOX_LABEL", this.CHECK_BOX, 130);
        LabeledComponent comp1 = new LabeledComponent("OPTIONS_FORCE_IP_IP_LABEL", this.IP_FIELD);
        LabeledComponent comp2 = new LabeledComponent("OPTIONS_FORCE_IP_PORT_LABEL", this.PORT_FIELD);
        BoxPanel bp0 = new BoxPanel(0);
        bp0.add(comp0.getComponent());
        bp0.add(Box.createHorizontalGlue());
        BoxPanel bp1 = new BoxPanel(0);
        bp1.add(comp1.getComponent());
        bp1.add(this.getHorizontalSeparator());
        bp1.add(comp2.getComponent());
        this.add(comp0.getComponent());
        this.add(this.getVerticalSeparator());
        this.add(bp1);
    }

    public void initOptions() {
        this._ip = this.SETTINGS.getForcedIPAddressString();
        this._forcedPort = this.SETTINGS.getForcedPort();
        this._forceLocalIP = this.SETTINGS.getForceIPAddress();
        this.PORT_FIELD.setValue(this._forcedPort);
        this.CHECK_BOX.setSelected(this._forceLocalIP);
        this.IP_FIELD.setText(this._ip);
    }

    public void applyOptions() throws IOException {
        this.handleForcedIP();
    }

    private void handleForcedIP() throws IOException {
        boolean forceLocalIP = this.CHECK_BOX.isSelected();
        int forcedPort = this.PORT_FIELD.getValue();
        String ip = this.IP_FIELD.getText();
        if (forcedPort != this._forcedPort) {
            try {
                this.SETTINGS.setForcedPort(forcedPort);
                this._forcedPort = forcedPort;
            }
            catch (IllegalArgumentException iae) {
                GUIMediator.instance().showError("ERROR_FORCE_IP_PORT_RANGE");
                this.PORT_FIELD.setValue(this._forcedPort);
                throw new IOException();
            }
        }
        if (!ip.equals(this._ip) || forceLocalIP != this._forceLocalIP) {
            Thread commitIPChangesThread = new Thread(new CommitIPChangesThread(ip, forceLocalIP));
            commitIPChangesThread.start();
        }
    }

    private class CommitIPChangesThread
    implements Runnable {
        private String _ip;
        private boolean _forceLocalIP;

        public CommitIPChangesThread(String ip, boolean forceLocalIP) {
            this._ip = ip.trim();
            this._forceLocalIP = forceLocalIP;
        }

        public void run() {
            if (!this._ip.equals("")) {
                try {
                    ForceIPPaneItem.this.SETTINGS.setForcedIPAddressString(this._ip);
                    ForceIPPaneItem.this._ip = this._ip;
                    ForceIPPaneItem.this.SETTINGS.setForceIPAddress(this._forceLocalIP);
                    ForceIPPaneItem.this._forceLocalIP = this._forceLocalIP;
                }
                catch (IllegalArgumentException e) {
                    ForceIPPaneItem.this.SETTINGS.setForceIPAddress(false);
                    ForceIPPaneItem.this._forceLocalIP = false;
                    ForceIPPaneItem.this.CHECK_BOX.setSelected(false);
                }
            } else {
                ForceIPPaneItem.this.SETTINGS.setForceIPAddress(false);
                ForceIPPaneItem.this._forceLocalIP = false;
                ForceIPPaneItem.this.CHECK_BOX.setSelected(false);
            }
        }
    }

    private class LocalIPBoxListener
    implements ItemListener {
        private LocalIPBoxListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            ForceIPPaneItem.this.IP_FIELD.setEditable(ForceIPPaneItem.this.CHECK_BOX.isSelected());
            ForceIPPaneItem.this.PORT_FIELD.setEditable(ForceIPPaneItem.this.CHECK_BOX.isSelected());
        }
    }
}

