/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedWholeNumberField;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import java.io.IOException;

public final class PortPaneItem
extends AbstractPaneItem {
    private final String OPTION_LABEL = "OPTIONS_PORT_BOX_LABEL";
    private WholeNumberField _portField = new SizedWholeNumberField();
    private int _port;

    public PortPaneItem(String key) {
        super(key);
        LabeledComponent comp = new LabeledComponent("OPTIONS_PORT_BOX_LABEL", this._portField, 120);
        this.add(comp.getComponent());
    }

    public void initOptions() {
        this._port = this.SETTINGS.getPort();
        this._portField.setValue(this._port);
    }

    public void applyOptions() throws IOException {
        int port = this._portField.getValue();
        if (port != this._port) {
            try {
                this.SETTINGS.setPort(port);
                try {
                    GUIMediator.instance().getRouter().setListeningPort(port);
                    this._port = port;
                }
                catch (IOException ioe) {
                    GUIMediator.instance().showError("ERROR_PORT_UNAVAILABLE");
                    this.SETTINGS.setPort(this._port);
                    this._portField.setValue(this._port);
                    throw new IOException();
                }
            }
            catch (IllegalArgumentException iae) {
                GUIMediator.instance().showError("ERROR_PORT_RANGE");
                this._portField.setValue(this._port);
                throw new IOException();
            }
        }
    }
}

