/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JTextField;

public final class SaveDirPaneItem
extends AbstractPaneItem {
    private final String OPTION_LABEL = "OPTIONS_SAVE_DIR_BOX_LABEL";
    private JTextField _saveField = new SizedTextField();
    private String _saveDirectory;

    public SaveDirPaneItem(String key) {
        super(key);
        LabeledComponent comp = new LabeledComponent("OPTIONS_SAVE_DIR_BOX_LABEL", this._saveField, 13);
        String[] labelKeys = new String[]{"OPTIONS_SAVE_DIR_BROWSE_BUTTON_LABEL", "OPTIONS_SAVE_DIR_DEFAULT_BUTTON_LABEL"};
        String[] toolTipKeys = new String[]{"OPTIONS_SAVE_DIR_BROWSE_BUTTON_TIP", "OPTIONS_SAVE_DIR_DEFAULT_BUTTON_TIP"};
        ActionListener[] listeners = new ActionListener[]{new SelectSaveDirectoryListener(), new DefaultListener()};
        ButtonRow br = new ButtonRow(labelKeys, toolTipKeys, listeners, 0, 12);
        this.add(comp.getComponent());
        this.add(this.getVerticalSeparator());
        this.add(br);
    }

    public void initOptions() {
        try {
            this._saveDirectory = this.SETTINGS.getSaveDirectory().getAbsolutePath();
        }
        catch (FileNotFoundException fnfe) {
            this._saveDirectory = "";
        }
        this._saveField.setText(this._saveDirectory);
    }

    public void applyOptions() throws IOException {
        String save = this._saveField.getText();
        if (!save.equals(this._saveDirectory)) {
            try {
                File saveDir = new File(save);
                this.SETTINGS.setSaveDirectory(saveDir);
                this._saveDirectory = save;
            }
            catch (IOException ioe) {
                GUIMediator.instance().showError("ERROR_INVALID_SAVE_DIRECTORY");
                this._saveField.setText(this._saveDirectory);
                throw new IOException();
            }
            catch (NullPointerException npe) {
                GUIMediator.instance().showError("ERROR_INVALID_SAVE_DIRECTORY");
                this._saveField.setText(this._saveDirectory);
                throw new IOException();
            }
        }
    }

    private class SelectSaveDirectoryListener
    implements ActionListener {
        private SelectSaveDirectoryListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (SaveDirPaneItem.this.MEDIATOR.showDirectoryChooser() == 0) {
                File dir = SaveDirPaneItem.this.MEDIATOR.getDirectoryChooserSelectedFile();
                SaveDirPaneItem.this._saveField.setText(dir.getAbsolutePath());
            }
        }
    }

    private class DefaultListener
    implements ActionListener {
        private DefaultListener() {
        }

        public void actionPerformed(ActionEvent e) {
            SaveDirPaneItem.this._saveField.setText(SaveDirPaneItem.this.SETTINGS.getSaveDefault().getAbsolutePath());
        }
    }
}

