/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedTextField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.JTextField;

public final class SharedDirPaneItem
extends AbstractPaneItem {
    private final String OPTION_LABEL = "OPTIONS_SHARED_DIRS_BOX_LABEL";
    private JTextField _sharedField = new SizedTextField();
    private String _sharedDirsString;

    public SharedDirPaneItem(String key) {
        super(key);
        LabeledComponent comp = new LabeledComponent("OPTIONS_SHARED_DIRS_BOX_LABEL", this._sharedField, 13);
        String[] labelKeys = new String[]{"OPTIONS_SHARED_DIRS_BUTTON_LABEL"};
        String[] toolTipKeys = new String[]{"OPTIONS_SHARED_DIRS_BUTTON_TIP"};
        ActionListener[] listeners = new ActionListener[]{new SelectSharedDirectoryListener()};
        ButtonRow br = new ButtonRow(labelKeys, toolTipKeys, listeners, 0, 12);
        this.add(comp.getComponent());
        this.add(this.getVerticalSeparator());
        this.add(br);
    }

    private void addDirectory(File dir) {
        if (!dir.isDirectory()) {
            return;
        }
        boolean write = true;
        String[] dirs = this.SETTINGS.getDirectoriesAsArray();
        String newPath = "";
        try {
            newPath = dir.getCanonicalPath();
        }
        catch (IOException ioe) {
            return;
        }
        int i = 0;
        while (i < dirs.length) {
            dirs[i].trim();
            File file = new File(dirs[i]);
            String name = "";
            try {
                name = file.getCanonicalPath();
            }
            catch (IOException ioe) {
                continue;
            }
            if (name.equals(newPath)) {
                write = false;
                break;
            }
            ++i;
        }
        String dirText = this._sharedField.getText();
        dirText.trim();
        if (write) {
            if (!dirText.endsWith(";") && !dirText.equals("")) {
                dirText = dirText + ";";
            }
            dirText = dirText + dir;
            dirText = dirText + ";";
            this._sharedField.setText(dirText);
        }
    }

    private void handleSaveDirectory() {
        String saveDirectory;
        String dirs = this._sharedField.getText();
        try {
            File saveDirectoryFile = this.SETTINGS.getSaveDirectory();
            saveDirectory = saveDirectoryFile.getCanonicalPath();
        }
        catch (FileNotFoundException fnfe) {
            return;
        }
        catch (IOException ioe) {
            return;
        }
        StringTokenizer st = new StringTokenizer(dirs, ";");
        while (st.hasMoreTokens()) {
            String curPath;
            File curFile = new File(st.nextToken());
            try {
                curPath = curFile.getCanonicalPath();
            }
            catch (IOException ioe) {
                return;
            }
            if (!saveDirectory.equals(curPath)) continue;
            return;
        }
        String msg = "MESSAGE_SHARE_SAVE_DIR";
        int response = GUIMediator.instance().showYesNoMessage(msg);
        GUIMediator.instance();
        if (response == 101) {
            if (!dirs.endsWith(";") && !dirs.equals("")) {
                dirs = dirs + ";";
            }
            dirs = dirs + saveDirectory;
            dirs = dirs + ";";
            this._sharedField.setText(dirs);
        }
    }

    public void initOptions() {
        this._sharedDirsString = this.SETTINGS.getDirectories();
        this._sharedField.setText(this._sharedDirsString);
    }

    public void applyOptions() throws IOException {
        this.handleSaveDirectory();
        String dirs = this._sharedField.getText();
        if (!dirs.equals(this._sharedDirsString)) {
            this.SETTINGS.setDirectories(dirs);
            Thread loadFileManagerSettings = new Thread(){

                public void run() {
                    FileManager.instance().loadSettings(true);
                }
            };
            loadFileManagerSettings.setDaemon(true);
            loadFileManagerSettings.start();
            this._sharedDirsString = dirs;
        }
    }

    private class SelectSharedDirectoryListener
    implements ActionListener {
        private SelectSharedDirectoryListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (SharedDirPaneItem.this.MEDIATOR.showDirectoryChooser() == 0) {
                SharedDirPaneItem.this.addDirectory(SharedDirPaneItem.this.MEDIATOR.getDirectoryChooserSelectedFile());
            }
        }
    }
}

