/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import java.awt.Dimension;
import java.io.IOException;
import javax.swing.JComboBox;

public final class SpeedPaneItem
extends AbstractPaneItem {
    private final String[] SPEED_MENU_ITEMS = new String[]{"Modem", "Cable/DSL", "T1", "T3 or Higher"};
    private final String OPTION_LABEL = "OPTIONS_SPEED_BOX_LABEL";
    private JComboBox _speedBox = new JComboBox<String>(this.SPEED_MENU_ITEMS);
    private String _speed;

    public SpeedPaneItem(String key) {
        super(key);
        Dimension dim = new Dimension(6, 25);
        this._speedBox.setPreferredSize(dim);
        LabeledComponent comp = new LabeledComponent("OPTIONS_SPEED_BOX_LABEL", this._speedBox, 120);
        this.add(comp.getComponent());
    }

    public void initOptions() {
        this._speed = this.getSpeedString(this.SETTINGS.getConnectionSpeed());
        this._speedBox.setSelectedItem(this._speed);
    }

    public void applyOptions() throws IOException {
        String speed = (String)this._speedBox.getSelectedItem();
        if (!speed.equals(this._speed)) {
            int speedInt = this.getSpeedInt(speed);
            this.SETTINGS.setConnectionSpeed(speedInt);
            this._speed = speed;
        }
    }

    private String getSpeedString(int i) {
        String speed = i == 56 ? "Modem" : (i == 350 ? "Cable/DSL" : (i == 1000 ? "T1" : (i == 3000 ? "T3 or Higher" : "Modem")));
        return speed;
    }

    private int getSpeedInt(String s) {
        int i = s.equals("Modem") ? 56 : (s.equals("Cable/DSL") ? 350 : (s.equals("T1") ? 1000 : (s.equals("T3 or Higher") ? 3000 : 56)));
        return i;
    }
}

