/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.sun.java.util.collections.Hashtable;
import java.awt.Font;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Dictionary;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class UploadBandwidthPaneItem
extends AbstractPaneItem {
    private final String LABEL_LABEL = "OPTIONS_UPLOAD_BANDWIDTH_SLIDER_LABEL_LABEL";
    private final String SLIDER_MAX_LABEL = "OPTIONS_UPLOAD_BANDWIDTH_SLIDER_MAX_LABEL";
    private WholeNumberField _ttlField;
    private final JSlider UPLOAD_SLIDER = new JSlider();
    private JLabel _sliderLabel = new JLabel();
    private int _uploadThrottle;

    public UploadBandwidthPaneItem(String key) {
        super(key);
        this.UPLOAD_SLIDER.setMajorTickSpacing(10);
        this.UPLOAD_SLIDER.setPaintTicks(true);
        Hashtable labelTable = new Hashtable();
        JLabel label1 = new JLabel("0%");
        JLabel label2 = new JLabel("50%");
        JLabel label3 = new JLabel("100%");
        Font font = new Font("Helvetica", 1, 10);
        label1.setFont(font);
        label2.setFont(font);
        label3.setFont(font);
        labelTable.put((Object)new Integer(0), (Object)label1);
        labelTable.put((Object)new Integer(50), (Object)label2);
        labelTable.put((Object)new Integer(100), (Object)label3);
        this.UPLOAD_SLIDER.setLabelTable((Dictionary)labelTable);
        this.UPLOAD_SLIDER.setPaintLabels(true);
        this.UPLOAD_SLIDER.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                UploadBandwidthPaneItem.this.handleThrottleLabel();
            }
        });
        LabeledComponent comp = new LabeledComponent("OPTIONS_UPLOAD_BANDWIDTH_SLIDER_LABEL_LABEL", this._sliderLabel, 120);
        this.add(this.UPLOAD_SLIDER);
        this.add(this.getVerticalSeparator());
        this.add(comp.getComponent());
    }

    private void handleThrottleLabel() {
        float value = this.UPLOAD_SLIDER.getValue();
        String labelText = "";
        if (value == 100.0f) {
            labelText = this.MEDIATOR.getString("OPTIONS_UPLOAD_BANDWIDTH_SLIDER_MAX_LABEL");
        } else {
            Float f = new Float((double)this.UPLOAD_SLIDER.getValue() / 100.0 * (double)this.SETTINGS.getConnectionSpeed() / 8.0);
            NumberFormat formatter = NumberFormat.getInstance();
            formatter.setMaximumFractionDigits(2);
            labelText = String.valueOf(formatter.format(f)) + " KB/s";
        }
        this._sliderLabel.setText(labelText);
    }

    public void initOptions() {
        this._uploadThrottle = this.SETTINGS.getUploadSpeed();
        this.UPLOAD_SLIDER.setValue(this._uploadThrottle);
        this.handleThrottleLabel();
    }

    public void applyOptions() throws IOException {
        int uploadThrottle = this.UPLOAD_SLIDER.getValue();
        if (uploadThrottle != this._uploadThrottle) {
            this.SETTINGS.setUploadSpeed(uploadThrottle);
            this._uploadThrottle = uploadThrottle;
        }
    }
}

