/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.gui.JTreeTable;
import com.limegroup.gnutella.gui.search.CachingEndpointRenderer;
import com.limegroup.gnutella.gui.search.QualityRenderer;
import com.limegroup.gnutella.gui.search.ResultPanelModel;
import com.limegroup.gnutella.gui.search.ResultSpeedRenderer;
import com.limegroup.gnutella.gui.search.StandardSearchView;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.search.TableLineGrouper;
import com.limegroup.gnutella.util.UnmodifiableIterator;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.NoSuchElementException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class ResultPanel
extends JPanel {
    static final int NAME_COL = 1;
    static final int EXTENSION_COL = 2;
    static final int SIZE_COL = 3;
    static final int SPEED_COL = 4;
    static final int SCORE_COL = 5;
    static final int LOCATION_COL = 6;
    static final int QUALITY_COL = 0;
    private String query;
    private GUID guid;
    private ResultPanelModel dataModel;
    private JTreeTable table;
    private boolean grouped;
    private boolean ascending = true;
    private TableLineGrouper grouper = new TableLineGrouper();
    StandardSearchView parent;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$search$QualityHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$search$CachingEndpoint;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$search$ResultSpeed;

    ResultPanel(final StandardSearchView parent, GUID guid, String query, boolean grouped) {
        this.parent = parent;
        this.guid = guid;
        this.query = query;
        this.grouped = grouped;
        this.setLayout(new BorderLayout());
        this.dataModel = new ResultPanelModel(new TableLine(), grouped);
        this.createTreeTable();
        JScrollPane scrollpane = new JScrollPane(this.table);
        ResultPanel thisComponent = this;
        MouseAdapter mouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    parent.showMainMenu(e.getX(), e.getY());
                } else if (e.getClickCount() == 2) {
                    parent.doDownload(false);
                }
            }
        };
        this.table.addMouseListener(mouseListener);
        JPanel tpan = new JPanel();
        tpan.setLayout(new BorderLayout());
        tpan.setBackground(Color.white);
        JPanel corner = new JPanel();
        corner.setBackground(this.table.getTableHeader().getBackground());
        corner.setBorder(BorderFactory.createBevelBorder(0));
        scrollpane.setCorner("UPPER_RIGHT_CORNER", corner);
        scrollpane.getViewport().setBackground(Color.white);
        tpan.add((Component)scrollpane, "Center");
        this.add((Component)tpan, "Center");
    }

    private void createTreeTable() {
        this.table = new JTreeTable(this.dataModel);
        this.table.setLeafIcon(null);
        this.table.setOpenIcon(null);
        this.table.setClosedIcon(null);
        this.table.setDefaultRenderer(class$com$limegroup$gnutella$gui$search$QualityHolder == null ? (class$com$limegroup$gnutella$gui$search$QualityHolder = ResultPanel.class$("com.limegroup.gnutella.gui.search.QualityHolder")) : class$com$limegroup$gnutella$gui$search$QualityHolder, new QualityRenderer());
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = ResultPanel.this.table.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = ResultPanel.this.table.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && column != -1) {
                    int shiftPressed = e.getModifiers() & 1;
                    ResultPanel.this.sort(column);
                }
            }
        };
        JTableHeader th = this.table.getTableHeader();
        th.addMouseListener(listMouseListener);
        this.table.setDefaultRenderer(class$com$limegroup$gnutella$gui$search$CachingEndpoint == null ? (class$com$limegroup$gnutella$gui$search$CachingEndpoint = ResultPanel.class$("com.limegroup.gnutella.gui.search.CachingEndpoint")) : class$com$limegroup$gnutella$gui$search$CachingEndpoint, new CachingEndpointRenderer());
        this.table.setDefaultRenderer(class$com$limegroup$gnutella$gui$search$ResultSpeed == null ? (class$com$limegroup$gnutella$gui$search$ResultSpeed = ResultPanel.class$("com.limegroup.gnutella.gui.search.ResultSpeed")) : class$com$limegroup$gnutella$gui$search$ResultSpeed, new ResultSpeedRenderer());
        this.table.getColumnModel().getColumn(1).setPreferredWidth(230);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(30);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(60);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(30);
        this.table.getColumnModel().getColumn(5).setPreferredWidth(30);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(40);
        ListSelectionModel rowSM = this.table.getSelectionModel();
        rowSM.addListSelectionListener(new ResultSelectionListener());
        this.table.addTreeExpansionListener(new ResultExpansionListener());
    }

    public void addLine(TableLine line, TableLine group) {
        this.dataModel.addLine(line, group, this.grouped);
        this.table.revalidate();
    }

    public synchronized void setGrouped(boolean grouped) {
        if (this.grouped == grouped) {
            return;
        }
        this.grouped = grouped;
        if (this.grouped) {
            this.dataModel.group();
        } else {
            this.dataModel.ungroup();
        }
        this.table.revalidate();
    }

    public TableLineGrouper getGrouper() {
        return this.grouper;
    }

    public boolean matches(GUID guid) {
        return this.guid.equals(guid);
    }

    public JTable getTable() {
        return this.table;
    }

    public void setGUID(GUID guid) {
        this.guid = guid;
    }

    public String getQuery() {
        return this.query;
    }

    public synchronized void sort(int column) {
        this.dataModel.sort(column, this.ascending);
        this.table.revalidate();
        this.ascending = !this.ascending;
    }

    public int numResults() {
        return this.dataModel.numLeaves();
    }

    public Iterator getSelectedRows() {
        return new SelectedRowIterator();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ResultExpansionListener
    implements TreeExpansionListener {
        private ResultExpansionListener() {
        }

        public void treeCollapsed(TreeExpansionEvent event) {
            try {
                ResultPanel.this.table.removeRowSelectionInterval(0, ResultPanel.this.table.getRowCount() - 1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void treeExpanded(TreeExpansionEvent event) {
        }
    }

    private class ResultSelectionListener
    implements ListSelectionListener {
        private ResultSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            int i = e.getFirstIndex();
            while (i <= e.getLastIndex()) {
                if (lsm.isSelectedIndex(i)) {
                    TableLine parent = (TableLine)ResultPanel.this.table.nodeForRow(i);
                    if (!ResultPanel.this.dataModel.isLeaf(parent) && ResultPanel.this.table.isExpanded(i)) {
                        int start = i + 1;
                        int stop = i + ResultPanel.this.dataModel.getChildCount(parent);
                        lsm.addSelectionInterval(start, stop);
                    }
                }
                ++i;
            }
        }
    }

    private class SelectedRowIterator
    extends UnmodifiableIterator {
        private int next = 0;
        private int[] selectedRows = ResultPanel.access$000(ResultPanel.this).getSelectedRows();

        private SelectedRowIterator() {
        }

        public boolean hasNext() {
            return this.next < this.selectedRows.length;
        }

        public Object next() throws NoSuchElementException {
            try {
                int row = this.selectedRows[this.next];
                ++this.next;
                TableLine ret = (TableLine)ResultPanel.this.table.nodeForRow(row);
                return ret;
            }
            catch (IndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }
    }
}

