/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.gui.AbstractTreeTableModel;
import com.limegroup.gnutella.gui.TreeTableModel;
import com.limegroup.gnutella.gui.search.CachingEndpoint;
import com.limegroup.gnutella.gui.search.ResultSpeed;
import com.limegroup.gnutella.gui.search.TableLine;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;

class ResultPanelModel
extends AbstractTreeTableModel
implements TreeTableModel {
    final String[] names = new String[]{"Quality", "Name", "Type", "Size", "Speed", "Score", "Location"};
    TableLine fakeGroupedRoot = new TableLine();
    private int leaves = 0;
    boolean issuedWarning = false;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$TreeTableModel;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$search$ResultSpeed;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$search$CachingEndpoint;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$search$QualityHolder;

    public ResultPanelModel(TableLine root, boolean grouped) {
        super(root);
        if (grouped) {
            this.fakeGroupedRoot.children = root.children;
        }
    }

    public int getColumnCount() {
        return this.names.length;
    }

    public String getColumnName(int column) {
        return this.names[column];
    }

    public Class getColumnClass(int col) {
        switch (col) {
            case 1: {
                return class$com$limegroup$gnutella$gui$TreeTableModel == null ? (class$com$limegroup$gnutella$gui$TreeTableModel = ResultPanelModel.class$("com.limegroup.gnutella.gui.TreeTableModel")) : class$com$limegroup$gnutella$gui$TreeTableModel;
            }
            case 2: {
                return class$java$lang$String == null ? (class$java$lang$String = ResultPanelModel.class$("java.lang.String")) : class$java$lang$String;
            }
            case 3: {
                return class$java$lang$String == null ? (class$java$lang$String = ResultPanelModel.class$("java.lang.String")) : class$java$lang$String;
            }
            case 4: {
                return class$com$limegroup$gnutella$gui$search$ResultSpeed == null ? (class$com$limegroup$gnutella$gui$search$ResultSpeed = ResultPanelModel.class$("com.limegroup.gnutella.gui.search.ResultSpeed")) : class$com$limegroup$gnutella$gui$search$ResultSpeed;
            }
            case 5: {
                return class$java$lang$Integer == null ? (class$java$lang$Integer = ResultPanelModel.class$("java.lang.Integer")) : class$java$lang$Integer;
            }
            case 6: {
                return class$com$limegroup$gnutella$gui$search$CachingEndpoint == null ? (class$com$limegroup$gnutella$gui$search$CachingEndpoint = ResultPanelModel.class$("com.limegroup.gnutella.gui.search.CachingEndpoint")) : class$com$limegroup$gnutella$gui$search$CachingEndpoint;
            }
            case 0: {
                return class$com$limegroup$gnutella$gui$search$QualityHolder == null ? (class$com$limegroup$gnutella$gui$search$QualityHolder = ResultPanelModel.class$("com.limegroup.gnutella.gui.search.QualityHolder")) : class$com$limegroup$gnutella$gui$search$QualityHolder;
            }
        }
        Assert.that(false, "Bad column in table");
        return null;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void setValueAt(Object aValue, int row, int column) {
        Assert.that(false, "Table not editable!");
    }

    public Object getValueAt(Object node, int column) {
        TableLine line = (TableLine)node;
        switch (column) {
            case 1: {
                return line.filenameWithoutExtension;
            }
            case 2: {
                return line.extension;
            }
            case 3: {
                return line.sizeString;
            }
            case 4: {
                return line.getSpeed();
            }
            case 5: {
                return line.score;
            }
            case 6: {
                return line.location;
            }
            case 0: {
                return line.quality;
            }
        }
        Assert.that(false, "Bad column in table");
        return null;
    }

    public int getChildCount(Object node) {
        return ((TableLine)node).children.size();
    }

    public Object getChild(Object node, int i) {
        return ((TableLine)node).children.get(i);
    }

    public boolean isLeaf(Object node) {
        return ((TableLine)node).children == null;
    }

    private void add(TableLine parent, TableLine child) {
        if (parent.children == null) {
            parent.children = new ArrayList();
        }
        parent.children.add((Object)child);
        child.childName = parent.children.size() - 1;
    }

    private TableLine setChildAt(TableLine parent, int i, TableLine child) {
        Assert.that(parent.children != null);
        TableLine ret = (TableLine)parent.children.get(i);
        parent.children.set(i, (Object)child);
        child.childName = i;
        return ret;
    }

    public void addLine(TableLine line, TableLine group, boolean grouped) {
        this.repOk();
        if (grouped) {
            Assert.that(((TableLine)this.getRoot()).children == this.fakeGroupedRoot.children, "No aliasing of fakedGroupedRoot's children.");
            this.addLineInternal((TableLine)this.getRoot(), line, group, true);
        } else {
            Assert.that(((TableLine)this.getRoot()).children != this.fakeGroupedRoot.children, "Aliasing of fakedGroupedRoot's children.");
            this.addLineInternal(this.fakeGroupedRoot, line, group, false);
            this.addLineInternal((TableLine)this.getRoot(), new TableLine(line), null, true);
        }
        ++this.leaves;
        this.repOk();
    }

    private void addLineInternal(TableLine root, TableLine line, TableLine group, boolean doNotify) {
        if (group != null) {
            try {
                Assert.that(this.getChild(root, group.childName) == group, "Group is not the " + group.childName + "'th child of root");
            }
            catch (IndexOutOfBoundsException e) {
                Assert.that(false, "Group is not the " + group.childName + "'th child of root");
            }
        }
        if (group != null) {
            int i = group.childName;
            if (!this.isLeaf(group)) {
                this.add(group, line);
                if (doNotify) {
                    this.fireTreeNodesInserted(this, new Object[]{root, group}, new int[]{this.getChildCount(group) - 1}, new Object[]{line});
                }
                if (group.getSpeed().compareTo(line.getSpeed()) < 0) {
                    group.setSpeed(line.getSpeed());
                    if (doNotify) {
                        this.fireTreeNodesChanged(this, new Object[]{root, group}, null, null);
                    }
                }
                if (group.getQuality() < line.getQuality()) {
                    group.setQuality(line.getQuality());
                    if (doNotify) {
                        this.fireTreeNodesChanged(this, new Object[]{root, group}, null, null);
                    }
                }
            } else {
                TableLine groupCopy = new TableLine(group);
                group.location = new CachingEndpoint(this, group);
                group.setSpeed(ResultSpeed.max(group.getSpeed(), line.getSpeed()));
                group.setQuality(Math.max(group.getQuality(), line.getQuality()));
                this.add(group, groupCopy);
                this.add(group, line);
                if (doNotify) {
                    this.fireTreeNodesRemoved(this, new Object[]{root}, new int[]{i}, new Object[]{group});
                    this.fireTreeNodesInserted(this, new Object[]{root}, new int[]{i}, new Object[]{group});
                }
            }
        } else {
            this.add(root, line);
            if (doNotify) {
                this.fireTreeNodesInserted(this, new Object[]{root}, new int[]{this.getChildCount(root) - 1}, new Object[]{line});
            }
        }
    }

    public void group() {
        this.repOk();
        TableLine root = (TableLine)this.getRoot();
        root.children = this.fakeGroupedRoot.children;
        this.fireTreeStructureChanged(this, new Object[]{root}, null, null);
        this.repOk();
    }

    public void ungroup() {
        this.repOk();
        TableLine root = (TableLine)this.getRoot();
        root.children = new ArrayList(this.numLeaves());
        Iterator iter = this.fakeGroupedRoot.children.iterator();
        while (iter.hasNext()) {
            TableLine child = (TableLine)iter.next();
            if (this.isLeaf(child)) {
                this.addLineInternal(root, new TableLine(child), null, false);
                continue;
            }
            int i = 0;
            while (i < child.children.size()) {
                TableLine grandChild = (TableLine)child.children.get(i);
                Assert.that(this.isLeaf(grandChild));
                this.addLineInternal(root, new TableLine(grandChild), null, false);
                ++i;
            }
        }
        this.fireTreeStructureChanged(this, new Object[]{root}, null, null);
        this.repOk();
    }

    public void sort(int column, boolean ascending) {
        TableLine root = (TableLine)this.getRoot();
        Collections.sort((List)root.children, (Comparator)TableLine.newComparator(column, ascending));
        List rootChildren = root.children;
        int i = 0;
        while (i < rootChildren.size()) {
            TableLine line = (TableLine)rootChildren.get(i);
            line.childName = i++;
        }
        this.repOk();
        this.fireTreeStructureChanged(this, new Object[]{root}, null, null);
    }

    public int numLeaves() {
        return this.leaves;
    }

    public void repOk() {
    }

    private int repOk(TableLine parent) {
        if (parent.children == null) {
            return 1;
        }
        int ret = 0;
        int i = 0;
        while (i < parent.children.size()) {
            TableLine child = (TableLine)parent.children.get(i);
            Assert.that(child != null, "Null children");
            Assert.that(child.childName == i, "Child's name is " + child.childName + " but I expected " + i);
            ret += this.repOk(child);
            ++i;
        }
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

