/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.FileExistsException;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.search.BrowseAction;
import com.limegroup.gnutella.gui.search.CancelSearchIconProxy;
import com.limegroup.gnutella.gui.search.ChatAction;
import com.limegroup.gnutella.gui.search.DownloadAllAction;
import com.limegroup.gnutella.gui.search.DownloadAnyAction;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.RightClickChatPopUpMenu;
import com.limegroup.gnutella.gui.search.RightClickPopUpMenu;
import com.limegroup.gnutella.gui.search.TabbedPaneMouseListener;
import com.limegroup.gnutella.gui.search.TableLine;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public class StandardSearchView
extends PaddedPanel {
    private JButton searchButton;
    private JTextField searchField;
    private JButton stopButton;
    private JButton closeButton;
    private JComboBox searchMediaBox;
    private JLabel searchIconLabel;
    private ImageIcon searchingIcon;
    private ImageIcon notsearchingIcon;
    private CancelSearchIconProxy killIcon;
    private Timer animationStopper;
    private JLabel searchLabel;
    private JTextField minConnSpeed;
    private JButton downloadAnyButton;
    public static final String DOWNLOAD_ANY_STRING = "Download ANY";
    private JButton downloadAllButton;
    public static final String DOWNLOAD_ALL_STRING = "Download ALL";
    private JButton killButton;
    public static final String KILL_STRING = "Close Search";
    public static final String STOP_STRING = "Stop Search";
    private JButton browseButton;
    public static final String BROWSE_STRING = "Browse Host";
    private JCheckBox groupBox;
    public static final String GROUP_STRING = "Grouped";
    private static final GUID stoppedGUID = new GUID(GUID.makeGuid());
    protected final List entries = new LinkedList();
    private static final int LABEL_SIZE = 10;
    private JTabbedPane tabbedPane;
    JPanel results;
    CardLayout switcher;
    protected GUIMediator mediator;
    private final JPopupMenu menu = new JPopupMenu();
    private final JPopupMenu _rmenu = new RightClickPopUpMenu(this);
    private final JPopupMenu _rchatmenu = new RightClickChatPopUpMenu(this);
    private JMenuItem _chatEntry;

    public StandardSearchView() {
        super("Search");
        this.mediator = GUIMediator.instance();
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        JPanel middle = new JPanel();
        FlowLayout fl = new FlowLayout();
        middle.setLayout(fl);
        this.searchField = new JTextField(18);
        this.searchMediaBox = new JComboBox<MediaType>(MediaType.getDefaultMediaTypes());
        this.searchButton = new JButton("Search");
        this.stopButton = new JButton("Stop");
        this.stopButton.setToolTipText("Stop collecting search results for tab");
        int width = this.searchMediaBox.getPreferredSize().width;
        int height = this.searchButton.getPreferredSize().height;
        this.searchMediaBox.setPreferredSize(new Dimension(width, height));
        this.searchButton.setToolTipText("Search the network for the given words");
        middle.add(this.searchField);
        middle.add(this.searchMediaBox);
        middle.add(this.searchButton);
        middle.add(this.stopButton);
        p.add((Component)middle, "West");
        this.searchingIcon = this.mediator.getImageResource("searching.gif");
        this.notsearchingIcon = this.mediator.getImageResource("notsearching.gif");
        this.killIcon = new CancelSearchIconProxy();
        this.searchIconLabel = new JLabel(this.notsearchingIcon);
        this.searchIconLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 14));
        p.add((Component)this.searchIconLabel, "East");
        this.add(p);
        int seconds = SettingsManager.instance().getSearchAnimationTime() * 1000;
        this.animationStopper = new Timer(seconds, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JLabel jLabel = StandardSearchView.this.searchIconLabel;
                synchronized (jLabel) {
                    StandardSearchView.this.searchIconLabel.setIcon(StandardSearchView.this.notsearchingIcon);
                }
            }
        });
        this.animationStopper.setRepeats(false);
        JPanel sndPanel = new JPanel();
        sndPanel.setLayout(new BorderLayout());
        this.searchLabel = new JLabel("                  ");
        sndPanel.add((Component)this.searchLabel, "West");
        JPanel speedPanel = new JPanel();
        speedPanel.setLayout(new FlowLayout());
        JLabel connLabel = new JLabel("Minimum connection speed (kbps)");
        this.minConnSpeed = new JTextField("0", 3);
        speedPanel.add(connLabel);
        speedPanel.add(this.minConnSpeed);
        sndPanel.add((Component)speedPanel, "East");
        this.results = new JPanel();
        this.results.setPreferredSize(new Dimension(10000, 10000));
        this.switcher = new CardLayout();
        this.results.setLayout(this.switcher);
        JPanel dummy = new JPanel();
        dummy.setLayout(new BorderLayout());
        JLabel resultLabel = new JLabel("Results");
        resultLabel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        dummy.add((Component)resultLabel, "North");
        dummy.add((Component)new ResultPanel(this, new GUID(new byte[16]), "", true), "Center");
        this.results.add("dummy", dummy);
        this.tabbedPane = new JTabbedPane();
        this.results.add("tabbedPane", this.tabbedPane);
        this.switcher.first(this.results);
        this.add(this.results);
        JMenuItem cancelEntry = new JMenuItem(KILL_STRING);
        cancelEntry.addActionListener(new AbstractAction(){

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                StandardSearchView.this.killSearch();
            }
        });
        this.menu.add(cancelEntry);
        JMenuItem stopEntry = new JMenuItem(STOP_STRING);
        stopEntry.addActionListener(new AbstractAction(){

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                StandardSearchView.this.stopSearch();
            }
        });
        this.menu.add(stopEntry);
        JMenuItem downloadAnyEntry = new JMenuItem(DOWNLOAD_ANY_STRING);
        downloadAnyEntry.addActionListener(new DownloadAnyAction(this));
        this.menu.add(downloadAnyEntry);
        JMenuItem downloadAllEntry = new JMenuItem(DOWNLOAD_ALL_STRING);
        downloadAllEntry.addActionListener(new DownloadAllAction(this));
        this.menu.add(downloadAllEntry);
        JMenuItem browseEntry = new JMenuItem(BROWSE_STRING);
        browseEntry.addActionListener(new BrowseAction(this));
        this.menu.add(browseEntry);
        this.tabbedPane.addMouseListener(new TabbedPaneMouseListener(this));
        String[] buttonLabelKeys = new String[]{"SEARCH_DOWNLOAD_ANY_BUTTON_LABEL", "SEARCH_DOWNLOAD_ALL_BUTTON_LABEL", "SEARCH_BROWSE_HOST_BUTTON_LABEL"};
        String[] buttonToolTipKeys = new String[]{"SEARCH_DOWNLOAD_ANY_BUTTON_TIP", "SEARCH_DOWNLOAD_ALL_BUTTON_TIP", "SEARCH_BROWSE_HOST_BUTTON_TIP"};
        DownloadAnyAction DownloadAnyListener = new DownloadAnyAction(this);
        DownloadAllAction DownloadAllListener = new DownloadAllAction(this);
        BrowseAction BrowseListener = new BrowseAction(this);
        ActionListener[] buttonListeners = new ActionListener[]{DownloadAnyListener, DownloadAllListener, BrowseListener};
        ButtonRow buttons = new ButtonRow(buttonLabelKeys, buttonToolTipKeys, buttonListeners, 0, 14);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(buttons);
        this.groupBox = new JCheckBox(GROUP_STRING, true);
        this.groupBox.addActionListener(new AbstractAction(){

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                StandardSearchView.this.setGrouped(StandardSearchView.this.groupBox.isSelected());
            }
        });
        buttonPanel.add(this.groupBox);
        this.add(buttonPanel);
        this._chatEntry = new JMenuItem("Chat with Host");
        this._chatEntry.addActionListener(new ChatAction(this));
        this.searchButton.addActionListener(new AbstractAction(){

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                StandardSearchView.this.triggerSearch();
            }
        });
        this.searchField.addActionListener(new AbstractAction(){

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent e) {
                StandardSearchView.this.triggerSearch();
            }
        });
        ActionListener StopListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                StandardSearchView.this.stopSearch();
            }
        };
        this.stopButton.addActionListener(StopListener);
    }

    public void showMenu(int x, int y) {
        this.menu.show(this.tabbedPane, x, y);
    }

    public void showMainMenu(int x, int y) {
        List list = this.entries;
        synchronized (list) {
            int i = this.tabbedPane.getSelectedIndex();
            if (i < 0) {
                return;
            }
            ResultPanel rp = (ResultPanel)this.entries.get(i);
            Iterator selected = rp.getSelectedRows();
            if (!selected.hasNext()) {
                return;
            }
            TableLine line = (TableLine)selected.next();
            boolean chat = line.chatEnabled();
            if (!chat) {
                this._rmenu.show(rp.getTable(), x, y);
            } else {
                this._rchatmenu.show(rp.getTable(), x, y);
            }
        }
    }

    public Icon getSelectedIcon() {
        int index = this.tabbedPane.getSelectedIndex();
        return this.tabbedPane.getIconAt(index);
    }

    public byte[] triggerSearch(String stext) {
        this.searchField.setText(stext);
        return this.triggerSearch();
    }

    private static boolean isGreedy(String search) {
        if (search.equals("*.*")) {
            return true;
        }
        String canonical = search.toLowerCase().replace('*', ' ').replace('.', ' ').trim();
        return canonical.equals("mp3") || canonical.equals("mpg") || canonical.equals("asf") || canonical.equals("jpg") || canonical.equals("mpeg") || canonical.equals("gif");
    }

    byte[] triggerSearch() {
        String stext = this.searchField.getText().trim();
        if (stext.equals("")) {
            return null;
        }
        if (stext.length() <= 2 && !"U2".equals(stext) && !"u2".equals(stext)) {
            this.mediator.showError("ERROR_THREE_CHARACTER_SEARCH");
            return null;
        }
        if (StandardSearchView.isGreedy(stext)) {
            boolean op = false;
            String msgKey = "ERROR_NETWORK_FLOODING";
            int response = this.mediator.showYesNoMessage(msgKey);
            if (response != 101) {
                return null;
            }
        }
        int minSpeed = 0;
        MediaType type = (MediaType)this.searchMediaBox.getSelectedItem();
        byte[] guidBytes = this.mediator.getRouter().query(stext, minSpeed, type);
        GUID guid = new GUID(guidBytes);
        this.addResultTab(guid, stext);
        return guidBytes;
    }

    private ResultPanel addResultTab(GUID guid, String stext) {
        final String label = stext;
        final ResultPanel panel = new ResultPanel(this, guid, stext, this.groupBox.isSelected());
        Runnable run = new Runnable(){

            public void run() {
                StandardSearchView.this.searchLabel.setText("Searching...");
                StandardSearchView.this.searchField.setText("");
                List list = StandardSearchView.this.entries;
                synchronized (list) {
                    StandardSearchView.this.entries.add((Object)panel);
                    StandardSearchView.this.tabbedPane.addTab(label, StandardSearchView.this.killIcon, panel);
                    StandardSearchView.this.tabbedPane.setSelectedIndex(StandardSearchView.this.entries.size() - 1);
                    if (StandardSearchView.this.entries.size() > SettingsManager.instance().getParallelSearchMax()) {
                        StandardSearchView.this.entries.remove(0);
                        StandardSearchView.this.tabbedPane.removeTabAt(0);
                    }
                }
                JLabel jLabel = StandardSearchView.this.searchIconLabel;
                synchronized (jLabel) {
                    StandardSearchView.this.searchIconLabel.setIcon(StandardSearchView.this.searchingIcon);
                }
                StandardSearchView.this.animationStopper.restart();
                StandardSearchView.this.switcher.last(StandardSearchView.this.results);
                StandardSearchView.this.revalidate();
            }
        };
        SwingUtilities.invokeLater(run);
        return panel;
    }

    public void addQueryReply(TableLine line, TableLine group, ResultPanel rp, int i) {
        ResultPanel resultPanel = rp;
        synchronized (resultPanel) {
            rp.addLine(line, group);
        }
        List list = this.entries;
        synchronized (list) {
            try {
                if (this.entries.get(i) != rp) {
                    i = -1;
                }
            }
            catch (IndexOutOfBoundsException e) {
                i = -1;
            }
            if (i == -1) {
                int j = 0;
                while (j < this.entries.size()) {
                    Object panel = this.entries.get(j);
                    if (panel == rp) {
                        i = j;
                        break;
                    }
                    ++j;
                }
            }
            if (i == -1) {
                return;
            }
            this.tabbedPane.setTitleAt(i, rp.getQuery() + " (" + rp.numResults() + ")");
        }
        this.animationStopper.restart();
    }

    void doDownload(boolean grouped) {
        ResultPanel rp;
        List list = this.entries;
        synchronized (list) {
            int i = this.tabbedPane.getSelectedIndex();
            if (i < 0) {
                return;
            }
            rp = (ResultPanel)this.entries.get(i);
        }
        if (grouped) {
            this.downloadAny(rp);
        } else {
            this.downloadAll(rp);
        }
    }

    private void downloadAny(ResultPanel rp) {
        ArrayList files = new ArrayList();
        ResultPanel resultPanel = rp;
        synchronized (resultPanel) {
            Iterator selected = rp.getSelectedRows();
            while (selected.hasNext()) {
                TableLine line = (TableLine)selected.next();
                if (line.children != null) {
                    int i = 0;
                    while (i < line.children.size()) {
                        TableLine child = (TableLine)line.children.get(i);
                        RemoteFileDesc rfd = child.toRemoteFileDesc();
                        if (!files.contains((Object)rfd)) {
                            files.add((Object)rfd);
                        }
                        ++i;
                    }
                    continue;
                }
                RemoteFileDesc rfd = line.toRemoteFileDesc();
                if (files.contains((Object)rfd)) continue;
                files.add((Object)rfd);
            }
        }
        Object[] filesA = new RemoteFileDesc[files.size()];
        files.toArray(filesA);
        this.downloadWithOverwritePrompt((RemoteFileDesc[])filesA);
    }

    protected void doChat() {
        List list = this.entries;
        synchronized (list) {
            int i = this.tabbedPane.getSelectedIndex();
            if (i < 0) {
                return;
            }
            ResultPanel rp = (ResultPanel)this.entries.get(i);
            Iterator selected = rp.getSelectedRows();
            if (!selected.hasNext()) {
                return;
            }
            TableLine line = (TableLine)selected.next();
            String host = line.location.getHostname();
            int port = line.location.getPort();
            RouterService backend = this.mediator.getRouter();
            backend.createChat(host, port);
        }
    }

    private void downloadAll(ResultPanel rp) {
        ArrayList downloaders = new ArrayList();
        ResultPanel resultPanel = rp;
        synchronized (resultPanel) {
            Iterator selected = rp.getSelectedRows();
            while (selected.hasNext()) {
                TableLine line = (TableLine)selected.next();
                if (line.children != null) {
                    RemoteFileDesc[] childrenRFDs = new RemoteFileDesc[line.children.size()];
                    int i = 0;
                    while (i < childrenRFDs.length) {
                        RemoteFileDesc rfd;
                        TableLine child = (TableLine)line.children.get(i);
                        childrenRFDs[i] = rfd = child.toRemoteFileDesc();
                        ++i;
                    }
                    downloaders.add((Object)childrenRFDs);
                    continue;
                }
                RemoteFileDesc rfd = line.toRemoteFileDesc();
                boolean alreadyAdded = false;
                if (!downloaders.isEmpty()) {
                    RemoteFileDesc[] last = (RemoteFileDesc[])downloaders.get(downloaders.size() - 1);
                    int i = 0;
                    while (i < last.length) {
                        if (last[i].equals(rfd)) {
                            alreadyAdded = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (alreadyAdded) continue;
                downloaders.add((Object)new RemoteFileDesc[]{rfd});
            }
        }
        Iterator iter = downloaders.iterator();
        while (iter.hasNext()) {
            this.downloadWithOverwritePrompt((RemoteFileDesc[])iter.next());
        }
    }

    private void downloadWithOverwritePrompt(RemoteFileDesc[] rfd) {
        if (rfd.length < 1) {
            return;
        }
        if (this.containsExe(rfd) && !this.userWantsExeDownload()) {
            return;
        }
        RouterService backend = this.mediator.getRouter();
        try {
            try {
                backend.download(rfd, false);
            }
            catch (FileExistsException e) {
                String fname = e.getFileName();
                String msgKey = "MESSAGE_OVERWRITE_EXISTING_FILE";
                String msg = "(" + fname + ")?";
                int response = this.mediator.showYesNoMessage(msgKey, msg);
                if (response != 101) {
                    return;
                }
                try {
                    backend.download(rfd, true);
                }
                catch (FileExistsException e2) {
                    Assert.that(false, "download(rfd, true) threw unexpected exception");
                }
            }
        }
        catch (AlreadyDownloadingException e) {
            this.mediator.showError("ERROR_ALREADY_DOWNLOADING", "\"" + e.getFilename() + "\".");
        }
        catch (FileNotFoundException fnfe) {
            this.mediator.showError("ERROR_ACCESSING_SAVE_DIRECTORY");
        }
    }

    private boolean containsExe(RemoteFileDesc[] rfd) {
        int i = 0;
        while (i < rfd.length) {
            if (rfd[i].getFileName().toLowerCase().endsWith("exe")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean userWantsExeDownload() {
        SettingsManager settings = SettingsManager.instance();
        if (!settings.getPromptExeDownload()) {
            return true;
        }
        String msg = "One of the selected files is an executable program and could contain a virus.  Are you sure you want to download it?";
        MultiLineLabel label = GUIUtils.getSizedLabel(msg);
        JCheckBox box = new JCheckBox("Don't show this message again", false);
        box.setForeground((Color)UIManager.get("Label.foreground"));
        JPanel messagePanel = new JPanel();
        messagePanel.setLayout(new BorderLayout());
        messagePanel.add((Component)label, "Center");
        messagePanel.add((Component)box, "South");
        int choice = JOptionPane.showConfirmDialog(this, messagePanel, "Download Request", 0);
        SettingsManager.instance().setPromptExeDownload(!box.isSelected());
        return choice == 0;
    }

    private void setGrouped(boolean grouped) {
        List list = this.entries;
        synchronized (list) {
            int i = 0;
            while (i < this.entries.size()) {
                ResultPanel rp = (ResultPanel)this.entries.get(i);
                rp.setGrouped(grouped);
                ++i;
            }
        }
    }

    void browseSelected() {
        TableLine line;
        ResultPanel rp;
        List list = this.entries;
        synchronized (list) {
            int i = this.tabbedPane.getSelectedIndex();
            if (i < 0) {
                return;
            }
            rp = (ResultPanel)this.entries.get(i);
        }
        ResultPanel resultPanel = rp;
        synchronized (resultPanel) {
            Iterator iter = rp.getSelectedRows();
            if (!iter.hasNext()) {
                return;
            }
            line = (TableLine)iter.next();
            if (!line.location.isNormal()) {
                return;
            }
        }
        String ip = line.location.getHostname();
        int port = line.location.getPort();
        String key = ip + ":" + port;
        rp = this.addResultTab(new GUID(new byte[16]), "files on " + key);
        byte[] guid = this.mediator.getRouter().browse(ip, port);
        if (guid == null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    StandardSearchView.this.mediator.showError("ERROR_BROWSE_FAILED");
                }
            });
        } else {
            rp.setGUID(new GUID(guid));
        }
    }

    void killSearch() {
        List list = this.entries;
        synchronized (list) {
            int i = this.tabbedPane.getSelectedIndex();
            if (i == -1) {
                return;
            }
            this.entries.remove(i);
            this.tabbedPane.removeTabAt(i);
            if (this.entries.size() == 0) {
                this.switcher.first(this.results);
                JLabel jLabel = this.searchIconLabel;
                synchronized (jLabel) {
                    this.searchIconLabel.setIcon(this.notsearchingIcon);
                }
            } else {
                this.checkToStopLime();
            }
        }
    }

    void stopSearch() {
        List list = this.entries;
        synchronized (list) {
            int i = this.tabbedPane.getSelectedIndex();
            if (i == -1) {
                return;
            }
            ResultPanel panel = (ResultPanel)this.entries.get(i);
            panel.setGUID(stoppedGUID);
            this.checkToStopLime();
        }
    }

    private void checkToStopLime() {
        boolean stopLime = true;
        int i = 0;
        while (i < this.entries.size()) {
            ResultPanel panel = (ResultPanel)this.entries.get(i);
            stopLime &= panel.matches(stoppedGUID);
            ++i;
        }
        if (stopLime) {
            JLabel jLabel = this.searchIconLabel;
            synchronized (jLabel) {
                this.searchIconLabel.setIcon(this.notsearchingIcon);
            }
        }
    }
}

