/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.search.CachingEndpoint;
import com.limegroup.gnutella.gui.search.QualityHolder;
import com.limegroup.gnutella.gui.search.ResultSpeed;
import com.limegroup.gnutella.gui.search.TableLineComparator;
import com.limegroup.gnutella.util.ApproximateMatcher;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.List;

public class TableLine {
    Integer size;
    byte[] clientGUID;
    Integer index;
    String processedFilename = null;
    List children;
    int childName = 0;
    String filenameWithoutExtension;
    String extension;
    String sizeString;
    ResultSpeed speed;
    Integer score;
    QualityHolder quality;
    CachingEndpoint location;
    boolean chatEnabled;

    TableLine() {
        this.children = new ArrayList();
    }

    TableLine(TableLine other) {
        this(other.getFilename(), other.size, new Integer(other.speed.intValue()), other.score, other.location.getHostname(), new Integer(other.location.getPort()), other.clientGUID, other.index, other.quality, other.speed.isMeasured(), other.chatEnabled());
    }

    public TableLine(String filename, Integer size, Integer speed, Integer score, String host, Integer port, byte[] clientGUID, Integer index, QualityHolder quality, boolean isMeasuredSpeed, boolean chatEnabled) {
        this.speed = new ResultSpeed(speed, isMeasuredSpeed);
        this.size = size;
        this.clientGUID = clientGUID;
        this.index = index;
        this.children = null;
        this.quality = quality;
        this.chatEnabled = chatEnabled;
        int i = filename.lastIndexOf(46);
        if (i == -1) {
            this.filenameWithoutExtension = filename;
            this.extension = "";
        } else {
            this.filenameWithoutExtension = filename.substring(0, i);
            this.extension = filename.substring(i + 1);
        }
        this.sizeString = GUIUtils.toKilobytes(size);
        this.score = score;
        this.location = new CachingEndpoint(host, (int)port);
    }

    static Comparator newComparator(int field, boolean ascending) {
        return new TableLineComparator(field, ascending);
    }

    public void setSpeed(ResultSpeed speed) {
        this.speed = speed;
    }

    public ResultSpeed getSpeed() {
        return this.speed;
    }

    public void setQuality(int quality) {
        this.quality = new QualityHolder(quality);
    }

    public int getQuality() {
        return this.quality.getInt();
    }

    public boolean chatEnabled() {
        return this.chatEnabled;
    }

    public String getFilename() {
        if (this.extension.equals("")) {
            return this.filenameWithoutExtension;
        }
        return this.filenameWithoutExtension + "." + this.extension;
    }

    public int match(TableLine o, ApproximateMatcher matcher) {
        if (this.processedFilename == null) {
            this.processedFilename = matcher.process(this.filenameWithoutExtension);
        }
        if (o.processedFilename == null) {
            o.processedFilename = matcher.process(o.filenameWithoutExtension);
        }
        if (!this.extension.equals(o.extension)) {
            return 1;
        }
        float sizeDiff = Math.abs((float)this.size.intValue() - (float)o.size.intValue());
        if (sizeDiff > 60000.0f) {
            return 2;
        }
        int allowedDifferences = Math.round(Math.min(0.1f * (float)this.filenameWithoutExtension.length(), 0.1f * (float)o.filenameWithoutExtension.length()));
        if (!matcher.matches(this.processedFilename, o.processedFilename, allowedDifferences = Math.min(allowedDifferences, 4))) {
            return 3;
        }
        return 0;
    }

    public RemoteFileDesc toRemoteFileDesc() {
        return new RemoteFileDesc(this.location.getHostname(), this.location.getPort(), this.index, this.getFilename(), this.size, this.clientGUID, this.speed.intValue(), this.chatEnabled);
    }

    public String toString() {
        return this.filenameWithoutExtension;
    }
}

