/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.search.CachingEndpoint;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.util.StringUtils;
import com.sun.java.util.collections.Comparator;

class TableLineComparator
implements Comparator {
    int field;
    boolean ascending;

    TableLineComparator(int field, boolean ascending) {
        this.field = field;
        this.ascending = ascending;
    }

    public int compare(Object a, Object b) {
        TableLine atl = (TableLine)a;
        TableLine btl = (TableLine)b;
        int factor = this.ascending ? 1 : -1;
        switch (this.field) {
            case 1: {
                return factor * StringUtils.compareIgnoreCase(atl.filenameWithoutExtension, btl.filenameWithoutExtension);
            }
            case 2: {
                return factor * StringUtils.compareIgnoreCase(atl.extension, btl.extension);
            }
            case 3: {
                return factor * -(atl.size - btl.size);
            }
            case 4: {
                return factor * -atl.speed.compareTo(btl.speed);
            }
            case 5: {
                return factor * -(atl.score - btl.score);
            }
            case 0: {
                return factor * -(atl.quality.getInt() - btl.quality.getInt());
            }
            case 6: {
                boolean bIsPrivate;
                CachingEndpoint ea = atl.location;
                CachingEndpoint eb = btl.location;
                int cmp = factor * (eb.numLocations() - ea.numLocations());
                if (cmp != 0) {
                    return cmp;
                }
                boolean aIsPrivate = ea.isPrivateAddress();
                if (aIsPrivate != (bIsPrivate = eb.isPrivateAddress())) {
                    return factor * (aIsPrivate ? 1 : -1);
                }
                return factor * StringUtils.compareIgnoreCase(atl.location.getHostname(), btl.location.getHostname());
            }
        }
        return 0;
    }

    public boolean equals(Object o) {
        return false;
    }
}

