/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.util.ApproximateMatcher;
import com.limegroup.gnutella.util.ArrayListUtil;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.NoSuchElementException;
import com.sun.java.util.collections.SortedMap;
import com.sun.java.util.collections.TreeMap;

public final class TableLineGrouper {
    private SortedMap map = new TreeMap(ArrayListUtil.integerComparator());
    private final ApproximateMatcher matcher = new ApproximateMatcher(120);

    public TableLineGrouper() {
        this.matcher.setIgnoreCase(true);
        this.matcher.setIgnoreWhitespace(true);
        this.matcher.setCompareBackwards(true);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    private int matchHelper(List list, TableLine line) {
        Assert.that(list != null, "Trying to match null list");
        Assert.that(line != null, "Trying to match null line");
        int j = 0;
        while (j < list.size()) {
            TableLine line2 = (TableLine)list.get(j);
            int match = line2.match(line, this.matcher);
            if (match == 0) {
                return j;
            }
            if (match == 2) {
                return -2;
            }
            ++j;
        }
        return -1;
    }

    public TableLine match(TableLine line) {
        Integer key = line.size;
        Iterator iter = this.map.tailMap((Object)key).values().iterator();
        while (iter.hasNext()) {
            List lines = (List)iter.next();
            int ret = this.matchHelper(lines, line);
            if (ret >= 0) {
                return (TableLine)lines.get(ret);
            }
            if (ret == -2) break;
        }
        SortedMap map = this.map.headMap((Object)key);
        while (true) {
            Integer key2;
            try {
                key2 = (Integer)map.lastKey();
            }
            catch (NoSuchElementException e) {
                break;
            }
            List lines = (List)map.get((Object)key2);
            int ret = this.matchHelper(lines, line);
            if (ret >= 0) {
                return (TableLine)lines.get(ret);
            }
            if (ret == -2) break;
            map = map.headMap((Object)key2);
        }
        return null;
    }

    public void add(TableLine line) {
        Integer key = line.size;
        List lines = (List)this.map.get((Object)key);
        if (lines == null) {
            lines = new LinkedList();
            lines.add((Object)line);
            this.map.put((Object)key, (Object)lines);
        } else {
            lines.add((Object)line);
        }
    }
}

