/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.update;

import com.limegroup.gnutella.update.UpdateConstants;
import com.limegroup.gnutella.util.CommonUtils;
import java.net.URLEncoder;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class LocalUpdateInfo
implements UpdateConstants {
    private String _os;
    private String _limeWireVersion;
    private String _jvm;

    public LocalUpdateInfo() {
    }

    public LocalUpdateInfo(String version, String os) {
        this._os = os;
        this._limeWireVersion = version;
        this._jvm = CommonUtils.getJavaVersion();
    }

    public void setLocalData() {
        this._os = CommonUtils.getOS();
        this._limeWireVersion = CommonUtils.getLimeWireVersion();
        this._jvm = CommonUtils.getJavaVersion();
    }

    public String getOS() {
        return this._os;
    }

    public String getLimeWireVersion() {
        return this._limeWireVersion;
    }

    public String getJVM() {
        return this._jvm;
    }

    public void setOS(String os) {
        this._os = os;
    }

    public void setLimeWireVersion(String limeWireVersion) {
        this._limeWireVersion = limeWireVersion;
    }

    public void setJVM(String jvm) {
        this._jvm = jvm;
    }

    final String getPostRequestString() {
        StringBuffer sb = new StringBuffer();
        sb.append("OS");
        sb.append("=");
        sb.append(URLEncoder.encode(this._os));
        sb.append("&");
        sb.append("LIMEWIRE_VERSION");
        sb.append("=");
        sb.append(URLEncoder.encode(this._limeWireVersion));
        sb.append("&");
        sb.append("JVM");
        sb.append("=");
        sb.append(URLEncoder.encode(this._jvm));
        return sb.toString();
    }

    private void processNameValuePair(String nameValuePair) {
        try {
            StringTokenizer equalToTokenizer = new StringTokenizer(nameValuePair, "=");
            String name = equalToTokenizer.nextToken();
            String value = equalToTokenizer.nextToken();
            if (name.equals("OS")) {
                this._os = value;
            } else if (name.equals("LIMEWIRE_VERSION")) {
                this._limeWireVersion = value;
            } else if (name.equals("JVM")) {
                this._jvm = value;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public String toString() {
        return "os=" + this._os + "\nLimeWireVersion=" + this._limeWireVersion + "JVM=" + this._jvm;
    }
}

