/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.update;

import com.limegroup.gnutella.update.DisplayMessageUpdator;
import com.limegroup.gnutella.update.MultipleFileUpdator;
import com.limegroup.gnutella.update.NoUpdateUpdator;
import com.limegroup.gnutella.update.UpdateConstants;
import com.limegroup.gnutella.update.Updator;
import com.limegroup.gnutella.update.WebPageUpdator;
import com.limegroup.gnutella.util.URLDecoder;
import java.net.URLEncoder;
import java.util.StringTokenizer;

public class RemoteUpdateInfo
implements UpdateConstants {
    private Updator _updator;
    private String _directive;
    private String _url;
    private String _message;
    private String _classpath;
    private String _mainClass;

    public RemoteUpdateInfo() {
        this._updator = new NoUpdateUpdator();
    }

    public RemoteUpdateInfo(String directive, String url, String message, String classpath, String mainClass) {
        this._directive = directive;
        this._url = url;
        this._message = message;
        this._classpath = classpath;
        this._mainClass = mainClass;
    }

    public String getURLEncodedString() {
        StringBuffer sb = new StringBuffer();
        sb.append("DIRECTIVE");
        sb.append("=");
        sb.append(URLEncoder.encode(this._directive));
        sb.append("&");
        sb.append("UPDATE_URL");
        sb.append("=");
        sb.append(URLEncoder.encode(this._url));
        sb.append("&");
        sb.append("MESSAGE_TO_DISPLAY");
        sb.append("=");
        sb.append(URLEncoder.encode(this._message));
        sb.append("&");
        sb.append("UPDATE_CLASSPATH");
        sb.append("=");
        sb.append(URLEncoder.encode(this._classpath));
        sb.append("&");
        sb.append("UPDATE_MAIN_CLASS");
        sb.append("=");
        sb.append(URLEncoder.encode(this._mainClass));
        return sb.toString();
    }

    final void addRemoteInfo(String infoLine) {
        StringTokenizer st = new StringTokenizer(infoLine, "&");
        while (st.hasMoreTokens()) {
            String line = st.nextToken();
            this.handleKeyValuePair(line);
        }
    }

    final Updator getUpdator() {
        return this._updator;
    }

    private void handleKeyValuePair(String line) {
        if (line.startsWith("DIRECTIVE")) {
            this.setUpdator(line);
        } else if (line.startsWith("MESSAGE_TO_DISPLAY")) {
            this._updator.setMessageToDisplay(this.getUpdateValue(line));
        } else if (line.startsWith("UPDATE_URL")) {
            this._updator.setUpdateURL(this.getUpdateValue(line));
        } else if (line.startsWith("UPDATE_CLASSPATH")) {
            this._updator.setClassPath(this.getUpdateValue(line));
        } else if (line.startsWith("UPDATE_MAIN_CLASS")) {
            this._updator.setMainClass(this.getUpdateValue(line));
        }
    }

    private final String getUpdateValue(String line) {
        int index = line.lastIndexOf("=") + 1;
        line = URLDecoder.decode(line.substring(index));
        return line.trim();
    }

    private final void setUpdator(String str) {
        int index = str.lastIndexOf("=") + 1;
        String directiveValue = URLDecoder.decode(str.substring(index));
        if (directiveValue.startsWith("NO_UPDATE")) {
            this._updator = new NoUpdateUpdator();
        } else if (directiveValue.startsWith("UPDATE_JAR")) {
            this._updator = new MultipleFileUpdator();
        } else if (directiveValue.startsWith("OPEN_WEB_PAGE")) {
            this._updator = new WebPageUpdator();
        } else if (directiveValue.startsWith("DISPLAY_MESSAGE")) {
            this._updator = new DisplayMessageUpdator();
        }
    }
}

