/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.update;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.update.UpdateConstants;
import com.limegroup.gnutella.update.UpdateManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class UpdateGUIHandler
implements UpdateConstants {
    private static final UpdateGUIHandler INSTANCE = new UpdateGUIHandler();
    private final SettingsManager SETTINGS = SettingsManager.instance();
    private ProgressWindow _progressWindow;

    static final synchronized UpdateGUIHandler instance() {
        return INSTANCE;
    }

    private UpdateGUIHandler() {
    }

    final boolean showUpdatePrompt(String message) {
        UpdatePanel updatePanel = new UpdatePanel(message);
        int i = JOptionPane.showConfirmDialog(null, updatePanel, "Update", 0);
        return i == 0;
    }

    final void showProgressWindow() {
        this._progressWindow = new ProgressWindow();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((Component)UpdateGUIHandler.this._progressWindow).setVisible(true);
            }
        });
    }

    final void setDownloadFile(String text) {
        this._progressWindow.setDownloadFile(text);
    }

    final void setDownloadSize(int size) {
        this._progressWindow.setDownloadSize(size);
    }

    final void hideProgressWindow() {
        ((Component)this._progressWindow).setVisible(false);
        this._progressWindow.dispose();
    }

    final void updateProgressWindow(int amountRead) {
        this._progressWindow.setAmountRead(amountRead);
        SwingUtilities.invokeLater(this._progressWindow);
    }

    final void displayErrorMessage(String error) {
        String msgStart = "UPDATE_ERROR_MESSAGE_START";
        String msgEnd = "UPDATE_ERROR_MESSAGE_END";
        GUIMediator.instance().showError(msgStart, error, msgEnd);
    }

    final void displayMessage(String message) {
        GUIMediator.instance().showMessage(message);
    }

    static /* synthetic */ SettingsManager access$600(UpdateGUIHandler x0) {
        return x0.SETTINGS;
    }

    private class ProgressWindow
    extends JDialog
    implements Runnable {
        private final JProgressBar _progressBar;
        private double _downloadSize;
        private double _amountRead;
        private JLabel _label;

        public ProgressWindow() {
            ((Component)this).setSize(460, 140);
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ ProgressWindow this$1;
                {
                    this.this$1 = this$1;
                }

                public void windowClosing(WindowEvent e) {
                    ProgressWindow.access$700(this.this$1);
                }
            });
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            ((Component)this).setLocation((screenSize.width - 350) / 2, (screenSize.height - 140) / 2);
            JPanel panel = new JPanel();
            JPanel labelPanel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            labelPanel.setLayout(new BoxLayout(labelPanel, 0));
            Border border = BorderFactory.createEmptyBorder(12, 12, 12, 12);
            panel.setBorder(border);
            this._progressBar = new JProgressBar();
            this._progressBar.setStringPainted(true);
            this._progressBar.setString("0%");
            this._label = new JLabel("Contacting the LimeWire server...");
            labelPanel.add(this._label);
            labelPanel.add(Box.createHorizontalGlue());
            this._downloadSize = 1000.0;
            this._amountRead = 0.0;
            String[] buttonLabelKeys = new String[]{"UPDATE_CANCEL_BUTTON_LABEL"};
            String[] toolTipKeys = new String[]{"UPDATE_CANCEL_BUTTON_TIP"};
            ActionListener buttonListener = new ActionListener(this){
                private final /* synthetic */ ProgressWindow this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    ProgressWindow.access$700(this.this$1);
                }
            };
            ActionListener[] listeners = new ActionListener[]{buttonListener};
            ButtonRow br = new ButtonRow(buttonLabelKeys, toolTipKeys, listeners);
            panel.add(labelPanel);
            panel.add(Box.createVerticalStrut(6));
            panel.add(this._progressBar);
            panel.add(Box.createVerticalStrut(6));
            panel.add(br);
            this.getContentPane().add(panel);
        }

        public void run() {
            int percent = (int)(100.0 * (this._amountRead / this._downloadSize));
            this._progressBar.setValue(percent);
            this._progressBar.setString(Integer.toString(percent) + "%");
        }

        private void setDownloadFile(String fileName) {
            this._label.setText("Downloading: " + fileName + "...");
        }

        private void setAmountRead(int amountRead) {
            this._amountRead = amountRead;
        }

        private void setDownloadSize(int size) {
            this._downloadSize = size;
        }

        private void cancelUpdate() {
            UpdateManager.instance().cancelUpdate();
        }

        static /* synthetic */ void access$700(ProgressWindow x0) {
            x0.cancelUpdate();
        }
    }

    private class UpdatePanel
    extends JPanel {
        private UpdatePanel(String msg) {
            MultiLineLabel label = GUIUtils.getSizedLabel(msg);
            String checkLabel = "Don't inform me of updates.";
            JCheckBox checkBox = new JCheckBox(checkLabel);
            checkBox.setForeground((Color)UIManager.get("Label.foreground"));
            checkBox.addItemListener(new ItemListener(this, checkBox){
                private final /* synthetic */ JCheckBox val$checkBox;
                private final /* synthetic */ UpdatePanel this$1;
                {
                    this.this$1 = this$1;
                    this.val$checkBox = val$checkBox;
                }

                public void itemStateChanged(ItemEvent e) {
                    UpdateGUIHandler.access$600(UpdatePanel.access$500(this.this$1)).setCheckAgain(!this.val$checkBox.isSelected());
                }
            });
            JPanel checkBoxPanel = new JPanel();
            checkBoxPanel.add(checkBox);
            checkBoxPanel.add(Box.createHorizontalGlue());
            this.setLayout(new BoxLayout(this, 1));
            this.add(label);
            this.add(Box.createVerticalStrut(6));
            this.add(checkBoxPanel);
        }

        static /* synthetic */ UpdateGUIHandler access$500(UpdatePanel x0) {
            return x0.UpdateGUIHandler.this;
        }
    }
}

