/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.update;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.update.LocalUpdateInfo;
import com.limegroup.gnutella.update.RemoteUpdateInfo;
import com.limegroup.gnutella.update.ServletAccessor;
import com.limegroup.gnutella.update.Updator;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class UpdateManager {
    private final boolean TESTING = false;
    private static final UpdateManager INSTANCE = new UpdateManager();
    private Updator _updator;

    public static UpdateManager instance() {
        return INSTANCE;
    }

    private UpdateManager() {
    }

    public void doUpdate() {
        this.performStandardUpdate();
    }

    void cancelUpdate() {
        this._updator.cancelUpdate();
    }

    void setUpdator(Updator updator) {
        this._updator = updator;
    }

    private void performStandardUpdate() {
        LocalUpdateInfo localInfo = new LocalUpdateInfo();
        localInfo.setLocalData();
        ServletAccessor sa = new ServletAccessor();
        RemoteUpdateInfo remoteInfo = sa.getRemoteUpdateInfo(localInfo);
        if (SettingsManager.instance().getCheckAgain()) {
            this._updator = remoteInfo.getUpdator();
            this._updator.doUpdate();
        }
    }

    private void startTest() {
        Properties props = new Properties();
        try {
            FileInputStream fis = new FileInputStream(new File("update.props"));
            try {
                props.load(fis);
            }
            catch (IOException fne) {
                this.performStandardUpdate();
                return;
            }
        }
        catch (FileNotFoundException fnfe) {
            this.performStandardUpdate();
            return;
        }
        catch (SecurityException se) {
            this.performStandardUpdate();
            return;
        }
        ServletAccessor sa = new ServletAccessor();
        String version = props.getProperty("limewire.version");
        String os = props.getProperty("os.version");
        LocalUpdateInfo localInfo = new LocalUpdateInfo(version, os);
        RemoteUpdateInfo remoteInfo = sa.getRemoteUpdateInfo(localInfo);
        this._updator = remoteInfo.getUpdator();
        this._updator.doUpdate();
    }
}

