/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.uploader.FileNotFoundUploadState;
import com.limegroup.gnutella.uploader.FreeloaderUploadState;
import com.limegroup.gnutella.uploader.FreeloaderUploadingException;
import com.limegroup.gnutella.uploader.LimitReachedUploadState;
import com.limegroup.gnutella.uploader.NormalUploadState;
import com.limegroup.gnutella.uploader.PushFailedUploadState;
import com.limegroup.gnutella.uploader.UploadState;
import com.limegroup.gnutella.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class HTTPUploader
implements Uploader {
    protected OutputStream _ostream;
    protected FileInputStream _fis;
    protected Socket _socket;
    protected int _amountRead;
    protected int _uploadBegin;
    protected int _uploadEnd;
    protected int _fileSize;
    protected int _index;
    protected String _filename;
    protected String _hostName;
    protected String _guid;
    protected int _port;
    protected int _stateNum = 0;
    private UploadState _state;
    private UploadManager _manager;
    private boolean _chatEnabled;
    private String _chatHost;
    private int _chatPort;

    public HTTPUploader(String file, Socket s, int index, UploadManager m) {
        this._socket = s;
        this._hostName = this._socket.getInetAddress().getHostAddress();
        this._filename = file;
        this._manager = m;
        this._index = index;
        this._amountRead = 0;
        boolean indexOut = false;
        boolean ioexcept = false;
        try {
            this._ostream = this._socket.getOutputStream();
            FileDesc desc = FileManager.instance().get(this._index);
            this._fileSize = desc._size;
        }
        catch (IndexOutOfBoundsException e) {
            indexOut = true;
        }
        catch (IOException e) {
            ioexcept = true;
        }
        if (indexOut) {
            this.setState(7);
        } else if (ioexcept) {
            this.setState(5);
        } else {
            this.setState(0);
        }
    }

    public HTTPUploader(String file, String host, int port, int index, String guid, UploadManager m) {
        this._filename = file;
        this._manager = m;
        this._index = index;
        this._uploadBegin = 0;
        this._amountRead = 0;
        this._hostName = host;
        this._guid = guid;
        this._port = port;
        try {
            FileDesc desc = FileManager.instance().get(this._index);
            this._fileSize = desc._size;
            this.setState(0);
        }
        catch (IndexOutOfBoundsException e) {
            this.setState(6);
        }
    }

    public void connect() throws IOException {
        if (this._socket != null) {
            return;
        }
        try {
            this._socket = new Socket(this._hostName, this._port);
            this._ostream = this._socket.getOutputStream();
            Assert.that(this._filename != null);
            Assert.that(this._filename != "");
            String giv = "GIV " + this._index + ":" + this._guid + "/" + this._filename + "\n\n";
            this._ostream.write(giv.getBytes());
            this._ostream.flush();
            InputStream istream = this._socket.getInputStream();
            ByteReader in = new ByteReader(istream);
            int time = SettingsManager.instance().getTimeout();
            this._socket.setSoTimeout(time);
            String str = in.readLine();
            this._socket.setSoTimeout(0);
            if (str == null) {
                throw new IOException();
            }
            if (!str.startsWith("GET")) {
                throw new IOException();
            }
            String command = str.substring(4, str.length());
            String[] parse = StringUtils.split(command, '/');
            if (parse.length != 4) {
                throw new IOException();
            }
            if (!parse[0].equals("get")) {
                throw new IOException();
            }
            int end = parse[2].lastIndexOf("HTTP") - 1;
            String filename = parse[2].substring(0, end);
            if (!filename.equals(this._filename)) {
                throw new IOException();
            }
            int pindex = Integer.parseInt(parse[1]);
            if (pindex != this._index) {
                throw new IOException();
            }
        }
        catch (SecurityException e) {
            this.setState(6);
            throw new IOException();
        }
        catch (IndexOutOfBoundsException e) {
            this.setState(6);
            throw new IOException();
        }
        catch (NumberFormatException e) {
            this.setState(6);
            throw new IOException();
        }
        catch (IllegalArgumentException e) {
            this.setState(6);
            throw new IOException();
        }
        catch (IOException e) {
            this.setState(6);
            throw new IOException();
        }
    }

    public void start() {
        try {
            this.prepareFile();
        }
        catch (IOException e) {
            this.setState(7);
        }
        try {
            this.readHeader();
            this._state.doUpload(this);
        }
        catch (FreeloaderUploadingException e) {
            this.setState(1);
            try {
                this._state.doUpload(this);
            }
            catch (IOException e2) {}
        }
        catch (IOException e) {
            this.setState(5);
        }
        this.stop();
    }

    public void stop() {
        try {
            if (this._ostream != null) {
                this._ostream.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this._fis != null) {
                this._fis.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            if (this._socket != null) {
                this._socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setState(int state) {
        this._stateNum = state;
        switch (state) {
            case 0: {
                this._state = new NormalUploadState();
                break;
            }
            case 2: {
                this._state = new LimitReachedUploadState();
                break;
            }
            case 6: {
                this._state = new PushFailedUploadState();
                break;
            }
            case 1: {
                this._state = new FreeloaderUploadState();
                break;
            }
            case 7: {
                this._state = new FileNotFoundUploadState();
            }
        }
    }

    public OutputStream getOutputStream() {
        return this._ostream;
    }

    public int getIndex() {
        return this._index;
    }

    public String getFileName() {
        return this._filename;
    }

    public int getFileSize() {
        return this._fileSize;
    }

    public FileInputStream getFileInputStream() {
        return this._fis;
    }

    public int amountUploaded() {
        return this._amountRead;
    }

    public void setAmountUploaded(int amount) {
        this._amountRead = amount;
    }

    public int getUploadBegin() {
        return this._uploadBegin;
    }

    public int getState() {
        return this._stateNum;
    }

    public String getHost() {
        return this._hostName;
    }

    public UploadManager getManager() {
        return this._manager;
    }

    public String getThisHost() {
        return this._manager.getThisHost();
    }

    public int getThisPort() {
        return this._manager.getThisPort();
    }

    public boolean chatEnabled() {
        return this._chatEnabled;
    }

    public String getChatHost() {
        return this._chatHost;
    }

    public int getChatPort() {
        return this._chatPort;
    }

    private void readHeader() throws IOException {
        String str = " ";
        this._uploadBegin = 0;
        this._uploadEnd = 0;
        InputStream istream = this._socket.getInputStream();
        ByteReader br = new ByteReader(istream);
        while ((str = br.readLine()) != null && !str.equals("")) {
            String sub;
            if (str.toUpperCase().indexOf("CHAT:") != -1) {
                int port;
                try {
                    sub = str.substring(5);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new IOException();
                }
                sub = sub.trim();
                int colon = sub.indexOf(":");
                String host = sub.substring(0, colon);
                host = host.trim();
                String sport = sub.substring(colon + 1);
                sport = sport.trim();
                try {
                    port = Integer.parseInt(sport);
                }
                catch (NumberFormatException e) {
                    throw new IOException();
                }
                this._chatEnabled = true;
                this._chatHost = host;
                this._chatPort = port;
            }
            if (this.indexOfIgnoreCase(str, "Range: bytes=") != -1 || this.indexOfIgnoreCase(str, "Range: bytes ") != -1) {
                String second2;
                String first;
                char c;
                try {
                    sub = str.substring(13);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new IOException();
                }
                sub = sub.trim();
                try {
                    c = sub.charAt(0);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new IOException();
                }
                if (c == '-') {
                    String second2;
                    try {
                        second2 = sub.substring(1);
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw new IOException();
                    }
                    second2 = second2.trim();
                    try {
                        this._uploadEnd = Integer.parseInt(second2);
                    }
                    catch (NumberFormatException e) {
                        throw new IOException();
                    }
                }
                int dash = sub.indexOf("-");
                try {
                    first = sub.substring(0, dash);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new IOException();
                }
                first = first.trim();
                try {
                    this._uploadBegin = Integer.parseInt(first);
                }
                catch (NumberFormatException e) {
                    throw new IOException();
                }
                try {
                    second2 = sub.substring(dash + 1);
                }
                catch (IndexOutOfBoundsException e) {
                    throw new IOException();
                }
                second2 = second2.trim();
                if (!second2.equals("")) {
                    try {
                        this._uploadEnd = Integer.parseInt(second2);
                    }
                    catch (NumberFormatException e) {
                        throw new IOException();
                    }
                }
            }
            if (this.indexOfIgnoreCase(str, "User-Agent:") == -1) continue;
            if (!(SettingsManager.instance().getAllowBrowser() || str.indexOf("Mozilla") == -1 && str.indexOf("DA") == -1 && str.indexOf("Download") == -1 && str.indexOf("FlashGet") == -1 && str.indexOf("GetRight") == -1 && str.indexOf("Go!Zilla") == -1 && str.indexOf("Inet") == -1 && str.indexOf("MIIxpc") == -1 && str.indexOf("MSProxy") == -1 && str.indexOf("Mass") == -1 && str.indexOf("MyGetRight") == -1 && str.indexOf("NetAnts") == -1 && str.indexOf("NetZip") == -1 && str.indexOf("RealDownload") == -1 && str.indexOf("SmartDownload") == -1 && str.indexOf("Teleport") == -1 && str.indexOf("WebDownloader") == -1)) {
                throw new FreeloaderUploadingException();
            }
            String userAgent = str.substring(11).trim();
        }
        if (this._uploadEnd == 0) {
            this._uploadEnd = this._fileSize;
        }
    }

    private int indexOfIgnoreCase(String str, String section) {
        String aaa = str.toLowerCase();
        String bbb = section.toLowerCase();
        return aaa.indexOf(bbb);
    }

    private void prepareFile() throws IOException {
        FileDesc fdesc;
        try {
            fdesc = FileManager.instance().get(this._index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new IOException();
        }
        String name = fdesc._name;
        if (this._filename == null) {
            this._filename = name;
        } else if (!name.equals(this._filename)) {
            throw new IOException();
        }
        this._fileSize = fdesc._size;
        String path = fdesc._path;
        File myFile = new File(path);
        this._fis = new FileInputStream(myFile);
    }
}

