/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.UploadState;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;

public class NormalUploadState
implements UploadState {
    public static final int CYCLE_TIME = 1000;
    private HTTPUploader _uploader;
    private OutputStream _ostream;
    private int _index;
    private String _filename;
    private int _fileSize;
    private FileInputStream _fis;
    private int _amountRead;
    private int _uploadBegin;

    public void doUpload(HTTPUploader uploader) throws IOException {
        this._uploader = uploader;
        this._uploader.setState(3);
        this._ostream = this._uploader.getOutputStream();
        this._index = this._uploader.getIndex();
        this._filename = this._uploader.getFileName();
        this._fileSize = this._uploader.getFileSize();
        this._fis = this._uploader.getFileInputStream();
        this._amountRead = this._uploader.amountUploaded();
        this._uploadBegin = this._uploader.getUploadBegin();
        this.writeHeader();
        int c = -1;
        boolean available = false;
        byte[] buf = new byte[1024];
        long a = this._fis.skip(this._uploadBegin);
        this._amountRead = (int)((long)this._amountRead + a);
        this._uploader.setAmountUploaded(this._amountRead);
        SettingsManager manager = SettingsManager.instance();
        int speed = manager.getUploadSpeed();
        if (speed == 100) {
            while ((c = this._fis.read(buf)) != -1) {
                try {
                    this._ostream.write(buf, 0, c);
                }
                catch (SocketException e) {
                    throw new IOException();
                }
                this._amountRead += c;
                this._uploader.setAmountUploaded(this._amountRead);
            }
        } else {
            block7: while (true) {
                int max = this._uploader.getManager().calculateBandwidth();
                int burstSize = max * 1000;
                int burstSent = 0;
                long start = System.currentTimeMillis();
                while (burstSent < burstSize) {
                    c = this._fis.read(buf);
                    if (c == -1) break block7;
                    try {
                        this._ostream.write(buf, 0, c);
                    }
                    catch (SocketException e) {
                        throw new IOException();
                    }
                    this._amountRead += c;
                    this._uploader.setAmountUploaded(this._amountRead);
                    burstSent += c;
                }
                long stop = System.currentTimeMillis();
                int elapsed = (int)(stop - start);
                int sleepTime = 1000 - elapsed;
                if (sleepTime <= 0) continue;
                try {
                    Thread.currentThread();
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException e) {
                    throw new IOException();
                }
            }
        }
        this._uploader.setState(4);
        this._ostream.close();
    }

    private String getMimeType() {
        String mimetype = "application/binary";
        return mimetype;
    }

    private void writeHeader() throws IOException {
        String str = "HTTP 200 OK \r\n";
        this._ostream.write(str.getBytes());
        str = "Server: " + CommonUtils.getVendor() + "\r\n";
        this._ostream.write(str.getBytes());
        String type = this.getMimeType();
        str = "Content-type:" + type + "\r\n";
        this._ostream.write(str.getBytes());
        str = "Content-length:" + (this._fileSize - this._uploadBegin) + "\r\n";
        this._ostream.write(str.getBytes());
        if (this._uploadBegin != 0) {
            str = "Content-range: bytes=" + this._uploadBegin + "-" + (this._fileSize - 1) + "/" + this._fileSize + "\r\n";
            this._ostream.write(str.getBytes());
        }
        str = "\r\n";
        this._ostream.write(str.getBytes());
    }
}

