/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.util.Buffer;
import com.limegroup.gnutella.util.UnmodifiableIterator;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.NoSuchElementException;

public class BucketQueue
implements Cloneable {
    private Buffer[] buckets;

    public BucketQueue(int[] capacities) {
        this.buckets = new Buffer[capacities.length];
        int i = 0;
        while (i < this.buckets.length) {
            this.buckets[i] = new Buffer(capacities[i]);
            ++i;
        }
    }

    public BucketQueue(BucketQueue other) {
        this.buckets = new Buffer[other.buckets.length];
        int i = 0;
        while (i < this.buckets.length) {
            this.buckets[i] = new Buffer(other.buckets[i]);
            ++i;
        }
    }

    public void clear() {
        int i = 0;
        while (i < this.buckets.length) {
            this.buckets[i].clear();
            ++i;
        }
    }

    public Endpoint insert(Endpoint e) {
        int weight = e.getWeight();
        return (Endpoint)this.buckets[weight].addFirst(e);
    }

    public boolean removeAll(Endpoint e) {
        boolean ret = false;
        int i = 0;
        while (i < this.buckets.length) {
            ret |= this.buckets[i].removeAll(e);
            ++i;
        }
        return ret;
    }

    public Endpoint extractMax() throws NoSuchElementException {
        int i = this.buckets.length - 1;
        while (i >= 0) {
            if (!this.buckets[i].isEmpty()) {
                return (Endpoint)this.buckets[i].removeFirst();
            }
            --i;
        }
        throw new NoSuchElementException();
    }

    public Endpoint getMax() throws NoSuchElementException {
        int i = this.buckets.length - 1;
        while (i >= 0) {
            if (!this.buckets[i].isEmpty()) {
                return (Endpoint)this.buckets[i].first();
            }
            --i;
        }
        throw new NoSuchElementException();
    }

    public int size() {
        int ret = 0;
        int i = 0;
        while (i < this.buckets.length) {
            ret += this.buckets[i].getSize();
            ++i;
        }
        return ret;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        return new BucketQueueIterator(this.size());
    }

    public Iterator iterator(int n) {
        return new BucketQueueIterator(n);
    }

    public Object clone() {
        return new BucketQueue(this);
    }

    private class BucketQueueIterator
    extends UnmodifiableIterator {
        private Iterator currentIterator;
        private int currentBucket;
        private int left;

        public BucketQueueIterator(int n) {
            this.currentBucket = BucketQueue.this.buckets.length - 1;
            this.currentIterator = BucketQueue.this.buckets[this.currentBucket].iterator();
            this.left = n;
        }

        public synchronized boolean hasNext() {
            if (this.left <= 0) {
                return false;
            }
            if (this.currentIterator.hasNext()) {
                return true;
            }
            if (this.currentBucket < 0) {
                return false;
            }
            --this.currentBucket;
            while (this.currentBucket >= 0) {
                this.currentIterator = BucketQueue.this.buckets[this.currentBucket].iterator();
                if (this.currentIterator.hasNext()) {
                    return true;
                }
                --this.currentBucket;
            }
            return false;
        }

        public synchronized Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.left;
            return this.currentIterator.next();
        }
    }
}

