/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class CommonUtils {
    private static final String LIMEWIRE_VERSION = "1.7c";
    private static Properties _props;
    private static boolean _isWindows;
    private static boolean _supportsTray;
    private static boolean _isMacClassic;
    private static boolean _isMacOSX;
    private static boolean _isLinux;
    private static boolean _isSolaris;

    private CommonUtils() {
    }

    public static String getLimeWireVersion() {
        return LIMEWIRE_VERSION;
    }

    public static String getVendor() {
        return "LimeWire 1.7c";
    }

    public static String getJavaVersion() {
        return _props.getProperty("java.version");
    }

    public static String getOS() {
        return _props.getProperty("os.name");
    }

    public static String getCurrentDirectory() {
        return _props.getProperty("user.dir");
    }

    public static boolean isWindows() {
        return _isWindows;
    }

    public static boolean supportsTray() {
        return _supportsTray;
    }

    public static boolean isMacClassic() {
        return _isMacClassic;
    }

    public static boolean isMacOSX() {
        return _isMacOSX;
    }

    public static boolean isSolaris() {
        return _isSolaris;
    }

    public static boolean isLinux() {
        return _isLinux;
    }

    public static boolean isUnix() {
        return _isLinux || _isSolaris;
    }

    /*
     * Loose catch block
     */
    public static boolean copy(File src, File dst) {
        boolean ok;
        block24: {
            IOException e222;
            OutputStream out;
            BufferedInputStream in;
            block21: {
                int read;
                ok = true;
                in = null;
                out = null;
                in = new BufferedInputStream(new FileInputStream(src));
                out = new BufferedOutputStream(new FileOutputStream(dst));
                byte[] buf = new byte[1024];
                while ((read = ((InputStream)in).read(buf)) != -1) {
                    out.write(buf, 0, read);
                }
                Object var8_8 = null;
                if (in == null) break block21;
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e222) {
                    ok = false;
                }
            }
            if (out != null) {
                try {
                    out.flush();
                }
                catch (IOException e222) {
                    ok = false;
                }
                try {
                    out.close();
                }
                catch (IOException e222) {
                    ok = false;
                }
            }
            break block24;
            {
                catch (IOException e3) {
                    IOException e222;
                    ok = false;
                    Object var8_9 = null;
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException e222) {
                            ok = false;
                        }
                    }
                    if (out == null) break block24;
                    try {
                        out.flush();
                    }
                    catch (IOException e222) {
                        ok = false;
                    }
                    try {
                        out.close();
                    }
                    catch (IOException e222) {
                        ok = false;
                    }
                }
            }
            catch (Throwable throwable) {
                IOException e222;
                Object var8_10 = null;
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e222) {
                        ok = false;
                    }
                }
                if (out != null) {
                    try {
                        out.flush();
                    }
                    catch (IOException e222) {
                        ok = false;
                    }
                    try {
                        out.close();
                    }
                    catch (IOException e222) {
                        ok = false;
                    }
                }
                throw throwable;
            }
        }
        return ok;
    }

    static {
        _isWindows = false;
        _supportsTray = false;
        _isMacClassic = false;
        _isMacOSX = false;
        _isLinux = false;
        _isSolaris = false;
        _props = System.getProperties();
        String os = System.getProperty("os.name");
        boolean bl = _isWindows = os.indexOf("Windows") != -1;
        if (_isWindows) {
            _supportsTray = true;
        }
        _isSolaris = os.indexOf("Solaris") != -1;
        boolean bl2 = _isLinux = os.indexOf("Linux") != -1;
        if (os.startsWith("Mac OS")) {
            if (os.endsWith("X")) {
                _isMacOSX = true;
            } else {
                _isMacClassic = true;
            }
        }
    }
}

