/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.NoSuchElementException;

public class IntSet {
    public ArrayList list;
    private int size = 0;

    protected void repOk() {
        if (this.list.size() < 2) {
            return;
        }
        int countedSize = 0;
        int i = 0;
        while (i < this.list.size() - 1) {
            Interval lower = this.get(i);
            countedSize += lower.high - lower.low + 1;
            Interval higher = this.get(i + 1);
            Assert.that(lower.low <= lower.high, "Backwards interval: " + this.toString());
            Assert.that(lower.high < higher.low - 1, "Touching intervals: " + this.toString());
            ++i;
        }
        Interval last = this.get(this.list.size() - 1);
        Assert.that(last.low <= last.high, "Backwards interval: " + this.toString());
        Assert.that((countedSize += last.high - last.low + 1) == this.size, "Bad size.  Should be " + countedSize + " not " + this.size);
    }

    private final Interval get(int i) {
        return (Interval)this.list.get(i);
    }

    private final int search(int x) {
        int low = 0;
        int high = this.list.size() - 1;
        while (low <= high) {
            int i = (low + high) / 2;
            int li = this.get((int)i).low;
            if (li < x) {
                low = i + 1;
                continue;
            }
            if (x < li) {
                high = i - 1;
                continue;
            }
            return i;
        }
        return high;
    }

    public IntSet() {
        this.list = new ArrayList();
    }

    public IntSet(int expectedSize) {
        this.list = new ArrayList(expectedSize);
    }

    public int size() {
        return this.size;
    }

    public boolean contains(int x) {
        int i = this.search(x);
        if (i == -1) {
            return false;
        }
        Interval li = this.get(i);
        Assert.that(li.low <= x, "Bad return value from search.");
        return x <= li.high;
    }

    public boolean add(int x) {
        boolean touchesHigher;
        int i = this.search(x);
        ++this.size;
        if (i == -1) {
            if (this.list.size() == 0 || x < this.get((int)0).low - 1) {
                this.list.add(0, (Object)new Interval(x));
                return true;
            }
            this.get((int)0).low = x;
            return true;
        }
        Interval lower = this.get(i);
        Assert.that(lower.low <= x);
        if (x <= lower.high) {
            --this.size;
            return false;
        }
        if (i == this.list.size() - 1) {
            if (lower.high < x - 1) {
                this.list.add((Object)new Interval(x));
                return true;
            }
            lower.high = x;
            return true;
        }
        Interval higher = this.get(i + 1);
        boolean touchesLower = lower.high == x - 1;
        boolean bl = touchesHigher = x == higher.low - 1;
        if (touchesLower) {
            if (touchesHigher) {
                lower.high = higher.high;
                this.list.remove(i + 1);
                return true;
            }
            lower.high = x;
            return true;
        }
        if (touchesHigher) {
            higher.low = x;
            return true;
        }
        this.list.add(i + 1, (Object)new Interval(x));
        return true;
    }

    public boolean remove(int x) {
        boolean touchesHigh;
        int i = this.search(x);
        if (i == -1 || x > this.get((int)i).high) {
            return false;
        }
        Interval interval = this.get(i);
        boolean touchesLow = interval.low == x;
        boolean bl = touchesHigh = interval.high == x;
        if (touchesLow) {
            if (touchesHigh) {
                this.list.remove(i);
            } else {
                ++interval.low;
            }
        } else if (touchesHigh) {
            --interval.high;
        } else {
            Interval newInterval = new Interval(x + 1, interval.high);
            interval.high = x - 1;
            this.list.add(i + 1, (Object)newInterval);
        }
        --this.size;
        return true;
    }

    public boolean addAll(IntSet s) {
        boolean ret = false;
        IntSetIterator iter = s.iterator();
        while (iter.hasNext()) {
            ret |= this.add(iter.next());
        }
        return ret;
    }

    public boolean retainAll(IntSet s) {
        ArrayList removeList = new ArrayList();
        IntSetIterator iter = this.iterator();
        while (iter.hasNext()) {
            int x = iter.next();
            if (s.contains(x)) continue;
            removeList.add((Object)new Integer(x));
        }
        int i = removeList.size() - 1;
        while (i >= 0) {
            int x = (Integer)removeList.get(i);
            this.remove(x);
            --i;
        }
        return removeList.size() > 0;
    }

    public void trim() {
        this.list.trimToSize();
    }

    public IntSetIterator iterator() {
        return new IntSetIterator();
    }

    public String toString() {
        return this.list.toString();
    }

    public class IntSetIterator {
        private int i = 0;
        private int next;

        private IntSetIterator() {
            if (this.i < IntSet.this.list.size()) {
                this.next = ((IntSet)IntSet.this).get((int)this.i).low;
            }
        }

        public boolean hasNext() {
            return this.i < IntSet.this.list.size();
        }

        public int next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int ret = this.next++;
            if (this.next > ((IntSet)IntSet.this).get((int)this.i).high) {
                ++this.i;
                if (this.i < IntSet.this.list.size()) {
                    this.next = ((IntSet)IntSet.this).get((int)this.i).low;
                }
            }
            return ret;
        }
    }

    private static class Interval {
        int low;
        int high;

        Interval(int low, int high) {
            this.low = low;
            this.high = high;
        }

        Interval(int singleton) {
            this.low = singleton;
            this.high = singleton;
        }

        public String toString() {
            if (this.low == this.high) {
                return String.valueOf(this.low);
            }
            return String.valueOf(this.low) + "-" + String.valueOf(this.high);
        }
    }
}

