/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.WindowsLauncher;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Launcher {
    private static boolean _macClassesLoadedSuccessfully = true;
    private static Method _getFileCreator;
    private static Method _openURL;
    private static Method _findApplication;
    private static final String NETSCAPE_REMOTE_PARAMETER = "-remote";
    private static final String NETSCAPE_OPEN_PARAMETER_START = "openURL(";
    private static final String NETSCAPE_OPEN_PARAMETER_END = ")";
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$java$lang$String;

    private Launcher() {
    }

    public static int openURL(String url) throws IOException {
        if (CommonUtils.isWindows()) {
            return Launcher.launchFileWindows(url);
        }
        if (CommonUtils.isMacClassic()) {
            Launcher.openURLMacClassic(url);
        } else if (CommonUtils.isUnix()) {
            Launcher.launchFileUnix(url);
        }
        return -1;
    }

    private static void openURLMacClassic(String url) throws IOException {
        if (!_macClassesLoadedSuccessfully) {
            throw new IOException();
        }
        try {
            Object[] params = new Object[]{url};
            _openURL.invoke(null, params);
        }
        catch (NoSuchMethodError err) {
            throw new IOException();
        }
        catch (NoClassDefFoundError err) {
            throw new IOException();
        }
        catch (IllegalAccessException iae) {
            throw new IOException();
        }
        catch (InvocationTargetException ite) {
            throw new IOException();
        }
    }

    public static int launchFile(File file) throws IOException, SecurityException {
        String path = file.getCanonicalPath();
        String extCheckString = path.toLowerCase();
        if (!(extCheckString.endsWith(".exe") || extCheckString.endsWith(".vbs") || extCheckString.endsWith(".lnk") || extCheckString.endsWith(".bat") || extCheckString.endsWith(".sys") || extCheckString.endsWith(".com"))) {
            if (CommonUtils.isWindows()) {
                return Launcher.launchFileWindows(path);
            }
            if (CommonUtils.isMacClassic()) {
                Launcher.launchFileMacClassic(file);
            } else if (CommonUtils.isUnix()) {
                Launcher.launchFileUnix(path);
            }
        } else {
            throw new SecurityException();
        }
        return -1;
    }

    private static int launchFileWindows(String path) throws IOException {
        WindowsLauncher wl = new WindowsLauncher();
        return wl.launchFile(path);
    }

    private static void launchFileMacClassic(File file) throws IOException {
        if (!_macClassesLoadedSuccessfully) {
            throw new IOException();
        }
        File appFile = Launcher.getMacApplication(file);
        String appPath = appFile.getCanonicalPath();
        String filePath = file.getCanonicalPath();
        try {
            Runtime.getRuntime().exec(new String[]{appPath, filePath});
        }
        catch (SecurityException se) {
            // empty catch block
        }
    }

    private static File getMacApplication(File file) throws IOException {
        try {
            Object fileType = _getFileCreator.invoke(null, file);
            Object appPath = _findApplication.invoke(null, fileType);
            return (File)appPath;
        }
        catch (IllegalAccessException iae) {
            throw new IOException();
        }
        catch (InvocationTargetException ite) {
            throw new IOException();
        }
    }

    private static void loadMacClasses() throws IOException {
        try {
            Class<?> mrjFileUtilsClass = Class.forName("com.apple.mrj.MRJFileUtils");
            Class<?> mrjOSType = Class.forName("com.apple.mrj.MRJOSType");
            String fcName = "getFileCreator";
            Class[] fcParams = new Class[]{class$java$io$File == null ? (class$java$io$File = Launcher.class$("java.io.File")) : class$java$io$File};
            _getFileCreator = mrjFileUtilsClass.getDeclaredMethod(fcName, fcParams);
            String openURLName = "openURL";
            Class[] openURLParams = new Class[]{class$java$lang$String == null ? (class$java$lang$String = Launcher.class$("java.lang.String")) : class$java$lang$String};
            _openURL = mrjFileUtilsClass.getDeclaredMethod(openURLName, openURLParams);
            String faName = "findApplication";
            Class[] faParams = new Class[]{mrjOSType};
            _findApplication = mrjFileUtilsClass.getDeclaredMethod(faName, faParams);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IOException();
        }
        catch (NoSuchMethodException nsme) {
            throw new IOException();
        }
        catch (SecurityException se) {
            throw new IOException();
        }
    }

    private static void launchFileUnix(String path) throws IOException {
        String[] strs = new String[]{"netscape", NETSCAPE_REMOTE_PARAMETER, NETSCAPE_OPEN_PARAMETER_START, path, NETSCAPE_OPEN_PARAMETER_END};
        Process process = Runtime.getRuntime().exec(strs);
        try {
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                Runtime.getRuntime().exec(new String[]{"netscape", path});
            }
        }
        catch (InterruptedException ie) {
            throw new IOException("InterruptedException launching browser: " + ie.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (CommonUtils.isMacClassic()) {
            try {
                Launcher.loadMacClasses();
            }
            catch (IOException ioe) {
                _macClassesLoadedSuccessfully = false;
            }
        }
    }
}

