/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import java.io.PrintStream;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class LogGenerator {
    private PrintStream _out;
    private static final int BUFFER_INITIAL_CAPACITY = 10000;
    private StringBuffer _buffer = new StringBuffer(10000);
    private int _bufferingLimit;
    private int _count = 0;
    private static volatile Date _date = new Date();

    public LogGenerator(PrintStream out, int bufferingLimit) {
        this._out = out;
        this._bufferingLimit = bufferingLimit;
    }

    public void println(Object o) {
        this._buffer.append(o);
        this._buffer.append("\n");
        ++this._count;
        if (this._count >= this._bufferingLimit) {
            this.writeBufferOut();
            this._count = 0;
        }
    }

    public void printlnWithDateStamp(Object o) {
        this._buffer.append(_date);
        this._buffer.append(" ");
        this.println(o);
    }

    private void writeBufferOut() {
        this._out.print(this._buffer);
        this._out.flush();
        this._buffer = new StringBuffer(10000);
    }

    public void flush() {
        this.writeBufferOut();
    }

    static {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            public void run() {
                _date = new Date();
            }
        }, 0L, 120000L);
    }
}

