/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import java.io.IOException;
import java.net.Socket;

public class SocketOpener {
    private String host;
    private int port;
    private Socket socket = null;
    private boolean timedOut = false;

    public SocketOpener(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public synchronized Socket connect(int timeout) throws IOException {
        SocketOpenerThread t = new SocketOpenerThread();
        t.start();
        Assert.that(this.socket == null, "Socket already established w.o. lock.");
        try {
            this.wait(timeout);
        }
        catch (InterruptedException e) {
            if (this.socket == null) {
                this.timedOut = true;
            } else {
                try {
                    this.socket.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
            throw new IOException();
        }
        if (this.socket != null) {
            return this.socket;
        }
        this.timedOut = true;
        throw new IOException();
    }

    private class SocketOpenerThread
    extends Thread {
        private SocketOpenerThread() {
        }

        public void run() {
            Socket sock = null;
            try {
                sock = new Socket(SocketOpener.this.host, SocketOpener.this.port);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            SocketOpener socketOpener = SocketOpener.this;
            synchronized (socketOpener) {
                if (SocketOpener.this.timedOut && sock != null) {
                    try {
                        sock.close();
                    }
                    catch (IOException iOException) {}
                } else {
                    SocketOpener.this.socket = sock;
                    SocketOpener.this.notify();
                }
            }
        }
    }
}

