/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.util.Function;
import com.limegroup.gnutella.util.TrieEdge;
import com.limegroup.gnutella.util.TrieNode;
import com.limegroup.gnutella.util.UnmodifiableIterator;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.NoSuchElementException;

public class Trie {
    private TrieNode root;
    private boolean ignoreCase = false;

    public Trie(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        this.clear();
    }

    public void clear() {
        this.root = new TrieNode();
    }

    private final char canonicalCase(char c) {
        return this.ignoreCase ? Character.toLowerCase(c) : c;
    }

    private final String canonicalCase(String s) {
        if (this.ignoreCase) {
            return s.toLowerCase();
        }
        return s;
    }

    private final int match(String a, int startOffset, int stopOffset, String b) {
        int i = startOffset;
        int j = 0;
        while (j < b.length()) {
            if (i >= stopOffset) {
                return j;
            }
            if (this.canonicalCase(a.charAt(i)) != b.charAt(j)) {
                return j;
            }
            ++i;
            ++j;
        }
        return -1;
    }

    public Object add(String key, Object value) {
        TrieNode node = this.root;
        int i = 0;
        while (i < key.length()) {
            TrieEdge edge = node.get(this.canonicalCase(key.charAt(i)));
            if (edge == null) {
                TrieNode newNode = new TrieNode(value);
                node.put(this.canonicalCase(key.substring(i)), newNode);
                return null;
            }
            String label = edge.getLabel();
            int j = this.match(key, i, key.length(), label);
            Assert.that(j != 0, "Label didn't start with prefix[0].");
            if (j >= 0) {
                TrieNode child = edge.getChild();
                TrieNode intermediate = new TrieNode();
                String a = label.substring(0, j);
                String b = label.substring(j);
                String c = this.canonicalCase(key.substring(i + j));
                if (c.length() > 0) {
                    TrieNode newNode = new TrieNode(value);
                    node.remove(label.charAt(0));
                    node.put(a, intermediate);
                    intermediate.put(b, child);
                    intermediate.put(c, newNode);
                } else {
                    node.remove(label.charAt(0));
                    node.put(a, intermediate);
                    intermediate.put(b, child);
                    intermediate.setValue(value);
                }
                return null;
            }
            Assert.that(j == -1, "Bad return value from match: " + i);
            node = edge.getChild();
            i += label.length();
        }
        Object ret = node.getValue();
        node.setValue(value);
        return ret;
    }

    private TrieNode fetch(String prefix) {
        TrieNode node = this.root;
        int i = 0;
        while (i < prefix.length()) {
            TrieEdge edge = node.get(this.canonicalCase(prefix.charAt(i)));
            if (edge == null) {
                return null;
            }
            String label = edge.getLabel();
            int j = this.match(prefix, i, prefix.length(), label);
            Assert.that(j != 0, "Label didn't start with prefix[0].");
            if (j != -1) {
                return null;
            }
            i += label.length();
            node = edge.getChild();
        }
        return node;
    }

    public Object get(String key) {
        TrieNode node = this.fetch(key);
        if (node == null) {
            return null;
        }
        return node.getValue();
    }

    public boolean remove(String key) {
        TrieNode node = this.fetch(key);
        if (node == null) {
            return false;
        }
        boolean ret = node.getValue() != null;
        node.setValue(null);
        return ret;
    }

    public Iterator getPrefixedBy(String prefix) {
        return this.getPrefixedBy(prefix, 0, prefix.length());
    }

    public Iterator getPrefixedBy(String prefix, int startOffset, int stopOffset) {
        TrieNode node = this.root;
        int i = startOffset;
        while (i < stopOffset) {
            TrieEdge edge = node.get(this.canonicalCase(prefix.charAt(i)));
            if (edge == null) {
                return new EmptyIterator();
            }
            node = edge.getChild();
            String label = edge.getLabel();
            int j = this.match(prefix, i, stopOffset, label);
            Assert.that(j != 0, "Label didn't start with prefix[0].");
            if (i + j == stopOffset) break;
            if (j >= 0) {
                node = null;
                break;
            }
            Assert.that(j == -1, "Bad return value from match: " + i);
            i += label.length();
        }
        if (node == null) {
            return new EmptyIterator();
        }
        return new ValueIterator(node);
    }

    public void trim(Function valueCompactor) throws IllegalArgumentException, ClassCastException {
        LinkedList queue = new LinkedList();
        queue.add((Object)this.root);
        while (!queue.isEmpty()) {
            Object value;
            TrieNode node = (TrieNode)queue.removeLast();
            if (valueCompactor != null && (value = node.getValue()) != null) {
                node.setValue(valueCompactor.apply(value));
            }
            node.trim();
            Iterator iter = node.children();
            while (iter.hasNext()) {
                queue.addLast(iter.next());
            }
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<root>");
        this.toStringHelper(this.root, buf, 1);
        return buf.toString();
    }

    private void toStringHelper(TrieNode start, StringBuffer buf, int indent) {
        if (start.getValue() == null) {
            buf.append("\n");
        } else {
            buf.append(" -> " + start.getValue().toString() + "\n");
        }
        Iterator iter = start.labels();
        while (iter.hasNext()) {
            int i = 0;
            while (i < indent) {
                buf.append("  ");
                ++i;
            }
            String label = (String)iter.next();
            buf.append(label);
            TrieNode child = start.get(label.charAt(0)).getChild();
            this.toStringHelper(child, buf, indent + 1);
        }
    }

    private static class EmptyIterator
    extends UnmodifiableIterator {
        private EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }
    }

    private class ValueIterator
    extends UnmodifiableIterator {
        private LinkedList queue = new LinkedList();

        ValueIterator(TrieNode start) {
            this.queue.add((Object)start);
            this.advance();
        }

        private void advance() {
            while (this.queue.size() > 0) {
                TrieNode node = (TrieNode)this.queue.getLast();
                Object value = node.getValue();
                if (value != null) {
                    return;
                }
                this.queue.removeLast();
                Iterator iter = node.children();
                while (iter.hasNext()) {
                    this.queue.addLast(iter.next());
                }
            }
        }

        public boolean hasNext() {
            return this.queue.size() > 0;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            TrieNode node = (TrieNode)this.queue.removeLast();
            Iterator iter = node.children();
            while (iter.hasNext()) {
                this.queue.addLast(iter.next());
            }
            this.advance();
            return node.getValue();
        }
    }
}

