/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.util.TrieEdge;
import com.limegroup.gnutella.util.UnmodifiableIterator;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.NoSuchElementException;
import com.sun.java.util.collections.Vector;

final class TrieNode {
    private Object value = null;
    private Vector children = new Vector(0);

    public TrieNode() {
    }

    public TrieNode(Object value) {
        this.value = value;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    private final TrieEdge get(int i) {
        return (TrieEdge)this.children.get(i);
    }

    private final int search(char c, boolean exact) {
        int low = 0;
        int high = this.children.size() - 1;
        while (low <= high) {
            int i = (low + high) / 2;
            char ci = this.get(i).getLabelStart();
            if (ci < c) {
                low = i + 1;
                continue;
            }
            if (c < ci) {
                high = i - 1;
                continue;
            }
            return i;
        }
        if (exact) {
            return -1;
        }
        return high;
    }

    public TrieEdge get(char labelStart) {
        int i = this.search(labelStart, true);
        if (i < 0) {
            return null;
        }
        TrieEdge ret = this.get(i);
        Assert.that(ret.getLabelStart() == labelStart);
        return ret;
    }

    public void put(String label, TrieNode child) {
        char labelStart = label.charAt(0);
        int i = this.search(labelStart, false);
        if (i >= 0) {
            Assert.that(this.get(i).getLabelStart() != labelStart, "Precondition of TrieNode.put violated.");
        }
        this.children.add(i + 1, (Object)new TrieEdge(label, child));
    }

    public boolean remove(char labelStart) {
        int i = this.search(labelStart, true);
        if (i == -1) {
            return false;
        }
        Assert.that(this.get(i).getLabelStart() == labelStart);
        this.children.remove(i);
        return true;
    }

    public void trim() {
        this.children.trimToSize();
    }

    public Iterator children() {
        return new ChildrenIterator();
    }

    public Iterator labels() {
        return new LabelIterator();
    }

    public String toString() {
        Object val = this.getValue();
        if (val == null) {
            return "NULL";
        }
        return val.toString();
    }

    private class LabelIterator
    extends UnmodifiableIterator {
        int i = 0;

        private LabelIterator() {
        }

        public boolean hasNext() {
            return this.i < TrieNode.this.children.size();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            TrieEdge edge = TrieNode.this.get(this.i);
            ++this.i;
            return edge.getLabel();
        }
    }

    private class ChildrenIterator
    extends UnmodifiableIterator {
        int i = 0;

        private ChildrenIterator() {
        }

        public boolean hasNext() {
            return this.i < TrieNode.this.children.size();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            TrieEdge edge = TrieNode.this.get(this.i);
            ++this.i;
            return edge.getChild();
        }
    }
}

