/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LimeXMLDocument {
    protected Map fieldToValue;
    protected String schemaUri;

    public LimeXMLDocument(String XMLString) throws SAXException, IOException {
        DOMParser parser = new DOMParser();
        InputSource doc = new InputSource(new StringReader(XMLString));
        Document document = null;
        parser.parse(doc);
        document = parser.getDocument();
        this.makeSchemaURI(document);
        this.createMap(document);
    }

    public LimeXMLDocument(File f) throws FileNotFoundException, SAXException, IOException {
        DOMParser parser = new DOMParser();
        InputSource doc = null;
        doc = new InputSource(new FileInputStream(f));
        Document document = null;
        parser.parse(doc);
        document = parser.getDocument();
        this.createMap(document);
    }

    private void makeSchemaURI(Document doc) {
        Element docElement = doc.getDocumentElement();
        List attributes = LimeXMLUtils.getAttributes(docElement.getAttributes());
        int size = attributes.size();
        int i = 0;
        while (i < size) {
            Node att = (Node)attributes.get(i);
            String attName = att.getNodeName();
            String lowerAttName = attName.toLowerCase();
            if (lowerAttName.indexOf("schemalocation") >= 0) {
                this.schemaUri = att.getNodeValue();
                break;
            }
            ++i;
        }
    }

    private void createMap(Document doc) {
        this.fieldToValue = new HashMap();
        Element docElement = doc.getDocumentElement();
        this.doAllChildren(docElement, "");
    }

    private void doAllChildren(Node currNode, String parentName) {
        if (!currNode.hasChildNodes()) {
            this.doEntry(currNode, parentName);
            return;
        }
        String currString = this.doEntry(currNode, parentName);
        List children = LimeXMLUtils.getElements(currNode.getChildNodes());
        int size = children.size();
        int i = 0;
        while (i < size) {
            Node child = (Node)children.get(i);
            this.doAllChildren(child, currString);
            ++i;
        }
    }

    private String doEntry(Node currNode, String parentName) {
        String currTag = !parentName.equals("") ? parentName + "__" + currNode.getNodeName() : currNode.getNodeName();
        if (currNode.getNodeType() == 4) {
            System.out.println("this node has type  " + currNode.getNodeType());
        }
        Element currElement = (Element)currNode;
        String nodeValue = LimeXMLUtils.getText(currElement.getChildNodes());
        if ((nodeValue = nodeValue.trim()) != null && !nodeValue.equals("")) {
            this.fieldToValue.put(currTag, nodeValue);
        }
        List attributes = LimeXMLUtils.getAttributes(currNode.getAttributes());
        int size = attributes.size();
        int i = 0;
        while (i < size) {
            Node att = (Node)attributes.get(i);
            String attName = att.getNodeName();
            String attString = currTag + "__" + attName + "__";
            String attValue = att.getNodeValue();
            this.fieldToValue.put(attString, attValue);
            ++i;
        }
        return currTag;
    }

    public String getSchemaURI() {
        return this.schemaUri;
    }

    public List getNameValueList() {
        int size = this.fieldToValue.size();
        Iterator keys = this.fieldToValue.keySet().iterator();
        ArrayList<NameValue> retList = new ArrayList<NameValue>();
        int i = 0;
        while (i < size) {
            String name = (String)keys.next();
            String value = (String)this.fieldToValue.get(name);
            NameValue namVal = new NameValue(name, value);
            retList.add(namVal);
            ++i;
        }
        return retList;
    }

    public String getValue(String fieldName) {
        String value = (String)this.fieldToValue.get(fieldName);
        return value;
    }
}

