/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.util.Properties;

public class LimeXMLProperties {
    private Properties _properties = new Properties();
    private static LimeXMLProperties _instance = null;
    private static final String XML_PROPS_FILENAME = "xml.props";
    private static final String XML_SCHEMA_DIR = "XML_SCHEMA_DIR";
    private static final String XML_SCHEMA_DIR_DEF = "etc" + File.separator + "schemas" + File.separator;
    private static final String SCHEMA_TRANSFORMATION_DATA_MAP_FILE = "SCHEMA_TRANSFORMATION_DATA_MAP_FILE";
    private static final String SCHEMA_TRANSFORMATION_DATA_MAP_FILE_DEF = "etc" + File.separator + "STDataMap.dat";
    private static final String HTTP_MAPPING_FILE = "HTTP_MAPPING_FILE";
    private static final String HTTP_MAPPING_FILE_DEF = "etc" + File.separator + "httpmapping.xml";

    private LimeXMLProperties() {
        this.loadProperties();
    }

    protected void loadProperties() {
        try {
            this._properties.load(new FileInputStream(LimeXMLProperties.getPath() + XML_PROPS_FILENAME));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static LimeXMLProperties instance() {
        if (_instance == null) {
            _instance = new LimeXMLProperties();
        }
        return _instance;
    }

    public String getXMLSchemaDir() {
        String xmlSchemaDirRel = this._properties.getProperty(XML_SCHEMA_DIR, XML_SCHEMA_DIR_DEF);
        return LimeXMLProperties.getPath() + xmlSchemaDirRel;
    }

    public String getSchemaTransformationDataMapFile() {
        String schemaTransformationDataMapFile = this._properties.getProperty(SCHEMA_TRANSFORMATION_DATA_MAP_FILE, SCHEMA_TRANSFORMATION_DATA_MAP_FILE_DEF);
        return LimeXMLProperties.getPath() + schemaTransformationDataMapFile;
    }

    public String getHTTPMappingFile() {
        String httpMappingFile = this._properties.getProperty(HTTP_MAPPING_FILE, HTTP_MAPPING_FILE_DEF);
        return LimeXMLProperties.getPath() + httpMappingFile;
    }

    public File[] getAllXMLSchemaFiles() {
        return new File(this.getXMLSchemaDir()).listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".xsd");
            }
        });
    }

    private static String getPath() {
        return "E:\\work\\";
    }
}

