/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import java.util.ArrayList;
import java.util.List;

class LimeXMLReplyCollection {
    private String schemaURI;
    private ArrayList replyDocs;

    public LimeXMLReplyCollection(String URI2) {
        this.schemaURI = URI2;
        this.replyDocs = new ArrayList();
    }

    public String getSchemaURI() {
        return this.schemaURI;
    }

    public List getCollectionList() {
        return this.replyDocs;
    }

    public List getMatchingReplies(LimeXMLDocument queryDoc) {
        int size = this.replyDocs.size();
        ArrayList<LimeXMLDocument> matchingReplyDocs = new ArrayList<LimeXMLDocument>();
        int i = 0;
        while (i < size) {
            LimeXMLDocument currReplyDoc = (LimeXMLDocument)this.replyDocs.get(i);
            boolean match = this.match(currReplyDoc, queryDoc);
            if (match) {
                matchingReplyDocs.add(currReplyDoc);
                match = false;
            }
            ++i;
        }
        return matchingReplyDocs;
    }

    public void addReply(LimeXMLDocument replyDoc) {
        this.replyDocs.add(replyDoc);
    }

    public void appendCollectionList(List newReplyCollection) {
        this.replyDocs.addAll(newReplyCollection);
    }

    private boolean match(LimeXMLDocument replyDoc, LimeXMLDocument queryDoc) {
        if (replyDoc == null) {
            return false;
        }
        List queryNameValues = queryDoc.getNameValueList();
        int size = queryNameValues.size();
        ArrayList<String> fieldNames = new ArrayList<String>(size);
        int i = 0;
        while (i < size) {
            NameValue nameValue = (NameValue)queryNameValues.get(i);
            String fieldName = nameValue.getName();
            fieldNames.add(fieldName);
            ++i;
        }
        List currDocNameValues = replyDoc.getNameValueList();
        int matchCount = 0;
        int nullCount = 0;
        int j = 0;
        while (j < size) {
            String currFieldName = (String)fieldNames.get(j);
            String queryValue = queryDoc.getValue(currFieldName);
            String replyDocValue = replyDoc.getValue(currFieldName);
            if (replyDocValue == null) {
                ++nullCount;
            }
            if (replyDocValue.equals(queryValue)) {
                ++matchCount;
            }
            ++j;
        }
        return (nullCount + matchCount) / size >= 1;
    }
}

