/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.xml.LimeXMLProperties;
import com.limegroup.gnutella.xml.LimeXMLSchemaFieldExtractor;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class LimeXMLSchema {
    private List _canonicalizedFields = new LinkedList();
    private String _schemaURI = null;

    public LimeXMLSchema(File schemaFile) throws IOException {
        this(LimeXMLUtils.getInputSource(schemaFile));
    }

    public LimeXMLSchema(InputSource inputSource) throws IOException {
        this.initializeSchema(inputSource);
    }

    private void initializeSchema(InputSource schemaInputSource) throws IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IOException("" + e);
        }
        documentBuilder.setEntityResolver(new Resolver(schemaInputSource));
        Document document = null;
        try {
            document = documentBuilder.parse(schemaInputSource);
        }
        catch (Exception e) {
            throw new IOException("" + e);
        }
        this._canonicalizedFields = LimeXMLSchemaFieldExtractor.getFields(document);
        this._schemaURI = LimeXMLSchema.retrieveSchemaURI(document);
    }

    private static String retrieveSchemaURI(Document document) {
        Element root = document.getDocumentElement();
        NamedNodeMap nnm = root.getAttributes();
        Node targetNameSpaceAttribute = nnm.getNamedItem("targetNamespace");
        if (targetNameSpaceAttribute != null) {
            return targetNameSpaceAttribute.getNodeValue();
        }
        return "";
    }

    private void printNode(Node n) {
        if (n.getNodeType() == 1) {
            System.out.print("node = " + n.getNodeName() + " ");
            NamedNodeMap nnm = n.getAttributes();
            Node name = nnm.getNamedItem("name");
            if (name != null) {
                System.out.print(name + "");
            }
            System.out.println("");
            NodeList children = n.getChildNodes();
            int numChildren = children.getLength();
            int i = 0;
            while (i < numChildren) {
                Node child = children.item(i);
                this.printNode(child);
                ++i;
            }
        }
    }

    public String getSchemaURI() {
        return this._schemaURI;
    }

    public String[] getCanonicalizedFieldNames() {
        return this._canonicalizedFields.toArray(new String[0]);
    }

    public static void Test() {
        try {
            LimeXMLSchema schema = new LimeXMLSchema(new File(LimeXMLProperties.instance().getXMLSchemaDir() + File.separator + "gen_books.xsd"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        LimeXMLSchema.Test();
    }

    private static final class Resolver
    implements EntityResolver {
        private InputSource schema;

        public Resolver(InputSource s) {
            this.schema = s;
        }

        public InputSource resolveEntity(String publicId, String systemId) {
            String schemaId;
            String Id = systemId + publicId;
            if (Id.equals(schemaId = this.schema.getSystemId() + this.schema.getPublicId())) {
                return this.schema;
            }
            return null;
        }
    }
}

