/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class LimeXMLSchemaFieldExtractor {
    private static Map _nameFieldTypeSetMap = null;
    private static final String DUMMY = "DUMMY";
    private static final Set PRIMITIVE_TYPES;
    private static int _uniqueCount;
    private static String _lastUniqueComplexTypeName;
    private static Set _referencedNames;

    LimeXMLSchemaFieldExtractor() {
    }

    public static synchronized List getFields(Document document) {
        try {
            LimeXMLSchemaFieldExtractor.reInitializeMemberFields();
            Element root = document.getDocumentElement();
            LimeXMLSchemaFieldExtractor.traverse(root);
            String rootElementName = LimeXMLSchemaFieldExtractor.getRootElementName();
            LinkedList fieldNames = new LinkedList();
            LimeXMLSchemaFieldExtractor.fillWithFieldNames(fieldNames, (FieldTypeSet)_nameFieldTypeSetMap.get(rootElementName), rootElementName);
            System.out.println("fields: " + fieldNames);
            return fieldNames;
        }
        catch (NullPointerException npe) {
            return new LinkedList();
        }
    }

    private static void reInitializeMemberFields() {
        _nameFieldTypeSetMap = new HashMap();
        _uniqueCount = 1;
        _lastUniqueComplexTypeName = "";
        _referencedNames = new HashSet();
    }

    private static void fillWithFieldNames(List fieldNames, FieldTypeSet fieldTypeSet, String prefix) {
        Iterator iterator = fieldTypeSet.iterator();
        while (iterator.hasNext()) {
            FieldTypePair fieldTypePair = (FieldTypePair)iterator.next();
            FieldTypeSet newFieldTypeSet = (FieldTypeSet)_nameFieldTypeSetMap.get(fieldTypePair.getType());
            String field = fieldTypePair.getField();
            if (newFieldTypeSet == null) {
                if (!LimeXMLSchemaFieldExtractor.isDummy(field)) {
                    fieldNames.add(prefix + "__" + field);
                    continue;
                }
                fieldNames.add(prefix);
                continue;
            }
            if (!LimeXMLSchemaFieldExtractor.isDummy(field)) {
                LimeXMLSchemaFieldExtractor.fillWithFieldNames(fieldNames, newFieldTypeSet, prefix + "__" + field);
                continue;
            }
            LimeXMLSchemaFieldExtractor.fillWithFieldNames(fieldNames, newFieldTypeSet, prefix);
        }
    }

    private static boolean isDummy(String field) {
        return field.trim().equals(DUMMY);
    }

    private static String getRootElementName() {
        Set possibleRoots = ((HashMap)((HashMap)_nameFieldTypeSetMap).clone()).keySet();
        Iterator iterator = _referencedNames.iterator();
        while (iterator.hasNext()) {
            possibleRoots.remove(iterator.next());
        }
        Iterator possibleRootsIterator = possibleRoots.iterator();
        return (String)possibleRootsIterator.next();
    }

    private static void traverse(Node n) {
        String name = n.getNodeName();
        if (LimeXMLSchemaFieldExtractor.isElementTag(name)) {
            LimeXMLSchemaFieldExtractor.processElementTag(n);
            NodeList children = n.getChildNodes();
            int numChildren = children.getLength();
            int i = 0;
            while (i < numChildren) {
                Node child = children.item(i);
                LimeXMLSchemaFieldExtractor.traverse(child);
                ++i;
            }
        } else if (LimeXMLSchemaFieldExtractor.isComplexTypeTag(name)) {
            LimeXMLSchemaFieldExtractor.processComplexTypeTag(n);
        } else {
            NodeList children = n.getChildNodes();
            int numChildren = children.getLength();
            int i = 0;
            while (i < numChildren) {
                Node child = children.item(i);
                LimeXMLSchemaFieldExtractor.traverse(child);
                ++i;
            }
        }
    }

    private static void processComplexTypeTag(Node n) {
        String name = _lastUniqueComplexTypeName;
        NamedNodeMap attributes = n.getAttributes();
        Node nameAttribute = attributes.getNamedItem("name");
        if (nameAttribute != null) {
            name = nameAttribute.getNodeValue();
        }
        FieldTypeSet fieldTypeSet = new FieldTypeSet();
        NodeList children = n.getChildNodes();
        int numChildren = children.getLength();
        int i = 0;
        while (i < numChildren) {
            Node child = children.item(i);
            LimeXMLSchemaFieldExtractor.processChildOfComplexType(child, fieldTypeSet);
            ++i;
        }
        _nameFieldTypeSetMap.put(name, fieldTypeSet);
        _referencedNames.add(name);
    }

    private static void processChildOfComplexType(Node n, FieldTypeSet fieldTypeSet) {
        String nodeName = n.getNodeName();
        if (LimeXMLSchemaFieldExtractor.isElementTag(nodeName)) {
            LimeXMLSchemaFieldExtractor.processChildElementTag(n, fieldTypeSet);
        } else if (LimeXMLSchemaFieldExtractor.isAttributeTag(nodeName)) {
            LimeXMLSchemaFieldExtractor.processChildAttributeTag(n, fieldTypeSet);
        } else {
            NodeList children = n.getChildNodes();
            int numChildren = children.getLength();
            int i = 0;
            while (i < numChildren) {
                Node child = children.item(i);
                LimeXMLSchemaFieldExtractor.processChildOfComplexType(child, fieldTypeSet);
                ++i;
            }
        }
    }

    private static void processChildElementTag(Node n, FieldTypeSet fieldTypeSet) {
        NamedNodeMap attributes = n.getAttributes();
        Node nameAttribute = attributes.getNamedItem("name");
        if (nameAttribute == null) {
            Node refAttribute = attributes.getNamedItem("ref");
            if (refAttribute == null) {
                return;
            }
            String refName = refAttribute.getNodeValue();
            fieldTypeSet.add(new FieldTypePair(refName, refName));
            _referencedNames.add(refName);
        } else {
            String typeName;
            String name = nameAttribute.getNodeValue();
            Node typeAttribute = attributes.getNamedItem("type");
            if (typeAttribute != null) {
                typeName = typeAttribute.getNodeValue();
            } else {
                _lastUniqueComplexTypeName = typeName = LimeXMLSchemaFieldExtractor.getUniqueComplexTypeName();
                LimeXMLSchemaFieldExtractor.traverseChildren(n);
            }
            fieldTypeSet.add(new FieldTypePair(name, LimeXMLSchemaFieldExtractor.removeNameSpace(typeName)));
        }
    }

    private static String removeNameSpace(String typeName) {
        if (typeName.indexOf(58) == -1) {
            return typeName;
        }
        return typeName.substring(typeName.indexOf(58) + 1);
    }

    private static void processChildAttributeTag(Node n, FieldTypeSet fieldTypeSet) {
        NamedNodeMap attributes = n.getAttributes();
        Node nameAttribute = attributes.getNamedItem("name");
        Node typeAttribute = attributes.getNamedItem("type");
        if (nameAttribute == null || typeAttribute == null) {
            return;
        }
        String name = nameAttribute.getNodeValue() + "__";
        String typeName = typeAttribute.getNodeValue();
        fieldTypeSet.add(new FieldTypePair(name, LimeXMLSchemaFieldExtractor.removeNameSpace(typeName)));
    }

    private static void traverseChildren(Node n) {
        NodeList children = n.getChildNodes();
        int numChildren = children.getLength();
        int i = 0;
        while (i < numChildren) {
            Node child = children.item(i);
            LimeXMLSchemaFieldExtractor.traverse(child);
            ++i;
        }
    }

    private static boolean isComplexTypeTag(String tag) {
        return tag.trim().equals("complexType") || tag.trim().equals("xsd:complexType");
    }

    private static boolean isAttributeTag(String tag) {
        return tag.trim().equals("attribute") || tag.trim().equals("xsd:attribute");
    }

    private static void processElementTag(Node n) {
        String typeName;
        NamedNodeMap attributes = n.getAttributes();
        Node nameAttribute = attributes.getNamedItem("name");
        if (nameAttribute == null) {
            // empty if block
        }
        String name = nameAttribute.getNodeValue();
        Node typeAttribute = attributes.getNamedItem("type");
        if (typeAttribute != null) {
            typeName = typeAttribute.getNodeValue();
        } else {
            _lastUniqueComplexTypeName = typeName = LimeXMLSchemaFieldExtractor.getUniqueComplexTypeName();
        }
        LimeXMLSchemaFieldExtractor.addToFieldTypeSetMap(name, typeName);
    }

    private static String getUniqueComplexTypeName() {
        return "COMPLEXTYPE___" + _uniqueCount++;
    }

    private static void addToFieldTypeSetMap(String name, String typeName) {
        FieldTypeSet fieldTypeSet = new FieldTypeSet();
        fieldTypeSet.add(new FieldTypePair(DUMMY, LimeXMLSchemaFieldExtractor.removeNameSpace(typeName)));
        _nameFieldTypeSetMap.put(name, fieldTypeSet);
        _referencedNames.add(LimeXMLSchemaFieldExtractor.removeNameSpace(typeName));
    }

    private static boolean isElementTag(String tag) {
        return tag.trim().equals("element") || tag.trim().equals("xsd:element");
    }

    static {
        _uniqueCount = 1;
        _lastUniqueComplexTypeName = "";
        _referencedNames = null;
        PRIMITIVE_TYPES = new HashSet();
        PRIMITIVE_TYPES.add("xsi:string");
        PRIMITIVE_TYPES.add("string");
        PRIMITIVE_TYPES.add("xsi:boolean");
        PRIMITIVE_TYPES.add("boolean");
        PRIMITIVE_TYPES.add("xsi:float");
        PRIMITIVE_TYPES.add("float");
        PRIMITIVE_TYPES.add("xsi:double");
        PRIMITIVE_TYPES.add("double");
        PRIMITIVE_TYPES.add("xsi:decimal");
        PRIMITIVE_TYPES.add("decimal");
        PRIMITIVE_TYPES.add("xsi:timeDuration");
        PRIMITIVE_TYPES.add("timeDuration");
        PRIMITIVE_TYPES.add("xsi:recurringDuration");
        PRIMITIVE_TYPES.add("recurringDuration");
        PRIMITIVE_TYPES.add("xsi:binary");
        PRIMITIVE_TYPES.add("binary");
        PRIMITIVE_TYPES.add("xsi:uriReference");
        PRIMITIVE_TYPES.add("uriReference");
        PRIMITIVE_TYPES.add("xsi:ID");
        PRIMITIVE_TYPES.add("ID");
        PRIMITIVE_TYPES.add("xsi:IDREF");
        PRIMITIVE_TYPES.add("IDREF");
        PRIMITIVE_TYPES.add("xsi:ENTITY");
        PRIMITIVE_TYPES.add("ENTITY");
        PRIMITIVE_TYPES.add("xsi:NUMTOKEN");
        PRIMITIVE_TYPES.add("NUMTOKEN");
        PRIMITIVE_TYPES.add("xsi:Qname");
        PRIMITIVE_TYPES.add("Qname");
    }

    private static class FieldTypePair {
        private String _field;
        private String _type;

        public FieldTypePair(String field, String type) {
            this._field = field;
            this._type = type;
        }

        public String getField() {
            return this._field;
        }

        public String getType() {
            return this._type;
        }

        public String toString() {
            return "[" + this._field + ":" + this._type + "]";
        }
    }

    private static class FieldTypeSet {
        private Set _elements = new HashSet();

        private FieldTypeSet() {
        }

        public void add(FieldTypePair fieldTypePair) {
            this._elements.add(fieldTypePair);
        }

        public Iterator iterator() {
            return this._elements.iterator();
        }

        public String toString() {
            return this._elements.toString();
        }
    }
}

