/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.xml.LimeXMLProperties;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LimeXMLSchemaRepository {
    private Map _uriSchemaMap = new HashMap();
    private static LimeXMLSchemaRepository _instance = null;

    private LimeXMLSchemaRepository() {
        this.initialize();
    }

    protected void initialize() {
        File[] schemaFiles = LimeXMLProperties.instance().getAllXMLSchemaFiles();
        if (schemaFiles != null) {
            int i = 0;
            while (i < schemaFiles.length) {
                try {
                    LimeXMLSchema limeXmlSchema = new LimeXMLSchema(schemaFiles[i]);
                    this._uriSchemaMap.put(limeXmlSchema.getSchemaURI(), limeXmlSchema);
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                ++i;
            }
        }
    }

    public static LimeXMLSchemaRepository instance() {
        if (_instance == null) {
            _instance = new LimeXMLSchemaRepository();
        }
        return _instance;
    }

    public LimeXMLSchema getSchema(String uri) {
        Map map = this._uriSchemaMap;
        synchronized (map) {
            LimeXMLSchema limeXMLSchema = (LimeXMLSchema)this._uriSchemaMap.get(uri);
            return limeXMLSchema;
        }
    }

    public String[] getAvailableSchemaURIs() {
        Map map = this._uriSchemaMap;
        synchronized (map) {
            Set keySet = this._uriSchemaMap.keySet();
            String[] stringArray = keySet.toArray(new String[0]);
            return stringArray;
        }
    }

    public static void main(String[] args) {
        LimeXMLSchemaRepository.Test();
    }

    private static void Test() {
        String[] availableSchemas = LimeXMLSchemaRepository.instance().getAvailableSchemaURIs();
        int i = 0;
        while (i < availableSchemas.length) {
            System.out.println("schema = " + availableSchemas[i]);
            ++i;
        }
    }
}

