/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class LimeXMLUtils {
    public static InputSource getInputSource(File file) throws IOException {
        StringBuffer sb = new StringBuffer();
        String line = "";
        BufferedReader br = new BufferedReader(new FileReader(file));
        while (line != null) {
            line = br.readLine();
            if (line == null) continue;
            sb.append(line + "\n");
        }
        return new InputSource(new StringReader(sb.toString()));
    }

    public static List getElements(NodeList nodeList) {
        ArrayList<Node> elements = new ArrayList<Node>(nodeList.getLength());
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                elements.add(node);
            }
            ++i;
        }
        return elements;
    }

    public static List getAttributes(NamedNodeMap nodeMap) {
        ArrayList<Node> attributes = new ArrayList<Node>(nodeMap.getLength());
        int i = 0;
        while (i < nodeMap.getLength()) {
            Node node = nodeMap.item(i);
            attributes.add(node);
            ++i;
        }
        return attributes;
    }

    public static String getText(NodeList nodeList) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            switch (node.getNodeType()) {
                case 3: 
                case 4: {
                    buffer.append(node.getNodeValue());
                    break;
                }
                case 5: {
                    if (node.getNodeName().equals("amp")) {
                        buffer.append('&');
                        break;
                    }
                    if (node.getNodeName().equals("lt")) {
                        buffer.append('<');
                        break;
                    }
                    if (node.getNodeName().equals("gt")) {
                        buffer.append('>');
                        break;
                    }
                    if (node.getNodeName().equals("apos")) {
                        buffer.append('\'');
                        break;
                    }
                    if (!node.getNodeName().equals("quot")) break;
                    buffer.append('\"');
                    break;
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    public static void writeEscapedString(Writer writer, String string) throws IOException {
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (c == '<') {
                writer.write("&lt;");
            } else if (c == '>') {
                writer.write("&gt;");
            } else if (c == '&') {
                writer.write("&amp;");
            } else if (c == '\'') {
                writer.write("&apos;");
            } else if (c == '\"') {
                writer.write("&quot;");
            } else {
                writer.write(c);
            }
            ++i;
        }
    }
}

