/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.chat.ChatManager;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.http.HTTPRequestMethod;
import com.limegroup.gnutella.statistics.HTTPStat;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

public class Acceptor
extends Thread {
    private volatile ServerSocket _socket = null;
    private volatile int _port = -1;
    private Object _socketLock = new Object();
    private static byte[] _address = new byte[4];
    private IPFilter _filter = new IPFilter();
    private volatile boolean _acceptedIncoming = false;
    private static final boolean debug = false;
    static /* synthetic */ Class class$com$limegroup$gnutella$Acceptor;

    public static synchronized void setAddress(byte[] byArray) {
        if (byArray[0] == 127) {
            return;
        }
        _address = byArray;
    }

    public void initialize() {
        this.setDaemon(true);
        this.start();
    }

    public byte[] getAddress() {
        if (SettingsManager.instance().getForceIPAddress()) {
            return SettingsManager.instance().getForcedIPAddress();
        }
        Class clazz = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
        synchronized (clazz) {
            byte[] byArray = _address;
            return byArray;
        }
    }

    public int getPort() {
        if (SettingsManager.instance().getForceIPAddress()) {
            return SettingsManager.instance().getForcedPort();
        }
        return this._port;
    }

    public void setListeningPort(int n) throws IOException {
        Acceptor.debug("Acceptor.setListeningPort(): entered.");
        if (this._socket != null && this._port == n) {
            return;
        }
        if (n == 0) {
            Acceptor.debug("Acceptor.setListeningPort(): shutting off service.");
            if (this._socket != null) {
                try {
                    this._socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            Object object = this._socketLock;
            synchronized (object) {
                this._socket = null;
                this._port = 0;
                this._socketLock.notify();
            }
            UDPService.instance().setListeningSocket(null);
            Acceptor.debug("Acceptor.setListeningPort(): service OFF.");
            return;
        }
        Acceptor.debug("Acceptor.setListeningPort(): changing port to " + n);
        DatagramSocket datagramSocket = UDPService.instance().newListeningSocket(n);
        Acceptor.debug("Acceptor.setListeningPort(): UDP Service is ready.");
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(n);
        }
        catch (IOException iOException) {
            datagramSocket.close();
            throw iOException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            datagramSocket.close();
            throw new IOException();
        }
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Object object = this._socketLock;
        synchronized (object) {
            this._socket = serverSocket;
            this._port = n;
            this._socketLock.notify();
        }
        Acceptor.debug("Acceptor.setListeningPort(): I am ready.");
        UDPService.instance().setListeningSocket(datagramSocket);
        Acceptor.debug("Acceptor.setListeningPort(): listening UDP/TCP on " + this._port);
    }

    public boolean acceptedIncoming() {
        return this._acceptedIncoming;
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        block24: {
            var1_1 = SettingsManager.instance();
            var2_2 = var1_1.getPort();
            var3_3 = RouterService.getCallback();
            try {
                Acceptor.setAddress(InetAddress.getLocalHost().getAddress());
            }
            catch (UnknownHostException var4_4) {
            }
            catch (SecurityException var5_6) {
                // empty catch block
            }
            var4_5 = var2_2;
            try {
                this.setListeningPort(var2_2);
                this._port = var2_2;
                break block24;
            }
            catch (IOException var5_7) {
                var6_10 = 0;
                ** while (var6_10 < 10)
            }
lbl-1000:
            // 1 sources

            {
                var2_2 = var6_10 + 6346;
                try {
                    this.setListeningPort(var2_2);
                    this._port = var2_2;
                    break;
                }
                catch (IOException var7_13) {
                    ++var6_10;
                }
                continue;
            }
lbl27:
            // 2 sources

            if (this._socket == null) {
                var3_3.error(10);
            }
        }
        if (this._port != var4_5) {
            var1_1.setPort(this._port);
        }
        while (true) {
            try {
                while (true) {
                    var5_8 = null;
                    var6_11 = this._socketLock;
                    synchronized (var6_11) {
                        if (this._socket != null) {
                            try {
                                var5_8 = this._socket.accept();
                            }
                            catch (IOException var7_15) {
                                continue;
                            }
                        }
                        try {
                            this._socketLock.wait();
                        }
                        catch (InterruptedException var7_16) {
                            // empty catch block
                        }
                        continue;
                    }
                    var7_14 = var5_8.getInetAddress();
                    var8_17 = var7_14.getAddress();
                    if (this.isBannedIP(var7_14.getHostAddress()) || var1_1.getLocalIsPrivate() && var8_17[0] == 127) {
                        var5_8.close();
                        continue;
                    }
                    this._acceptedIncoming = true;
                    var1_1.setAcceptedIncoming(this._acceptedIncoming);
                    var9_19 = new ConnectionDispatchRunner(var5_8);
                    var10_20 = new Thread((Runnable)var9_19, "ConnectionDispatchRunner");
                    var10_20.setDaemon(true);
                    var10_20.start();
                }
            }
            catch (SecurityException var5_9) {
                var3_3.error(11);
                return;
            }
            catch (Throwable var6_12) {
                var3_3.error(12, var6_12);
                continue;
            }
            break;
        }
    }

    public void refreshBannedIPs() {
        this._filter = new IPFilter();
    }

    public boolean isBannedIP(String string) {
        return !this._filter.allow(string);
    }

    private static void debug(String string) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ConnectionDispatchRunner
    implements Runnable {
        private final Socket _socket;

        public ConnectionDispatchRunner(Socket socket) {
            this._socket = socket;
        }

        public void run() {
            block15: {
                ActivityCallback activityCallback = RouterService.getCallback();
                ConnectionManager connectionManager = RouterService.getConnectionManager();
                UploadManager uploadManager = RouterService.getUploadManager();
                DownloadManager downloadManager = RouterService.getDownloadManager();
                try {
                    InputStream inputStream = null;
                    try {
                        inputStream = this._socket.getInputStream();
                    }
                    catch (Exception exception) {
                        throw new IOException();
                    }
                    this._socket.setSoTimeout(SettingsManager.instance().getTimeout());
                    String string = IOUtils.readWord(inputStream, 8);
                    this._socket.setSoTimeout(0);
                    boolean bl = SettingsManager.instance().getConnectString().equals("GNUTELLA CONNECT/0.4");
                    if (string.equals(SettingsManager.instance().getConnectStringFirstWord())) {
                        connectionManager.acceptConnection(this._socket);
                        break block15;
                    }
                    if (bl && string.equals("LIMEWIRE")) {
                        connectionManager.acceptConnection(this._socket);
                        break block15;
                    }
                    if (string.equals("GET")) {
                        uploadManager.acceptUpload(HTTPRequestMethod.GET, this._socket);
                        if (!CommonUtils.isJava118()) {
                            HTTPStat.HTTP_GET_REQUESTS.incrementStat();
                        }
                        break block15;
                    }
                    if (string.equals("HEAD")) {
                        uploadManager.acceptUpload(HTTPRequestMethod.HEAD, this._socket);
                        if (!CommonUtils.isJava118()) {
                            HTTPStat.HTTP_HEAD_REQUESTS.incrementStat();
                        }
                        break block15;
                    }
                    if (string.equals("GIV")) {
                        downloadManager.acceptDownload(this._socket);
                        break block15;
                    }
                    if (string.equals("CHAT")) {
                        ChatManager.instance().accept(this._socket);
                        break block15;
                    }
                    throw new IOException();
                }
                catch (IOException iOException) {
                    try {
                        this._socket.close();
                    }
                    catch (IOException iOException2) {}
                }
                catch (Throwable throwable) {
                    activityCallback.error(12, throwable);
                }
            }
        }
    }
}

