/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.util.URLDecoder;
import com.sun.java.util.collections.Comparable;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.TimeZone;

public final class AlternateLocation
implements Comparable,
HTTPHeaderValue {
    private final URL URL;
    private final String OUTPUT_DATE_TIME;
    private final long TIME;
    private volatile int hashCode = 0;

    public static AlternateLocation createAlternateLocation(String string) throws IOException {
        Date date;
        if (string == null || string.equals("")) {
            throw new IOException("null or empty in alt loc: " + string);
        }
        URL uRL = AlternateLocation.createUrl(string);
        if (uRL == null) {
            throw new IOException("could not parse url for alt loc: " + string);
        }
        String string2 = AlternateLocation.extractTimestamp(string);
        if (string2 == null) {
            date = new Date(0L);
        } else {
            date = AlternateLocation.createDateInstance(string2);
            if (date.after(new Date())) {
                throw new IOException("reported date is in the future: " + string);
            }
        }
        return new AlternateLocation(uRL, date);
    }

    public static AlternateLocation createAlternateLocation(URL uRL) throws MalformedURLException {
        if (uRL == null) {
            throw new NullPointerException("cannot accept null URL");
        }
        URL uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), uRL.getFile());
        Date date = new Date();
        return new AlternateLocation(uRL2, date);
    }

    public static AlternateLocation createAlternateLocation(RemoteFileDesc remoteFileDesc) throws IOException {
        if (remoteFileDesc == null) {
            throw new NullPointerException("cannot accept null RFD");
        }
        URN uRN = remoteFileDesc.getSHA1Urn();
        if (uRN == null) {
            throw new IOException("no SHA1 in RFD");
        }
        String string = "http://" + remoteFileDesc.getHost() + ":" + remoteFileDesc.getPort() + "/get/" + String.valueOf(remoteFileDesc.getIndex()) + "/" + URLEncoder.encode(remoteFileDesc.getFileName());
        URL uRL = new URL(string);
        return new AlternateLocation(uRL, new Date());
    }

    private AlternateLocation(URL uRL, Date date) {
        this.URL = uRL;
        this.TIME = date.getTime();
        this.OUTPUT_DATE_TIME = this.TIME == 0L ? null : AlternateLocation.convertDateToString(date);
    }

    public URL getUrl() {
        try {
            return new URL(this.URL.getProtocol(), this.URL.getHost(), this.URL.getPort(), this.URL.getFile());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private static String convertDateToString(Date date) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTime(date);
        int[] nArray = new int[6];
        String[] stringArray = new String[6];
        nArray[0] = calendar.get(1);
        nArray[1] = calendar.get(2) + 1;
        nArray[2] = calendar.get(5);
        nArray[3] = calendar.get(10);
        nArray[4] = calendar.get(12);
        nArray[5] = calendar.get(13);
        int n = 0;
        while (n < nArray.length) {
            stringArray[n] = nArray[n] < 10 ? "0" + String.valueOf(nArray[n]) : String.valueOf(nArray[n]);
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringArray[0]);
        stringBuffer.append("-");
        stringBuffer.append(stringArray[1]);
        stringBuffer.append("-");
        stringBuffer.append(stringArray[2]);
        stringBuffer.append("T");
        stringBuffer.append(stringArray[3]);
        stringBuffer.append(":");
        stringBuffer.append(stringArray[4]);
        stringBuffer.append(":");
        stringBuffer.append(stringArray[5]);
        stringBuffer.append("Z");
        return stringBuffer.toString();
    }

    private static boolean isValidTimestamp(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "T");
        int n = stringTokenizer.countTokens();
        if (n == 1) {
            return AlternateLocation.isValidDate(string);
        }
        if (n == 2) {
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            return AlternateLocation.isValidDate(string2) && AlternateLocation.isValidTime(string3);
        }
        return false;
    }

    private static boolean isValidTime(String string) {
        if (!string.endsWith("Z")) {
            return false;
        }
        String string2 = string.substring(0, string.length() - 1);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
        int n = stringTokenizer.countTokens();
        if (n < 2 || n > 3) {
            return false;
        }
        try {
            String string3;
            int n2;
            int n3;
            int n4 = Integer.parseInt(stringTokenizer.nextToken());
            if (n4 < 0 || n4 > 23) {
                return false;
            }
            if (stringTokenizer.hasMoreTokens() && ((n3 = Integer.parseInt(stringTokenizer.nextToken())) < 0 || n3 > 59)) {
                return false;
            }
            if (stringTokenizer.hasMoreTokens() && ((n2 = Integer.parseInt(string3 = stringTokenizer.nextToken().substring(0, 2))) < 0 || n2 > 59)) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private static boolean isValidDate(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-");
        if (stringTokenizer.countTokens() != 3) {
            return false;
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        String string4 = stringTokenizer.nextToken();
        try {
            int n = Integer.parseInt(string2);
            int n2 = Integer.parseInt(string3);
            int n3 = Integer.parseInt(string4);
            if (n < 2001 || n > 4000) {
                return false;
            }
            if (n2 < 1 || n2 > 12) {
                return false;
            }
            if (n3 < 1 || n3 > 31) {
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private static Date createDateInstance(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "T");
        int n = stringTokenizer.countTokens();
        if (n < 1 || n > 2) {
            return new Date(0L);
        }
        String string2 = stringTokenizer.nextToken();
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "-");
        if (stringTokenizer2.countTokens() != 3) {
            return new Date(0L);
        }
        String string3 = stringTokenizer2.nextToken();
        String string4 = stringTokenizer2.nextToken();
        String string5 = stringTokenizer2.nextToken();
        int n2 = Integer.parseInt(string3);
        try {
            int n3 = Integer.parseInt(string4) - 1;
            int n4 = Integer.parseInt(string5);
            if (!stringTokenizer.hasMoreTokens()) {
                Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                calendar.set(n2, n3, n4);
                return calendar.getTime();
            }
            String string6 = stringTokenizer.nextToken();
            if (!string6.endsWith("Z")) {
                return new Date(0L);
            }
            StringTokenizer stringTokenizer3 = new StringTokenizer(string6 = string6.substring(0, string6.length() - 1), ":");
            int n5 = stringTokenizer3.countTokens();
            if (n5 < 2 || n5 > 3) {
                return new Date(0L);
            }
            String string7 = stringTokenizer3.nextToken();
            String string8 = stringTokenizer3.nextToken();
            int n6 = Integer.parseInt(string7);
            int n7 = Integer.parseInt(string8);
            Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            if (stringTokenizer3.hasMoreTokens()) {
                String string9 = stringTokenizer3.nextToken().substring(0, 2);
                int n8 = Integer.parseInt(string9);
                calendar.set(n2, n3, n4, n6, n7, n8);
            } else {
                calendar.set(n2, n3, n4, n6, n7);
            }
            return calendar.getTime();
        }
        catch (NumberFormatException numberFormatException) {
            return new Date(0L);
        }
    }

    private static URL createUrl(String string) throws IOException {
        String string2 = string.toLowerCase();
        if (string2.startsWith("http")) {
            InetAddress inetAddress;
            String string3 = AlternateLocation.removeTimestamp(string);
            URL uRL = new URL(string3);
            String string4 = uRL.getHost();
            if (string4 == null || string4.equals("")) {
                throw new IOException("invalid host in alternate location: host: " + string4 + "header: " + string);
            }
            if (Character.isDigit(string4.charAt(0)) && Endpoint.isPrivateAddress((inetAddress = InetAddress.getByName(string4)).getAddress())) {
                throw new IOException("cannot include private address in alt loc: " + string4);
            }
            if (uRL.getPort() == -1) {
                uRL = new URL("HTTP", uRL.getHost(), 80, uRL.getFile());
            }
            return uRL;
        }
        throw new IOException("invalid start for alternate location: " + string);
    }

    private static String extractTimestamp(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        String string2 = null;
        int n2 = 0;
        while (n2 < n) {
            string2 = stringTokenizer.nextToken();
            ++n2;
        }
        if (AlternateLocation.isValidTimestamp(string2)) {
            return string2;
        }
        return null;
    }

    private static String removeTimestamp(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n = stringTokenizer.countTokens();
        if (n == 1) {
            return string;
        }
        String string2 = null;
        int n2 = 0;
        while (n2 < n) {
            string2 = stringTokenizer.nextToken();
            ++n2;
        }
        int n3 = string.indexOf(string2);
        if (n3 == -1) {
            return null;
        }
        return string.substring(0, n3);
    }

    public boolean isTimestamped() {
        return this.OUTPUT_DATE_TIME != null;
    }

    public int compareTo(Object object) {
        if (this.equals(object)) {
            return 0;
        }
        if (object == this) {
            return 0;
        }
        if (!(object instanceof AlternateLocation)) {
            return -1;
        }
        AlternateLocation alternateLocation = (AlternateLocation)object;
        if (this.URL.equals(alternateLocation.URL)) {
            return this.TIME < alternateLocation.TIME ? 1 : (this.TIME == alternateLocation.TIME ? 0 : -1);
        }
        if (this.isTimestamped() && alternateLocation.isTimestamped()) {
            if (this.TIME == alternateLocation.TIME) {
                return this.URL.toString().compareTo(alternateLocation.URL.toString());
            }
            return this.TIME < alternateLocation.TIME ? 1 : -1;
        }
        if (this.isTimestamped()) {
            return -1;
        }
        if (alternateLocation.isTimestamped()) {
            return 1;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl;
        if (object == this) {
            return true;
        }
        if (!(object instanceof AlternateLocation)) {
            return false;
        }
        AlternateLocation alternateLocation = (AlternateLocation)object;
        if (this.OUTPUT_DATE_TIME == null) {
            if (alternateLocation.OUTPUT_DATE_TIME != null) return false;
            bl = true;
        } else {
            bl = this.OUTPUT_DATE_TIME.equals(alternateLocation.OUTPUT_DATE_TIME);
        }
        if (!bl) return false;
        if (this.URL == null) {
            if (alternateLocation.URL != null) return false;
            return true;
        }
        boolean bl2 = this.URL.equals(alternateLocation.URL);
        if (!bl2) return false;
        return true;
    }

    public boolean equalsURL(AlternateLocation alternateLocation) {
        return this.URL == null ? alternateLocation.URL == null : this.URL.equals(alternateLocation.URL);
    }

    public RemoteFileDesc createRemoteFileDesc(int n, Set set) {
        int n2;
        RemoteFileDesc remoteFileDesc = null;
        String string = this.URL.getFile();
        if ((string = URLDecoder.decode(string)) != null && string.startsWith("/get/") && (n2 = (string = string.substring(5)).indexOf("/")) >= 1) {
            String string2 = string.substring(0, n2);
            int n3 = 0;
            try {
                n3 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
            string = string.substring(n2 + 1);
            remoteFileDesc = new RemoteFileDesc(this.URL.getHost(), this.URL.getPort(), n3, string, n, GUID.makeGuid(), 1000, true, 3, false, null, set);
        }
        return remoteFileDesc;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int n = 17;
            n = 37 * n + (int)(this.TIME ^ this.TIME >>> 32);
            this.hashCode = n = 37 * n + this.URL.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        if (this.isTimestamped()) {
            return this.URL.toExternalForm() + " " + this.OUTPUT_DATE_TIME;
        }
        return this.URL.toExternalForm();
    }

    public String httpStringValue() {
        if (this.isTimestamped()) {
            return this.URL.toExternalForm() + " " + this.OUTPUT_DATE_TIME;
        }
        return this.URL.toExternalForm();
    }
}

