/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.AlternateLocation;
import com.limegroup.gnutella.AlternateLocationCollector;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.SortedMap;
import com.sun.java.util.collections.TreeMap;
import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;

public final class AlternateLocationCollection
implements HTTPHeaderValue,
AlternateLocationCollector {
    private SortedMap _alternateLocations;

    public static AlternateLocationCollection createCollectionFromHttpValue(String string) {
        if (string == null) {
            throw new NullPointerException("cannot create an AlternateLocationCollection from a null value");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        AlternateLocationCollection alternateLocationCollection = new AlternateLocationCollection();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            try {
                AlternateLocation alternateLocation = AlternateLocation.createAlternateLocation(string2);
                alternateLocationCollection.addAlternateLocation(alternateLocation);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return alternateLocationCollection;
    }

    public synchronized void addAlternateLocation(AlternateLocation alternateLocation) {
        this.createMap();
        URL uRL = alternateLocation.getUrl();
        Set set = this._alternateLocations.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            AlternateLocation alternateLocation2 = (AlternateLocation)iterator.next();
            URL uRL2 = alternateLocation2.getUrl();
            if (!uRL2.equals(uRL)) continue;
            int n = alternateLocation2.compareTo(alternateLocation);
            if (n > 0) {
                this._alternateLocations.remove(alternateLocation2);
                break;
            }
            return;
        }
        this._alternateLocations.put(alternateLocation, alternateLocation);
        if (this._alternateLocations.size() > 100) {
            this._alternateLocations.remove(this._alternateLocations.lastKey());
        }
    }

    public synchronized void addAlternateLocationCollection(AlternateLocationCollection alternateLocationCollection) {
        SortedMap sortedMap = alternateLocationCollection._alternateLocations;
        if (sortedMap == null) {
            return;
        }
        Collection collection = sortedMap.values();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            AlternateLocation alternateLocation = (AlternateLocation)iterator.next();
            this.addAlternateLocation(alternateLocation);
        }
    }

    public synchronized boolean hasAlternateLocations() {
        if (this._alternateLocations == null) {
            return false;
        }
        return !this._alternateLocations.isEmpty();
    }

    public synchronized AlternateLocationCollection diffAlternateLocationCollection(AlternateLocationCollection alternateLocationCollection) {
        AlternateLocationCollection alternateLocationCollection2 = new AlternateLocationCollection();
        Iterator iterator = alternateLocationCollection.values().iterator();
        while (iterator.hasNext()) {
            AlternateLocation alternateLocation = (AlternateLocation)iterator.next();
            Iterator iterator2 = this.values().iterator();
            boolean bl = false;
            while (iterator2.hasNext()) {
                AlternateLocation alternateLocation2 = (AlternateLocation)iterator2.next();
                bl = alternateLocation.equalsURL(alternateLocation2);
                if (bl) break;
            }
            if (bl) continue;
            alternateLocationCollection2.addAlternateLocation(alternateLocation);
        }
        return alternateLocationCollection2;
    }

    public synchronized Collection values() {
        if (this._alternateLocations == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList arrayList = new ArrayList(this._alternateLocations.values());
        Collections.shuffle(arrayList);
        return arrayList;
    }

    private synchronized void createMap() {
        if (this._alternateLocations == null) {
            this._alternateLocations = Collections.synchronizedSortedMap(new TreeMap());
        }
    }

    public synchronized String httpStringValue() {
        if (this._alternateLocations == null) {
            return "";
        }
        List list = new LinkedList(this._alternateLocations.values());
        Collections.shuffle(list);
        list = list.subList(0, list.size() >= 10 ? 10 : list.size());
        Iterator iterator = list.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            stringBuffer.append(((HTTPHeaderValue)iterator.next()).httpStringValue());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    public synchronized int size() {
        if (this._alternateLocations == null) {
            return 0;
        }
        return this._alternateLocations.size();
    }

    public int numberOfAlternateLocations() {
        return this.size();
    }

    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Alternate Locations: ");
        if (this._alternateLocations == null) {
            stringBuffer.append("empty");
        } else {
            SortedMap sortedMap = this._alternateLocations;
            synchronized (sortedMap) {
                Iterator iterator = this._alternateLocations.values().iterator();
                while (iterator.hasNext()) {
                    AlternateLocation alternateLocation = (AlternateLocation)iterator.next();
                    stringBuffer.append(alternateLocation.toString());
                    stringBuffer.append(" ");
                }
            }
        }
        return stringBuffer.toString();
    }
}

