/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.InsufficientDataException;
import com.limegroup.gnutella.util.Buffer;
import com.sun.java.util.collections.Iterator;
import java.io.IOException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class BandwidthTrackerImpl
implements Serializable {
    static final long serialVersionUID = 7694080781117787305L;
    static final int HISTORY_SIZE = 10;
    transient Buffer snapShots = new Buffer(10);
    private transient int numMeasures = 0;
    private transient float averageBandwidth = 0.0f;
    long lastTime;
    int lastAmountRead;
    float measuredBandwidth;

    public synchronized void measureBandwidth(int n) {
        long l = System.currentTimeMillis();
        if (this.lastAmountRead == 0 || l == this.lastTime) {
            this.measuredBandwidth = 0.0f;
        } else {
            this.measuredBandwidth = (float)(n - this.lastAmountRead) / (float)(l - this.lastTime);
            this.measuredBandwidth = Math.max(this.measuredBandwidth, 0.0f);
        }
        this.lastTime = l;
        this.lastAmountRead = n;
        this.averageBandwidth = (this.averageBandwidth * (float)this.numMeasures + this.measuredBandwidth) / (float)(++this.numMeasures);
        this.snapShots.add(new Float(this.measuredBandwidth));
    }

    public synchronized float getMeasuredBandwidth() throws InsufficientDataException {
        int n = this.snapShots.getSize();
        if (n < 3) {
            throw new InsufficientDataException();
        }
        Iterator iterator = this.snapShots.iterator();
        float f = 0.0f;
        while (iterator.hasNext()) {
            f += ((Float)iterator.next()).floatValue();
        }
        return f / (float)n;
    }

    public synchronized float getAverageBandwidth() {
        if (this.snapShots.getSize() < 3) {
            return 0.0f;
        }
        return this.averageBandwidth;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.snapShots = new Buffer(10);
        this.numMeasures = 0;
        this.averageBandwidth = 0.0f;
        try {
            objectInputStream.defaultReadObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("Class not found");
        }
        catch (NotActiveException notActiveException) {
            throw new IOException("Not active");
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }
}

