/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.BadPacketException;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.PushRequest;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.Sockets;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.StringTokenizer;

public class BrowseHostHandler {
    private static final long EXPIRE_TIME = 9000L;
    private static final int SPECIAL_INDEX = 0;
    private static Map _pushedHosts = new HashMap();
    private ActivityCallback _callback = null;
    private MessageRouter _router = null;
    private Acceptor _acceptor = null;
    private GUID _guid = null;
    private GUID _serventID = null;
    private static final boolean debugOn = false;

    public BrowseHostHandler(ActivityCallback activityCallback, MessageRouter messageRouter, Acceptor acceptor, GUID gUID, GUID gUID2) {
        this._callback = activityCallback;
        this._router = messageRouter;
        this._acceptor = acceptor;
        this._guid = gUID;
        this._serventID = gUID2;
    }

    public void browseHost(String string, int n) {
        int n2 = BrowseHostHandler.needsPush(string, n);
        boolean bl = false;
        switch (n2) {
            case 0: {
                Object object;
                try {
                    object = Sockets.connect(string, n, 0, true);
                    this.browseExchange((Socket)object);
                }
                catch (IOException iOException) {
                    bl = true;
                }
                if (!bl) break;
            }
            case 1: {
                if (this._serventID == null) {
                    this._callback.browseHostFailed(this._guid);
                    break;
                }
                Object object = new PushRequest(GUID.makeGuid(), SettingsManager.instance().getTTL(), this._serventID.bytes(), 0L, this._acceptor.getAddress(), this._acceptor.getPort());
                Map map = _pushedHosts;
                synchronized (map) {
                    _pushedHosts.put(this._serventID, new PushRequestDetails(this));
                }
                try {
                    this._router.sendPushRequest((PushRequest)object);
                    break;
                }
                catch (IOException iOException) {
                    BrowseHostHandler.debug(iOException);
                    Map map2 = _pushedHosts;
                    synchronized (map2) {
                        _pushedHosts.remove(this._serventID);
                    }
                    this._callback.browseHostFailed(this._guid);
                }
            }
        }
    }

    private void browseExchange(Socket socket) throws IOException {
        BrowseHostHandler.debug("BHH.browseExchange(): entered.");
        String string = null;
        OutputStream outputStream = socket.getOutputStream();
        BrowseHostHandler.debug("BHH.browseExchange(): got output stream.");
        string = "GET / HTTP/1.1\r\n";
        outputStream.write(string.getBytes());
        string = "Host: " + Message.ip2string(this._acceptor.getAddress()) + ":" + this._acceptor.getPort() + "\r\n";
        outputStream.write(string.getBytes());
        string = "User-Agent: " + CommonUtils.getVendor() + "\r\n";
        outputStream.write(string.getBytes());
        string = "Accept: application/x-gnutella-packets\r\n";
        outputStream.write(string.getBytes());
        string = "Content-Length: 0\r\n";
        outputStream.write(string.getBytes());
        string = "Connection: close\r\n";
        outputStream.write(string.getBytes());
        string = "\r\n";
        outputStream.write(string.getBytes());
        outputStream.flush();
        BrowseHostHandler.debug("BHH.browseExchange(): wrote request A-OK.");
        InputStream inputStream = socket.getInputStream();
        BrowseHostHandler.debug("BHH.browseExchange(): got input stream.");
        ByteReader byteReader = new ByteReader(inputStream);
        BrowseHostHandler.debug("BHH.browseExchange(): trying to get HTTP code....");
        int n = BrowseHostHandler.parseHTTPCode(byteReader.readLine());
        if (n < 200 || n >= 300) {
            throw new IOException();
        }
        BrowseHostHandler.debug("BHH.browseExchange(): HTTP Response is " + n);
        boolean bl = true;
        String string2 = null;
        while (bl) {
            string2 = byteReader.readLine();
            BrowseHostHandler.debug("BHH.browseExchange(): currLine = " + string2);
            if (string2 == null || string2.equals("")) {
                bl = false;
                continue;
            }
            if (this.indexOfIgnoreCase(string2, "User-Agent") > -1 || !(this.indexOfIgnoreCase(string2, "Content-Type") > -1 ? this.indexOfIgnoreCase(string2, "application/x-gnutella-packets") < 0 : this.indexOfIgnoreCase(string2, "Content-Encoding") > -1)) continue;
            throw new IOException();
        }
        BrowseHostHandler.debug("BHH.browseExchange(): read HTTP seemingly OK.");
        Message message = null;
        while (true) {
            try {
                message = null;
                message = Message.read(inputStream);
            }
            catch (BadPacketException badPacketException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (message == null) {
                return;
            }
            if (!(message instanceof QueryReply)) continue;
            BrowseHostHandler.debug("BHH.browseExchange(): read a QR");
            QueryReply queryReply = (QueryReply)message;
            message.setGUID(this._guid);
            if (this._callback == null) continue;
            this._callback.handleQueryReply(queryReply);
        }
    }

    private static int needsPush(String string, int n) {
        if (new Endpoint(string, n).isPrivateAddress()) {
            return 1;
        }
        return 0;
    }

    private int indexOfIgnoreCase(String string, String string2) {
        String string3 = string.toLowerCase();
        String string4 = string2.toLowerCase();
        return string3.indexOf(string4);
    }

    private static int parseHTTPCode(String string) throws IOException {
        if (string == null) {
            return -1;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (!stringTokenizer.hasMoreTokens()) {
            throw new IOException();
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.toUpperCase().indexOf("HTTP") < 0) {
            throw new IOException();
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new IOException();
        }
        string2 = stringTokenizer.nextToken();
        String string3 = string2.trim();
        try {
            BrowseHostHandler.debug("BHH.parseHTTPCode(): returning " + string3);
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException();
        }
    }

    public static void handlePush(int n, GUID gUID, Socket socket) throws IOException {
        BrowseHostHandler.debug("BHH.handlePush(): entered.");
        if (n == 0) {
            // empty if block
        }
        PushRequestDetails pushRequestDetails = null;
        Map map = _pushedHosts;
        synchronized (map) {
            pushRequestDetails = (PushRequestDetails)_pushedHosts.remove(gUID);
        }
        if (pushRequestDetails != null) {
            pushRequestDetails.bhh.browseExchange(socket);
        } else {
            BrowseHostHandler.debug("BHH.handlePush(): no matching BHH.");
        }
        BrowseHostHandler.debug("BHH.handlePush(): returning.");
    }

    private static final void debug(String string) {
    }

    private static final void debug(Exception exception) {
    }

    static {
        Expirer expirer = new Expirer();
        RouterService.schedule(expirer, 0L, 5000L);
    }

    private class PushRequestDetails {
        public BrowseHostHandler bhh;
        private long timeStamp = System.currentTimeMillis();

        public PushRequestDetails(BrowseHostHandler browseHostHandler2) {
            this.bhh = browseHostHandler2;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.timeStamp > 9000L;
        }
    }

    private static class Expirer
    implements Runnable {
        private Expirer() {
        }

        public void run() {
            try {
                Iterator iterator = null;
                HashSet hashSet = new HashSet();
                Map map = _pushedHosts;
                synchronized (map) {
                    iterator = _pushedHosts.keySet().iterator();
                    while (iterator.hasNext()) {
                        Object object = iterator.next();
                        PushRequestDetails pushRequestDetails = null;
                        pushRequestDetails = (PushRequestDetails)_pushedHosts.get(object);
                        if (pushRequestDetails == null || !pushRequestDetails.isExpired()) continue;
                        BrowseHostHandler.debug("Expirer.run(): expiring a badboy.");
                        hashSet.add(object);
                        pushRequestDetails.bhh._callback.browseHostFailed(pushRequestDetails.bhh._guid);
                    }
                    iterator = hashSet.iterator();
                    while (iterator.hasNext()) {
                        _pushedHosts.remove(iterator.next());
                    }
                }
            }
            catch (Throwable throwable) {
                RouterService.error(throwable);
            }
        }
    }
}

