/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.sun.java.util.collections.Arrays;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ByteOrder {
    public static byte[] reverse(byte[] byArray) {
        int n = byArray.length;
        byte[] byArray2 = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            byArray2[n2] = byArray[n - n2 - 1];
            ++n2;
        }
        return byArray2;
    }

    public static short leb2short(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        int n3 = byArray[n + 1] << 8;
        return (short)(n3 | n2);
    }

    public static short leb2short(InputStream inputStream) throws IOException {
        int n = inputStream.read() & 0xFF;
        int n2 = inputStream.read() << 8;
        return (short)(n2 | n);
    }

    public static int leb2int(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        int n3 = byArray[n + 1] << 8 & 0xFF00;
        int n4 = byArray[n + 2] << 16 & 0xFF0000;
        int n5 = byArray[n + 3] << 24;
        return n5 | n4 | n3 | n2;
    }

    public static int leb2int(InputStream inputStream) throws IOException {
        int n = inputStream.read() & 0xFF;
        int n2 = inputStream.read() << 8 & 0xFF00;
        int n3 = inputStream.read() << 16 & 0xFF0000;
        int n4 = inputStream.read() << 24;
        return n4 | n3 | n2 | n;
    }

    public static int leb2int(byte[] byArray, int n, int n2) throws IndexOutOfBoundsException, IllegalArgumentException {
        if (n2 < 1 || n2 > 4) {
            throw new IllegalArgumentException("No bytes specified");
        }
        int n3 = byArray[n] & 0xFF;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (n2 > 1) {
            n4 = byArray[n + 1] << 8 & 0xFF00;
            if (n2 > 2) {
                n5 = byArray[n + 2] << 16 & 0xFF0000;
                if (n2 > 3) {
                    n6 = byArray[n + 3] << 24;
                }
            }
        }
        return n6 | n5 | n4 | n3;
    }

    public static void short2leb(short s, byte[] byArray, int n) {
        byArray[n] = (byte)(s & 0xFF);
        byArray[n + 1] = (byte)((short)(s >> 8) & 0xFF);
    }

    public static void short2leb(short s, OutputStream outputStream) throws IOException {
        outputStream.write((byte)(s & 0xFF));
        outputStream.write((byte)((short)(s >> 8) & 0xFF));
    }

    public static void int2leb(int n, byte[] byArray, int n2) {
        byArray[n2] = (byte)(n & 0xFF);
        byArray[n2 + 1] = (byte)(n >> 8 & 0xFF);
        byArray[n2 + 2] = (byte)(n >> 16 & 0xFF);
        byArray[n2 + 3] = (byte)(n >> 24 & 0xFF);
    }

    public static byte[] int2minLeb(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4);
        do {
            byteArrayOutputStream.write(n & 0xFF);
        } while ((n >>= 8) != 0);
        return byteArrayOutputStream.toByteArray();
    }

    public static int ubyte2int(byte by) {
        return by & 0xFF;
    }

    public static int ubytes2int(short s) {
        return s & 0xFFFF;
    }

    public static long ubytes2long(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public static int long2int(long l) {
        if (l >= Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if (l <= Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)l;
    }

    public static void main(String[] stringArray) {
        int n;
        byte[] byArray = new byte[]{2, 1};
        short s = ByteOrder.leb2short(byArray, 0);
        Assert.that(s == 258, "result1=" + s);
        byte[] byArray2 = new byte[2];
        ByteOrder.short2leb(s, byArray2, 0);
        int n2 = 0;
        while (n2 < 2) {
            Assert.that(byArray2[n2] == byArray[n2]);
            ++n2;
        }
        byte[] byArray3 = new byte[]{2, 0, 0, 1};
        int n3 = ByteOrder.leb2int(byArray3, 0);
        Assert.that(n3 == 0x1000002, "result2=" + n3);
        byte[] byArray4 = new byte[4];
        ByteOrder.int2leb(n3, byArray4, 0);
        int n4 = 0;
        while (n4 < 4) {
            Assert.that(byArray4[n4] == byArray3[n4]);
            ++n4;
        }
        byte[] byArray5 = new byte[]{0, -13, 0, -1};
        int n5 = ByteOrder.leb2int(byArray5, 0);
        Assert.that(n5 == -16715008, Integer.toHexString(n5));
        byte[] byArray6 = new byte[]{-1, -13};
        short s2 = ByteOrder.leb2short(byArray6, 0);
        Assert.that(s2 == -3073, Integer.toHexString(s2));
        int n6 = n = -1;
        Assert.that(n6 == -1, n6 + "");
        n6 = ByteOrder.ubyte2int((byte)n);
        Assert.that(n6 == 255, n6 + "");
        n6 = ByteOrder.ubyte2int((byte)1);
        Assert.that(n6 == 1, n6 + "");
        short s3 = -1;
        Assert.that(s3 < 0, "L122");
        Assert.that(ByteOrder.ubytes2int(s3) == 65535, "L123");
        Assert.that(ByteOrder.ubytes2int(s3) > 0, "L124");
        int n7 = -1;
        Assert.that(n7 < 0, "L127");
        Assert.that(ByteOrder.ubytes2long(n7) == 0xFFFFFFFFL, "L128");
        Assert.that(ByteOrder.ubytes2long(n7) > 0L, "L129");
        byte[] byArray7 = new byte[]{-1, -1};
        s3 = ByteOrder.leb2short(byArray7, 0);
        Assert.that(s3 == -1, "L133: " + Integer.toHexString(s3));
        int n8 = ByteOrder.ubytes2int(s3);
        Assert.that(n8 == 65535, "L134: " + n6);
        byte[] byArray8 = new byte[]{-1, -1, -1, -1};
        n7 = ByteOrder.leb2int(byArray8, 0);
        Assert.that(n7 == -1, "L139");
        long l = ByteOrder.ubytes2long(n7);
        Assert.that(l == 0xFFFFFFFFL, "L141");
        Assert.that(ByteOrder.long2int(5L) == 5);
        Assert.that(ByteOrder.long2int(-10L) == -10);
        Assert.that(ByteOrder.long2int(0L) == 0);
        Assert.that(ByteOrder.long2int(0xABFFFFFFFFL) == Integer.MAX_VALUE);
        Assert.that(ByteOrder.long2int(-738734374911L) == Integer.MIN_VALUE);
        ByteOrder.testInt2MinLeb();
        ByteOrder.testLeb2Int();
    }

    public static void testInt2MinLeb() {
        try {
            ByteOrder.int2minLeb(-1);
            Assert.that(false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        Assert.that(Arrays.equals(ByteOrder.int2minLeb(0), new byte[]{0}));
        Assert.that(Arrays.equals(ByteOrder.int2minLeb(1), new byte[]{1}));
        Assert.that(Arrays.equals(ByteOrder.int2minLeb(7), new byte[]{7}));
        Assert.that(Arrays.equals(ByteOrder.int2minLeb(72831), new byte[]{127, 28, 1}));
        Assert.that(Arrays.equals(ByteOrder.int2minLeb(731328764), new byte[]{-4, 48, -105, 43}));
    }

    public static void testLeb2Int() {
        Assert.that(ByteOrder.leb2int(new byte[]{0}, 0, 1) == 0);
        Assert.that(ByteOrder.leb2int(new byte[]{1}, 0, 1) == 1);
        Assert.that(ByteOrder.leb2int(new byte[]{7}, 0, 1) == 7);
        Assert.that(ByteOrder.leb2int(new byte[]{127, 28, 1}, 0, 3) == 72831);
        Assert.that(ByteOrder.leb2int(new byte[]{127, 28, 1}, 1, 1) == 28);
    }
}

