/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Acceptor;
import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BadPacketException;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.handshaking.BadHandshakeException;
import com.limegroup.gnutella.handshaking.HandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.NoGnutellaOkException;
import com.limegroup.gnutella.util.Sockets;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class Connection {
    private String _host;
    private int _port;
    private Socket _socket;
    private InputStream _in;
    private OutputStream _out;
    private boolean _outgoing;
    protected volatile boolean _closed = false;
    private Properties _propertiesRead;
    private Properties _propertiesWrittenP;
    private HandshakeResponder _propertiesWrittenR;
    private Properties _propertiesWrittenTotal = new Properties();
    private boolean _negotiate = false;
    public static final String GNUTELLA_CONNECT_04 = "GNUTELLA CONNECT/0.4";
    public static final String GNUTELLA_OK_04 = "GNUTELLA OK";
    public static final String GNUTELLA_CONNECT_06 = "GNUTELLA CONNECT/0.6";
    public static final String GNUTELLA_OK_06 = "GNUTELLA/0.6 200 OK";
    public static final String GNUTELLA_06 = "GNUTELLA/0.6";
    public static final String _200_OK = " 200 OK";
    public static final String GNUTELLA_06_200 = "GNUTELLA/0.6 200";
    public static final String CONNECT = "CONNECT/";
    public static final String CRLF = "\r\n";
    public static final String LF = "\n";
    public static final int USER_INPUT_WAIT_TIME = 120000;
    public static final int MAX_HANDSHAKE_ATTEMPTS = 5;
    private final SettingsManager SETTINGS = SettingsManager.instance();
    private byte[] HEADER_BUF = new byte[23];

    public Connection(String string, int n) {
        this(string, n, null, null, false);
    }

    public Connection(String string, int n, Properties properties, HandshakeResponder handshakeResponder, boolean bl) {
        this._host = string;
        this._port = n;
        this._outgoing = true;
        this._negotiate = bl;
        this._propertiesWrittenP = properties;
        this._propertiesWrittenR = handshakeResponder;
    }

    public Connection(Socket socket) {
        this(socket, null);
    }

    public Connection(Socket socket, HandshakeResponder handshakeResponder) {
        this._host = socket.getInetAddress().getHostAddress();
        this._port = socket.getPort();
        this._socket = socket;
        this._outgoing = false;
        this._propertiesWrittenR = handshakeResponder;
    }

    public void initialize() throws IOException, NoGnutellaOkException, BadHandshakeException {
        this.initialize(0);
    }

    public void initialize(int n) throws IOException, NoGnutellaOkException, BadHandshakeException {
        try {
            this.initializeWithoutRetry(n);
        }
        catch (NoGnutellaOkException noGnutellaOkException) {
            throw noGnutellaOkException;
        }
        catch (BadHandshakeException badHandshakeException) {
            if (this._negotiate && this.isOutgoing() && this._propertiesWrittenP != null && this._propertiesWrittenR != null) {
                this._propertiesRead = null;
                this._propertiesWrittenP = null;
                this._propertiesWrittenR = null;
                this.initializeWithoutRetry(n);
            }
            throw badHandshakeException;
        }
    }

    private void initializeWithoutRetry(int n) throws IOException {
        SettingsManager settingsManager = SettingsManager.instance();
        if (this.isOutgoing()) {
            this._socket = Sockets.connect(this._host, this._port, n, true);
        }
        if (this._closed) {
            this._socket.close();
            throw new IOException();
        }
        try {
            Acceptor.setAddress(this._socket.getLocalAddress().getAddress());
            this._in = this.getInputStream(this._socket);
            this._out = this.getOutputStream(this._socket);
            if (this._in == null || this._out == null) {
                throw new IOException();
            }
        }
        catch (Exception exception) {
            throw new IOException();
        }
        try {
            if (this.isOutgoing()) {
                this.initializeOutgoing();
            } else {
                this.initializeIncoming();
            }
        }
        catch (NoGnutellaOkException noGnutellaOkException) {
            this._socket.close();
            throw noGnutellaOkException;
        }
        catch (IOException iOException) {
            this._socket.close();
            throw new BadHandshakeException(iOException);
        }
    }

    private void initializeOutgoing() throws IOException {
        if (this._propertiesWrittenP == null || this._propertiesWrittenR == null) {
            this.sendString("GNUTELLA CONNECT/0.4\n\n");
            if (!this.readLine().equals(GNUTELLA_OK_04)) {
                throw new IOException("Bad connect string");
            }
            if (!this.readLine().equals("")) {
                throw new IOException("Bad connect string");
            }
        } else {
            this.sendString("GNUTELLA CONNECT/0.6\r\n");
            this.sendHeaders(this._propertiesWrittenP);
            this.concludeOutgoingHandshake();
        }
    }

    private void concludeOutgoingHandshake() throws IOException {
        int n = 0;
        while (n < 5) {
            String string = this.readLine();
            if (!string.startsWith(GNUTELLA_06)) {
                throw new IOException("Bad connect string");
            }
            if (this._propertiesRead == null) {
                this._propertiesRead = new Properties();
            }
            this.readHeaders();
            HandshakeResponse handshakeResponse = new HandshakeResponse(string.substring(GNUTELLA_06.length()).trim(), this._propertiesRead);
            int n2 = handshakeResponse.getStatusCode();
            if (n2 != 200 && n2 != 401) {
                throw new NoGnutellaOkException(false, handshakeResponse.getStatusCode(), "Server sent fatal response");
            }
            HandshakeResponse handshakeResponse2 = this._propertiesWrittenR.respond(handshakeResponse, true);
            this.sendString("GNUTELLA/0.6 " + handshakeResponse2.getStatusLine() + CRLF);
            this.sendHeaders(handshakeResponse2.getHeaders());
            if (handshakeResponse2.getStatusCode() == 200) {
                if (handshakeResponse2.getStatusMessage().equals("OK")) {
                    return;
                }
            } else {
                throw new NoGnutellaOkException(true, handshakeResponse2.getStatusCode(), "We sent fatal response");
            }
            ++n;
        }
        throw new NoGnutellaOkException(false, 401, "Too much handshaking, no conclusion");
    }

    private void initializeIncoming() throws IOException {
        String string = this.readLine();
        if (!this.SETTINGS.acceptAuthenticatedConnectionsOnly() && GNUTELLA_CONNECT_04.endsWith(string)) {
            if (!this.readLine().equals("")) {
                throw new IOException("Bad connect string");
            }
            this.sendString("GNUTELLA OK\n\n");
            this._propertiesWrittenP = null;
            this._propertiesWrittenR = null;
        } else if (Connection.notLessThan06(string)) {
            this._propertiesRead = new Properties();
            this.readHeaders();
            this.concludeIncomingHandshake();
        } else {
            throw new IOException("Unexpected connect string");
        }
    }

    private void concludeIncomingHandshake() throws IOException {
        int n = 0;
        while (n < 5) {
            block12: {
                HandshakeResponse handshakeResponse;
                block11: {
                    int n2;
                    block10: {
                        String string;
                        HandshakeResponse handshakeResponse2 = null;
                        handshakeResponse2 = this._propertiesWrittenR == null ? new HandshakeResponse(new Properties()) : this._propertiesWrittenR.respond(new HandshakeResponse(this._propertiesRead), false);
                        this.sendString("GNUTELLA/0.6 " + handshakeResponse2.getStatusLine() + CRLF);
                        this.sendHeaders(handshakeResponse2.getHeaders());
                        if (handshakeResponse2.getStatusCode() != 200 && handshakeResponse2.getStatusCode() != 401) {
                            throw new NoGnutellaOkException(true, handshakeResponse2.getStatusCode(), "We sent fatal status code");
                        }
                        if (handshakeResponse2.getStatusCode() == 401) {
                            string = this.readLine(120000);
                            this.readHeaders(120000);
                        } else {
                            string = this.readLine();
                            this.readHeaders();
                        }
                        if (!string.startsWith(GNUTELLA_06)) {
                            throw new IOException("Bad connect string");
                        }
                        handshakeResponse = new HandshakeResponse(string.substring(GNUTELLA_06.length()).trim(), this._propertiesRead);
                        n2 = handshakeResponse2.getStatusCode();
                        if (n2 != 200) break block10;
                        if (handshakeResponse.getStatusCode() == 200) {
                            return;
                        }
                        break block11;
                    }
                    Assert.that(n2 == 401, "Response code: " + n2);
                    if (handshakeResponse.getStatusCode() == 200) break block12;
                }
                throw new NoGnutellaOkException(false, handshakeResponse.getStatusCode(), "Initiator sent fatal status code");
            }
            ++n;
        }
        throw new NoGnutellaOkException(true, 401, "Too much handshaking, no conclusion");
    }

    private static boolean notLessThan06(String string) {
        int n = string.indexOf(CONNECT);
        if (n < 0) {
            return false;
        }
        try {
            Float f = new Float(string.substring(n + CONNECT.length()));
            float f2 = f.floatValue();
            return f2 >= 0.6f;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private void sendHeaders(Properties properties) throws IOException {
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                if ("Remote-IP".equals(string)) {
                    string2 = this.getInetAddress().getHostAddress();
                }
                if (string2 == null) {
                    string2 = "";
                }
                this.sendString(string + ": " + string2 + CRLF);
                ((Hashtable)this._propertiesWrittenTotal).put(string, string2);
            }
        }
        this.sendString(CRLF);
    }

    private void readHeaders() throws IOException {
        this.readHeaders(this.SETTINGS.getTimeout());
    }

    private void readHeaders(int n) throws IOException {
        while (true) {
            String string;
            if ((string = this.readLine(n)) == null) {
                throw new IOException();
            }
            if (string.equals("")) {
                return;
            }
            int n2 = string.indexOf(58);
            if (n2 < 0) continue;
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1).trim();
            ((Hashtable)this._propertiesRead).put(string2, string3);
        }
    }

    private void sendString(String string) throws IOException {
        byte[] byArray = string.getBytes();
        this._out.write(byArray);
        this._out.flush();
    }

    private String readLine() throws IOException {
        return this.readLine(this.SETTINGS.getTimeout());
    }

    private String readLine(int n) throws IOException {
        String string;
        int n2 = this._socket.getSoTimeout();
        try {
            this._socket.setSoTimeout(n);
            String string2 = new ByteReader(this._in).readLine();
            if (string2 == null) {
                throw new IOException();
            }
            string = string2;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this._socket.setSoTimeout(n2);
            throw throwable;
        }
        this._socket.setSoTimeout(n2);
        return string;
    }

    protected OutputStream getOutputStream(Socket socket) throws IOException {
        return new BufferedOutputStream(this._socket.getOutputStream());
    }

    protected InputStream getInputStream(Socket socket) throws IOException {
        return new BufferedInputStream(this._socket.getInputStream());
    }

    public boolean isOutgoing() {
        return this._outgoing;
    }

    protected Message receive() throws IOException, BadPacketException {
        if (this._closed) {
            throw new IOException();
        }
        Message message = null;
        while (message == null) {
            message = Message.read(this._in, this.HEADER_BUF);
        }
        return message;
    }

    public Message receive(int n) throws IOException, BadPacketException, InterruptedIOException {
        Message message;
        if (this._closed) {
            throw new IOException();
        }
        int n2 = this._socket.getSoTimeout();
        this._socket.setSoTimeout(n);
        try {
            Message message2 = Message.read(this._in);
            if (message2 == null) {
                throw new InterruptedIOException();
            }
            message = message2;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this._socket.setSoTimeout(n2);
            throw throwable;
        }
        this._socket.setSoTimeout(n2);
        return message;
    }

    public void send(Message message) throws IOException {
        message.write(this._out);
    }

    public void flush() throws IOException {
        this._out.flush();
    }

    public String getOrigHost() {
        return this._host;
    }

    public int getOrigPort() {
        return this._port;
    }

    void setOrigPort(int n) {
        this._port = n;
    }

    public int getPort() throws IllegalStateException {
        try {
            return this._socket.getPort();
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("Not initialized");
        }
    }

    public int getLocalPort() throws IllegalStateException {
        try {
            return this._socket.getLocalPort();
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("Not initialized");
        }
    }

    public InetAddress getInetAddress() throws IllegalStateException {
        try {
            return this._socket.getInetAddress();
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("Not initialized");
        }
    }

    public InetAddress getLocalAddress() throws IllegalStateException {
        try {
            return this._socket.getLocalAddress();
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("Not initialized");
        }
    }

    public String getProperty(String string) {
        if (this._propertiesRead == null) {
            return null;
        }
        return this._propertiesRead.getProperty(string);
    }

    public Properties getHeaders() {
        if (this._propertiesRead == null) {
            return null;
        }
        return (Properties)((Hashtable)this._propertiesRead).clone();
    }

    public String getPropertyWritten(String string) {
        return this._propertiesWrittenTotal.getProperty(string);
    }

    public boolean isOpen() {
        return !this._closed;
    }

    public void close() {
        this._closed = true;
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return "host=" + this._host + " port=" + this._port;
    }
}

