/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.ConnectionWatchdog;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.HostCatcher;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.PingRequest;
import com.limegroup.gnutella.QueryUnicaster;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.handshaking.BadHandshakeException;
import com.limegroup.gnutella.handshaking.ConnectionHandshakeHeaders;
import com.limegroup.gnutella.handshaking.NoGnutellaOkException;
import com.limegroup.gnutella.security.Authenticator;
import com.limegroup.gnutella.statistics.ConnectionStat;
import com.limegroup.gnutella.util.CommonUtils;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.net.Socket;
import java.util.Properties;
import java.util.StringTokenizer;

public class ConnectionManager {
    public static final int MIN_CONNECTIONS_FOR_SUPERNODE = 6;
    public static final int PREFERRED_CONNECTIONS_FOR_LEAF = 3;
    public static final int RESERVED_GOOD_CONNECTIONS = 2;
    public static final int ALLOWED_BAD_LEAF_CONNECTIONS = 4;
    private int MAX_SUPERNODE_ENDPOINTS = 10;
    private MessageRouter _router;
    private HostCatcher _catcher;
    private SettingsManager _settings;
    private ConnectionWatchdog _watchdog;
    private volatile int _keepAlive = 0;
    private List _fetchers = new ArrayList();
    private List _initializingFetchedConnections = new ArrayList();
    private volatile List _connections = new ArrayList();
    private volatile List _initializedConnections = new ArrayList();
    private volatile List _initializedClientConnections = new ArrayList();
    private Authenticator _authenticator;

    public ConnectionManager(Authenticator authenticator) {
        this._authenticator = authenticator;
        this._settings = SettingsManager.instance();
    }

    public void initialize() {
        this._router = RouterService.getMessageRouter();
        this._catcher = RouterService.getHostCatcher();
        this._watchdog = new ConnectionWatchdog(this, this._router);
        Thread thread = new Thread(this._watchdog);
        thread.setDaemon(true);
        thread.start();
    }

    public ManagedConnection createConnectionBlocking(String string, int n) throws IOException {
        ManagedConnection managedConnection = new ManagedConnection(string, n, this._router, this);
        this.initializeExternallyGeneratedConnection(managedConnection);
        new OutgoingConnectionThread(managedConnection, false);
        return managedConnection;
    }

    public void createConnectionAsynchronously(String string, int n) {
        new OutgoingConnectionThread(new ManagedConnection(string, n, this._router, this), true);
    }

    void acceptConnection(Socket socket) {
        block13: {
            ManagedConnection managedConnection = null;
            try {
                managedConnection = new ManagedConnection(socket, this._router, this);
                this.initializeExternallyGeneratedConnection(managedConnection);
            }
            catch (IOException iOException) {
                if (managedConnection != null) {
                    managedConnection.close();
                }
                return;
            }
            try {
                try {
                    if (managedConnection.isSupernodeClientConnection()) {
                        this.ensureConnectionsForSupernode();
                    }
                    this.startConnection(managedConnection);
                }
                catch (IOException iOException) {
                    Object var6_6 = null;
                    if (managedConnection.isClientSupernodeConnection()) {
                        this.lostShieldedClientSupernodeConnection();
                    }
                    break block13;
                }
                catch (Exception exception) {
                    RouterService.error(12, exception);
                    Object var6_7 = null;
                    if (managedConnection.isClientSupernodeConnection()) {
                        this.lostShieldedClientSupernodeConnection();
                    }
                }
                Object var6_5 = null;
                if (managedConnection.isClientSupernodeConnection()) {
                    this.lostShieldedClientSupernodeConnection();
                }
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                if (managedConnection.isClientSupernodeConnection()) {
                    this.lostShieldedClientSupernodeConnection();
                }
                throw throwable;
            }
        }
    }

    public synchronized void remove(ManagedConnection managedConnection) {
        this.removeInternal(managedConnection);
        this.adjustConnectionFetchers();
    }

    public int getKeepAlive() {
        return this._keepAlive;
    }

    public synchronized void setKeepAlive(int n) {
        this._keepAlive = n;
        this.adjustConnectionFetchers();
    }

    public synchronized void ensureConnectionsForSupernode() {
        if (this.getNumInitializedClientConnections() > 0 && this._keepAlive < 6) {
            this.setKeepAlive(6);
        }
    }

    public boolean isSupernode() {
        boolean bl = SettingsManager.instance().getEverSupernodeCapable();
        return bl && !this.hasClientSupernodeConnection();
    }

    public boolean hasClientSupernodeConnection() {
        List list = this.getInitializedConnections();
        int n = 0;
        while (n < list.size()) {
            ManagedConnection managedConnection = (ManagedConnection)list.get(n);
            if (managedConnection.isClientSupernodeConnection()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean hasSupernodeClientConnection() {
        return this.getNumInitializedClientConnections() > 0;
    }

    public boolean isConnected(Endpoint endpoint) {
        String string = endpoint.getHostname();
        List list = this.getConnections();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            try {
                if (!managedConnection.getInetAddress().getHostAddress().equals(string)) continue;
                return true;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return false;
    }

    public int getNumConnections() {
        return this._connections.size();
    }

    private int getNumInitializedConnections() {
        return this._initializedConnections.size();
    }

    private int getNumInitializedClientConnections() {
        return this._initializedClientConnections.size();
    }

    int getNumFreeLeafSlots() {
        if (this.isSupernode()) {
            return SettingsManager.instance().getMaxShieldedClientConnections() - this.getNumInitializedClientConnections();
        }
        return 0;
    }

    int getNumFreeNonLeafSlots() {
        return this.getKeepAlive() - this.getNumInitializedConnections();
    }

    public boolean isConnected() {
        return this._initializedClientConnections.size() > 0 || this._initializedConnections.size() > 0;
    }

    public void measureBandwidth() {
        List list = this.getInitializedConnections();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            managedConnection.measureBandwidth();
        }
    }

    public float getMeasuredUpstreamBandwidth() {
        float f = 0.0f;
        List list = this.getInitializedConnections();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            f += managedConnection.getMeasuredUpstreamBandwidth();
        }
        return f;
    }

    public float getMeasuredDownstreamBandwidth() {
        float f = 0.0f;
        List list = this.getInitializedConnections();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            f += managedConnection.getMeasuredDownstreamBandwidth();
        }
        return f;
    }

    public boolean allowConnection(ManagedConnection managedConnection) {
        return this.allowConnection(managedConnection.isOutgoing(), managedConnection.getProperty("X-Ultrapeer"), managedConnection.getProperty("User-Agent"));
    }

    public boolean allowAnyConnection() {
        int n = SettingsManager.instance().getMaxShieldedClientConnections();
        if (this.hasClientSupernodeConnection()) {
            return false;
        }
        return this.getNumInitializedConnections() < this._keepAlive || this.isSupernode() && this.getNumInitializedClientConnections() < n;
    }

    public synchronized boolean allowConnection(boolean bl, String string, String string2) {
        SettingsManager settingsManager = SettingsManager.instance();
        boolean bl2 = string != null;
        boolean bl3 = ConnectionHandshakeHeaders.isFalse(string);
        if (this._keepAlive <= 0) {
            return false;
        }
        if (this.hasClientSupernodeConnection()) {
            return false;
        }
        if (bl3 && bl2) {
            int n = SettingsManager.instance().getMaxShieldedClientConnections();
            return this.getNumInitializedClientConnections() < (ConnectionManager.trustedVendor(string2) ? n : 4);
        }
        return this.getNumInitializedConnections() < (ConnectionManager.trustedVendor(string2) ? this._keepAlive : this._keepAlive - 2);
    }

    private static boolean trustedVendor(String string) {
        if (string == null) {
            return false;
        }
        return string.startsWith("LimeWire") || string.startsWith("Swapper");
    }

    private int ultrapeerConnections() {
        int n = 0;
        Iterator iterator = this._initializedConnections.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            if (!managedConnection.isSupernodeConnection()) continue;
            ++n;
        }
        return n;
    }

    private int oldConnections() {
        int n = 0;
        Iterator iterator = this._initializedConnections.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            if (managedConnection.getProperty("X-Ultrapeer") != null) continue;
            ++n;
        }
        return n;
    }

    public boolean supernodeNeeded() {
        return this.isSupernode() && (double)this.getNumInitializedClientConnections() > (double)SettingsManager.instance().getMaxShieldedClientConnections() * 0.7;
    }

    public Authenticator getAuthenticator() {
        return this._authenticator;
    }

    public List getInitializedConnections() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this._initializedConnections);
        return arrayList;
    }

    public List getInitializedClientConnections() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this._initializedClientConnections);
        return arrayList;
    }

    List getInitializedConnections2() {
        return this._initializedConnections;
    }

    public List getInitializedClientConnections2() {
        return this._initializedClientConnections;
    }

    public List getConnections() {
        ArrayList arrayList = new ArrayList(this._connections);
        return arrayList;
    }

    public Set getSupernodeEndpoints() {
        Object object;
        HashSet hashSet = new HashSet();
        Iterator iterator = this._initializedConnections.iterator();
        while (iterator.hasNext()) {
            object = (ManagedConnection)iterator.next();
            if (!((ManagedConnection)object).isSupernodeConnection()) continue;
            hashSet.add(new Endpoint(((Connection)object).getInetAddress().getAddress(), ((Connection)object).getOrigPort()));
        }
        object = this._catcher.getUltrapeerHosts(this.MAX_SUPERNODE_ENDPOINTS);
        while (object.hasNext()) {
            Endpoint endpoint = (Endpoint)object.next();
            hashSet.add(endpoint);
        }
        return hashSet;
    }

    public Endpoint getConnectedGUESSUltrapeer() {
        Iterator iterator = this._initializedConnections.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            if (!managedConnection.isSupernodeConnection() || !managedConnection.isGUESSUltrapeer()) continue;
            return new Endpoint(managedConnection.getInetAddress().getAddress(), managedConnection.getOrigPort());
        }
        return null;
    }

    public List getConnectedGUESSUltrapeers() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this._initializedConnections.iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            if (!managedConnection.isSupernodeConnection() || !managedConnection.isGUESSUltrapeer()) continue;
            arrayList.add(managedConnection);
        }
        return arrayList;
    }

    private void connectionInitializing(Connection connection) {
        ArrayList arrayList = new ArrayList(this._connections);
        arrayList.add(connection);
        this._connections = arrayList;
    }

    protected void connectionInitializingIncoming(ManagedConnection managedConnection) {
        this.connectionInitializing(managedConnection);
    }

    private void connectionInitialized(ManagedConnection managedConnection) {
        if (this._connections.contains(managedConnection)) {
            if (!managedConnection.isSupernodeClientConnection()) {
                ArrayList arrayList = new ArrayList(this._initializedConnections);
                arrayList.add(managedConnection);
                this._initializedConnections = arrayList;
            } else {
                ArrayList arrayList = new ArrayList(this._initializedClientConnections);
                arrayList.add(managedConnection);
                this._initializedClientConnections = arrayList;
            }
        }
    }

    public synchronized void disconnect() {
        SettingsManager settingsManager = SettingsManager.instance();
        int n = settingsManager.getKeepAlive();
        this.setKeepAlive(0);
        Iterator iterator = this.getConnections().iterator();
        while (iterator.hasNext()) {
            ManagedConnection managedConnection = (ManagedConnection)iterator.next();
            this.remove(managedConnection);
            if (!managedConnection.isSupernodeConnection()) continue;
            this._catcher.add(new Endpoint(managedConnection.getInetAddress().getHostAddress(), managedConnection.getPort()), true);
        }
    }

    public synchronized void connect() {
        boolean bl;
        SettingsManager settingsManager = SettingsManager.instance();
        boolean bl2 = bl = !settingsManager.getUseQuickConnect() && this._catcher.getNumHosts() == 0;
        if (bl) {
            this.disconnect();
        }
        this._catcher.expire();
        int n = settingsManager.getKeepAlive();
        if (n < 1) {
            n = 4;
            settingsManager.setKeepAlive(n);
        }
        this.setKeepAlive(n);
        if (bl) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void sendInitialPingRequest(ManagedConnection managedConnection) {
        PingRequest pingRequest;
        if (managedConnection.isRouterConnection()) {
            String string = "none:" + this._settings.getConnectionSpeed();
            pingRequest = this._router.createGroupPingRequest(string);
        } else {
            pingRequest = this.getNumInitializedConnections() >= this._keepAlive ? new PingRequest(1) : new PingRequest(SettingsManager.instance().getTTL());
        }
        managedConnection.send(pingRequest);
        try {
            managedConnection.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void removeInternal(ManagedConnection managedConnection) {
        ArrayList arrayList;
        int n;
        boolean bl = false;
        if (!managedConnection.isSupernodeClientConnection()) {
            n = this._initializedConnections.indexOf(managedConnection);
            if (n != -1) {
                bl = true;
                arrayList = new ArrayList();
                arrayList.addAll(this._initializedConnections);
                arrayList.remove(managedConnection);
                this._initializedConnections = arrayList;
            }
        } else {
            n = this._initializedClientConnections.indexOf(managedConnection);
            if (n != -1) {
                bl = true;
                arrayList = new ArrayList();
                arrayList.addAll(this._initializedClientConnections);
                arrayList.remove(managedConnection);
                this._initializedClientConnections = arrayList;
            }
        }
        if ((n = this._connections.indexOf(managedConnection)) != -1) {
            arrayList = new ArrayList(this._connections);
            arrayList.remove(managedConnection);
            this._connections = arrayList;
        }
        managedConnection.close();
        this._router.removeConnection(managedConnection);
        RouterService.getCallback().connectionClosed(managedConnection);
        QueryUnicaster.instance().purgeQuery(managedConnection);
    }

    private void adjustConnectionFetchers() {
        int n = this.getNumInitializedConnections();
        int n2 = this._keepAlive - n;
        int n3 = Math.min(10, 4 * n2) - this._fetchers.size() - this._initializingFetchedConnections.size();
        while (n3 > 0) {
            new ConnectionFetcher();
            --n3;
        }
        int n4 = this._fetchers.size();
        while (n3 < 0 && n4 > 0) {
            ConnectionFetcher connectionFetcher = (ConnectionFetcher)this._fetchers.remove(--n4);
            connectionFetcher.interrupt();
            ++n3;
        }
        int n5 = this._initializingFetchedConnections.size();
        while (n3 < 0 && n5 > 0) {
            ManagedConnection managedConnection = (ManagedConnection)this._initializingFetchedConnections.remove(--n5);
            this.removeInternal(managedConnection);
            ++n3;
        }
    }

    private void initializeFetchedConnection(ManagedConnection managedConnection, ConnectionFetcher connectionFetcher) throws NoGnutellaOkException, BadHandshakeException, IOException {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            if (connectionFetcher.isInterrupted()) {
                throw new IOException();
            }
            this._initializingFetchedConnections.add(managedConnection);
            this._fetchers.remove(connectionFetcher);
            this.connectionInitializing(managedConnection);
        }
        if (!CommonUtils.isJava118()) {
            ConnectionStat.OUTGOING_CONNECTION_ATTEMPTS.incrementStat();
        }
        RouterService.getCallback().connectionInitializing(managedConnection);
        try {
            try {
                managedConnection.initialize();
            }
            catch (IOException iOException) {
                ConnectionManager connectionManager2 = this;
                synchronized (connectionManager2) {
                    this._initializingFetchedConnections.remove(managedConnection);
                    this.removeInternal(managedConnection);
                    this.adjustConnectionFetchers();
                }
                throw iOException;
            }
            Object var8_7 = null;
            this.processConnectionHeaders(managedConnection);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.processConnectionHeaders(managedConnection);
            throw throwable;
        }
        boolean bl = false;
        ConnectionManager connectionManager3 = this;
        synchronized (connectionManager3) {
            this._initializingFetchedConnections.remove(managedConnection);
            if (this._connections.contains(managedConnection)) {
                this.connectionInitialized(managedConnection);
                bl = true;
            }
        }
        if (bl) {
            RouterService.getCallback().connectionInitialized(managedConnection);
            if (managedConnection.isClientSupernodeConnection()) {
                this.gotShieldedClientSupernodeConnection(managedConnection);
            }
        }
    }

    private synchronized void gotShieldedClientSupernodeConnection(ManagedConnection managedConnection) {
        boolean bl;
        boolean bl2 = bl = this.ultrapeerConnections() == 1 && this._keepAlive > 0;
        if (bl) {
            this.setKeepAlive(3);
        }
    }

    private synchronized void lostShieldedClientSupernodeConnection() {
    }

    private void processConnectionHeaders(ManagedConnection managedConnection) {
        Properties properties = managedConnection.getHeaders();
        if (properties == null) {
            return;
        }
        this.updateHostCache(properties, managedConnection);
        String string = properties.getProperty("Listen-IP");
        if (string == null) {
            string = properties.getProperty("X-My-Address");
        }
        if (string != null && !managedConnection.isOutgoing()) {
            try {
                managedConnection.setOrigPort(Integer.parseInt(string.substring(string.indexOf(58) + 1).trim()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean allowClientMode() {
        int n = this.getNumInitializedConnections() + this.getNumInitializedClientConnections();
        return !this._settings.getForceSupernodeMode() && (!this.isSupernode() || n <= 0);
    }

    private void updateHostCache(Properties properties, ManagedConnection managedConnection) {
        this.updateHostCache(properties.getProperty("X-Try-Ultrapeers"), managedConnection, true);
        this.updateHostCache(properties.getProperty("X-Try"), managedConnection, false);
    }

    private void updateHostCache(String string, ManagedConnection managedConnection, boolean bl) {
        if (string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            Endpoint endpoint;
            String string2 = stringTokenizer.nextToken().trim();
            try {
                endpoint = new Endpoint(string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            this._catcher.add(endpoint, bl);
        }
    }

    private void initializeExternallyGeneratedConnection(ManagedConnection managedConnection) throws IOException {
        ConnectionManager connectionManager;
        if (managedConnection.isOutgoing()) {
            connectionManager = this;
            synchronized (connectionManager) {
                this.connectionInitializing(managedConnection);
                this.adjustConnectionFetchers();
            }
            if (!CommonUtils.isJava118()) {
                ConnectionStat.OUTGOING_CONNECTION_ATTEMPTS.incrementStat();
            }
            RouterService.getCallback().connectionInitializing(managedConnection);
        }
        try {
            try {
                managedConnection.initialize();
            }
            catch (IOException iOException) {
                this.remove(managedConnection);
                throw iOException;
            }
            Object var5_7 = null;
            this.processConnectionHeaders(managedConnection);
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.processConnectionHeaders(managedConnection);
            throw throwable;
        }
        if (!managedConnection.isOutgoing() && !this.allowConnection(managedConnection)) {
            managedConnection.loopToReject(this._catcher);
            throw new IOException("No space for connection");
        }
        if (!managedConnection.isOutgoing()) {
            connectionManager = this;
            synchronized (connectionManager) {
                this.connectionInitializingIncoming(managedConnection);
                this.adjustConnectionFetchers();
            }
            if (!CommonUtils.isJava118()) {
                ConnectionStat.INCOMING_CONNECTION_ATTEMPTS.incrementStat();
            }
            RouterService.getCallback().connectionInitializing(managedConnection);
        }
        boolean bl = false;
        ConnectionManager connectionManager2 = this;
        synchronized (connectionManager2) {
            if (this._connections.contains(managedConnection)) {
                this.connectionInitialized(managedConnection);
                bl = true;
            }
        }
        if (bl) {
            RouterService.getCallback().connectionInitialized(managedConnection);
            if (managedConnection.isClientSupernodeConnection()) {
                this.gotShieldedClientSupernodeConnection(managedConnection);
            }
        }
    }

    private void startConnection(ManagedConnection managedConnection) throws IOException {
        this.sendInitialPingRequest(managedConnection);
        if (managedConnection.isGUESSUltrapeer()) {
            int n = managedConnection.getOrigPort();
            QueryUnicaster.instance().addUnicastEndpoint(managedConnection.getInetAddress(), n);
        }
        managedConnection.loopForMessages();
    }

    public synchronized Iterator getNormalHosts(int n) {
        return this._catcher.getNormalHosts(n);
    }

    private class ConnectionFetcher
    extends Thread {
        public ConnectionFetcher() {
            ConnectionManager.this._fetchers.add(this);
            this.setDaemon(true);
            this.start();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Endpoint endpoint = null;
            do {
                try {
                    endpoint = ConnectionManager.this._catcher.getAnEndpoint();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            } while (ConnectionManager.this.isConnected(endpoint));
            Assert.that(endpoint != null);
            ManagedConnection managedConnection = new ManagedConnection(endpoint.getHostname(), endpoint.getPort(), ConnectionManager.this._router, ConnectionManager.this);
            try {
                try {
                    try {
                        ConnectionManager.this.initializeFetchedConnection(managedConnection, this);
                        ConnectionManager.this._catcher.doneWithConnect(endpoint, true);
                    }
                    catch (NoGnutellaOkException noGnutellaOkException) {
                        ConnectionManager.this._catcher.doneWithConnect(endpoint, true);
                        throw noGnutellaOkException;
                    }
                    catch (IOException iOException) {
                        ConnectionManager.this._catcher.doneWithConnect(endpoint, false);
                        throw iOException;
                    }
                    ConnectionManager.this.startConnection(managedConnection);
                }
                catch (IOException iOException) {
                    Object var6_9 = null;
                    if (!managedConnection.isClientSupernodeConnection()) return;
                    ConnectionManager.this.lostShieldedClientSupernodeConnection();
                    return;
                }
                catch (Throwable throwable) {
                    RouterService.error(12, throwable);
                    Object var6_10 = null;
                    if (!managedConnection.isClientSupernodeConnection()) return;
                    ConnectionManager.this.lostShieldedClientSupernodeConnection();
                    return;
                }
                Object var6_8 = null;
                if (!managedConnection.isClientSupernodeConnection()) return;
            }
            catch (Throwable throwable) {
                Object var6_11 = null;
                if (!managedConnection.isClientSupernodeConnection()) throw throwable;
                ConnectionManager.this.lostShieldedClientSupernodeConnection();
                throw throwable;
            }
            ConnectionManager.this.lostShieldedClientSupernodeConnection();
        }
    }

    private class GroupOutgoingConnectionThread
    extends Thread {
        private ManagedConnection _connection;
        private PingRequest _specialPing;

        public GroupOutgoingConnectionThread(ManagedConnection managedConnection, PingRequest pingRequest) {
            this._connection = managedConnection;
            this._specialPing = pingRequest;
            this.setDaemon(true);
            this.start();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    ConnectionManager.this._router.sendPingRequest(this._specialPing, this._connection);
                    this._connection.loopForMessages();
                }
                catch (IOException iOException) {
                    Object var4_2 = null;
                    if (!this._connection.isClientSupernodeConnection()) return;
                    ConnectionManager.this.lostShieldedClientSupernodeConnection();
                    return;
                }
                catch (Throwable throwable) {
                    RouterService.error(12, throwable);
                    Object var4_3 = null;
                    if (!this._connection.isClientSupernodeConnection()) return;
                    ConnectionManager.this.lostShieldedClientSupernodeConnection();
                    return;
                }
                Object var4_1 = null;
                if (!this._connection.isClientSupernodeConnection()) return;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (!this._connection.isClientSupernodeConnection()) throw throwable;
                ConnectionManager.this.lostShieldedClientSupernodeConnection();
                throw throwable;
            }
            ConnectionManager.this.lostShieldedClientSupernodeConnection();
        }
    }

    private class OutgoingConnectionThread
    extends Thread {
        private ManagedConnection _connection;
        private boolean _doInitialization;

        public OutgoingConnectionThread(ManagedConnection managedConnection, boolean bl) {
            this._connection = managedConnection;
            this._doInitialization = bl;
            this.setDaemon(true);
            this.start();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    if (this._doInitialization) {
                        ConnectionManager.this.initializeExternallyGeneratedConnection(this._connection);
                    }
                    ConnectionManager.this.startConnection(this._connection);
                }
                catch (IOException iOException) {
                    Object var4_2 = null;
                    if (!this._connection.isClientSupernodeConnection()) return;
                    ConnectionManager.this.lostShieldedClientSupernodeConnection();
                    return;
                }
                catch (Throwable throwable) {
                    RouterService.error(12, throwable);
                    Object var4_3 = null;
                    if (!this._connection.isClientSupernodeConnection()) return;
                    ConnectionManager.this.lostShieldedClientSupernodeConnection();
                    return;
                }
                Object var4_1 = null;
                if (!this._connection.isClientSupernodeConnection()) return;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (!this._connection.isClientSupernodeConnection()) throw throwable;
                ConnectionManager.this.lostShieldedClientSupernodeConnection();
                throw throwable;
            }
            ConnectionManager.this.lostShieldedClientSupernodeConnection();
        }
    }

    private static class ManagedConnectionComparator
    implements Comparator {
        private ManagedConnectionComparator() {
        }

        public int compare(Object object, Object object2) {
            ManagedConnection managedConnection = (ManagedConnection)object;
            ManagedConnection managedConnection2 = (ManagedConnection)object2;
            if (managedConnection.isOutgoing() != managedConnection2.isOutgoing()) {
                return managedConnection.isOutgoing() ? -1 : 1;
            }
            int n = managedConnection.getNumMessagesSent() + managedConnection.getNumMessagesReceived();
            int n2 = managedConnection2.getNumMessagesSent() + managedConnection2.getNumMessagesReceived();
            return n - n2;
        }
    }
}

